/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import uchicago.src.sim.engine.AsynchSchedule;
import uchicago.src.sim.engine.BasicAction;
import uchicago.src.sim.engine.IAsynchAgent;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.network.DefaultDrawableNode;

public class AsynchAgent
extends DefaultDrawableNode
implements Serializable,
IAsynchAgent {
    private double utilizedTime = 0.0;
    private double delayMaximum = 0.1;
    private double delayMinimum = 0.1;
    private SimModel model = null;
    private double nextAvailableTime = 0.0;
    private static ArrayList agentList = new ArrayList();
    private static int nextID = 0;
    private int ID = nextID++;
    private AbstractContinousDistribution randomDistribution;

    public AsynchAgent() {
        this((SimModel)null);
    }

    public AsynchAgent(SimModel simModel) {
        this.model = simModel;
        this.randomDistribution = new Uniform((RandomEngine)new MersenneTwister());
        agentList.add(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        agentList.add(this);
        objectInputStream.defaultReadObject();
    }

    public double findNextTaskCompletionTime() {
        this.setNextAvailableTime(Math.max(Math.max(this.getNextAvailableTime(), this.getModel().getTickCount()) + this.getNextDoubleFromTo(this.getDelayMinimum(), this.getDelayMaximum()), 0.0));
        return this.nextAvailableTime;
    }

    private double getNextDoubleFromTo(double d, double d2) {
        double d3 = this.randomDistribution.nextDouble();
        return d3 % (d2 - d) + d;
    }

    public void initialize() {
        this.setNextAvailableTime(((AsynchSchedule)this.getModel().getSchedule()).getCurrentTime());
    }

    public BasicAction scheduleNow(String string) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleNow(this, string, null, null, null);
    }

    public BasicAction scheduleNow(String string, Object object) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleNow(this, string, object, null, null);
    }

    public BasicAction scheduleNow(String string, Object object, Object object2) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleNow(this, string, object, object2, null);
    }

    public BasicAction scheduleNow(String string, Object object, Object object2, Object object3) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleNow(this, string, object, object2, object3);
    }

    public BasicAction scheduleAfterWaiting(String string) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleAfterWaiting(this, string);
    }

    public BasicAction scheduleAfterWaiting(String string, Object object) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleAfterWaiting(this, string, object);
    }

    public BasicAction scheduleAfterWaiting(String string, Object object, Object object2) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleAfterWaiting(this, string, object, object2);
    }

    public BasicAction scheduleAfterWaiting(String string, Object object, Object object2, Object object3) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleAfterWaiting(this, string, object, object2, object3);
    }

    public BasicAction scheduleWhenAvailable(String string) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleWhenAvailable(this, string);
    }

    public BasicAction scheduleWhenAvailable(String string, Object object) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleWhenAvailable(this, string, object);
    }

    public BasicAction scheduleWhenAvailable(String string, Object object, Object object2) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleWhenAvailable(this, string, object, object2);
    }

    public BasicAction scheduleWhenAvailable(String string, Object object, Object object2, Object object3) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleWhenAvailable(this, string, object, object2, object3);
    }

    public BasicAction scheduleAt(double d, String string) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleAt(d, this, string);
    }

    public BasicAction scheduleAt(double d, String string, Object object) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleAt(d, this, string, object);
    }

    public BasicAction scheduleAt(double d, String string, Object object, Object object2) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleAt(d, this, string, object, object2);
    }

    public BasicAction scheduleAt(double d, String string, Object object, Object object2, Object object3) {
        return ((AsynchSchedule)this.getModel().getSchedule()).scheduleAt(d, this, string, object, object2, object3);
    }

    public double getDelayMaximum() {
        return this.delayMaximum;
    }

    public double getDelayMinimum() {
        return this.delayMinimum;
    }

    public SimModel getModel() {
        return this.model;
    }

    public double getNextAvailableTime() {
        this.nextAvailableTime = Math.max(this.nextAvailableTime, Math.max(this.nextAvailableTime, this.getModel().getTickCount()) + this.getNextDelay());
        return this.nextAvailableTime;
    }

    public double getNextDelay() {
        return this.getNextDoubleFromTo(this.getDelayMinimum(), this.getDelayMaximum());
    }

    public void setDelayMaximum(double d) {
        this.delayMaximum = d;
    }

    public void setDelayMinimum(double d) {
        this.delayMinimum = d;
    }

    public void setModel(SimModel simModel) {
        this.model = simModel;
    }

    public void setNextAvailableTime(double d) {
        this.utilizedTime += Math.max(d - Math.max(this.nextAvailableTime, this.getModel().getTickCount()), 0.0);
        this.nextAvailableTime = Math.max(this.nextAvailableTime, d);
    }

    public double getUtilization() {
        if (this.model != null) {
            double d = ((AsynchSchedule)this.getModel().getSchedule()).getTotalTime();
            if (d == 0.0) {
                return 0.0;
            }
            return Math.min(this.utilizedTime / d, 1.0);
        }
        return 0.0;
    }

    public void clearUtilization() {
        this.utilizedTime = 0.0;
    }

    public static ArrayList getAgentList() {
        return agentList;
    }

    public static void setAgentList(ArrayList arrayList) {
        agentList = arrayList;
    }

    public int getID() {
        return this.ID;
    }

    public double getUtilizedTime() {
        return Math.min(this.utilizedTime, this.getModel().getTickCount());
    }

    public void setID(int n) {
        this.ID = n;
    }

    public void setUtilizedTime(double d) {
        this.utilizedTime = d;
    }

    public AbstractContinousDistribution getRandomDistribution() {
        return this.randomDistribution;
    }

    public void setRandomDistribution(AbstractContinousDistribution abstractContinousDistribution) {
        this.randomDistribution = abstractContinousDistribution;
    }
}

