/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import uchicago.src.sim.gui.DisplaySurface;
import uchicago.src.sim.gui.DrawableNonGridNode;
import uchicago.src.sim.gui.LayoutWithDisplay;
import uchicago.src.sim.network.NetUtilities;

public class KamadaGraphLayout
extends LayoutWithDisplay
implements ActionListener {
    private double springConst = 1.0;
    private double minEpsilon = 1.0;
    private int maxPasses = 5000;
    private boolean circleLayout = false;
    private boolean rescaleLayout = true;
    private boolean animate = true;
    private int pad = 20;
    private int updates = 0;
    private boolean stop = false;
    private boolean firstLayout = true;

    public KamadaGraphLayout(int n, int n2) {
        super(n, n2);
    }

    public KamadaGraphLayout(List list, int n, int n2) {
        super(list, n, n2);
    }

    public KamadaGraphLayout(List list, int n, int n2, DisplaySurface displaySurface, int n3) {
        super(list, n, n2, displaySurface);
        this.updates = n3;
    }

    public void setPad(int n) {
        this.pad = n;
    }

    public void setUpdateEveryN(int n) {
        this.updates = n;
    }

    public void setMinEpsilon(double d) {
        this.minEpsilon = d;
    }

    public void setSpringConst(double d) {
        this.springConst = d;
    }

    public void setMaxPasses(int n) {
        this.maxPasses = n;
    }

    public void setCircleLayout(boolean bl) {
        this.circleLayout = bl;
        this.firstLayout = false;
    }

    public void setRescaleLayout(boolean bl) {
        this.rescaleLayout = bl;
    }

    public void setAnimateTransitions(boolean bl) {
        this.animate = bl;
    }

    public void circleLayout() {
        int n = this.nodeList.size();
        int n2 = this.width / 2;
        int n3 = this.height / 2;
        int n4 = this.height > this.width ? this.width / 2 - this.pad * 2 : this.height / 2 - this.pad * 2;
        for (int i = 0; i < n; ++i) {
            DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)this.nodeList.get(i);
            drawableNonGridNode.setX((double)n4 * Math.cos(Math.PI * 2 * (double)i / (double)n) + (double)n2);
            drawableNonGridNode.setY((double)n4 * Math.sin(Math.PI * 2 * (double)i / (double)n) + (double)n3);
        }
    }

    private DenseDoubleMatrix2D calcKMatrix(DenseDoubleMatrix2D denseDoubleMatrix2D, double d) {
        int n = denseDoubleMatrix2D.rows();
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d2 = denseDoubleMatrix2D.getQuick(i, j);
                denseDoubleMatrix2D2.setQuick(i, j, d / (d2 * d2));
            }
        }
        return denseDoubleMatrix2D2;
    }

    private DenseDoubleMatrix2D calcLMatrix(DenseDoubleMatrix2D denseDoubleMatrix2D, double d) {
        int n = denseDoubleMatrix2D.rows();
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                denseDoubleMatrix2D2.setQuick(i, j, d * denseDoubleMatrix2D.getQuick(i, j));
            }
        }
        return denseDoubleMatrix2D2;
    }

    private int getDiam(DenseDoubleMatrix2D denseDoubleMatrix2D) {
        int n = denseDoubleMatrix2D.rows();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                d = Math.max(d, denseDoubleMatrix2D.getQuick(i, j));
            }
        }
        return (int)d;
    }

    public void updateLayout() {
        if (this.update) {
            this.isEventThread = SwingUtilities.isEventDispatchThread();
            this.stop = false;
            if (this.circleLayout) {
                this.circleLayout();
            }
            if (this.firstLayout) {
                this.firstLayout = false;
                this.circleLayout();
            }
            ArrayList arrayList = NetUtilities.getComponents(this.nodeList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && !this.stop) {
                ArrayList arrayList2 = (ArrayList)iterator.next();
                if (arrayList2.size() <= 1) continue;
                this.runKamadaOn(arrayList2);
            }
            if (this.rescaleLayout) {
                this.rescalePositions(this.nodeList);
            }
        }
    }

    private void runKamadaOn(ArrayList arrayList) {
        double d;
        int n;
        int n2 = arrayList.size();
        DenseDoubleMatrix2D denseDoubleMatrix2D = NetUtilities.getAllShortPathMatrix(arrayList);
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = this.calcKMatrix(denseDoubleMatrix2D, this.springConst);
        double d2 = Math.min(this.width, this.height) / Math.max(this.getDiam(denseDoubleMatrix2D), 1);
        DenseDoubleMatrix2D denseDoubleMatrix2D3 = this.calcLMatrix(denseDoubleMatrix2D, d2);
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)arrayList.get(i);
            dArray[i] = drawableNonGridNode.getX();
            dArray2[i] = drawableNonGridNode.getY();
            n3 += drawableNonGridNode.getOutEdges().size();
        }
        double d3 = this.getEnergy(denseDoubleMatrix2D3, denseDoubleMatrix2D2, dArray, dArray2);
        double d4 = d3 / (double)n2;
        int n4 = 0;
        double d5 = this.getDeltaM(0, denseDoubleMatrix2D3, denseDoubleMatrix2D2, dArray, dArray2);
        for (n = 1; n < n2; ++n) {
            d = this.getDeltaM(n, denseDoubleMatrix2D3, denseDoubleMatrix2D2, dArray, dArray2);
            if (!(d > d5)) continue;
            d5 = d;
            n4 = n;
        }
        n = 0;
        int n5 = 0;
        while (d4 > this.minEpsilon && !this.stop) {
            double d6 = d5 + 1.0;
            while (d5 > d4 && d6 - d5 > 0.1 && !this.stop) {
                int n6;
                double d7 = d5;
                while (d7 > d4 && !this.stop) {
                    double[] dArray3 = this.getDeltas(n4, denseDoubleMatrix2D3, denseDoubleMatrix2D2, dArray, dArray2);
                    int n7 = n4;
                    dArray[n7] = dArray[n7] + dArray3[0];
                    int n8 = n4;
                    dArray2[n8] = dArray2[n8] + dArray3[1];
                    d7 = this.getDeltaM(n4, denseDoubleMatrix2D3, denseDoubleMatrix2D2, dArray, dArray2);
                    if (++n5 <= this.maxPasses) continue;
                    this.stop = true;
                }
                n4 = 0;
                d5 = this.getDeltaM(0, denseDoubleMatrix2D3, denseDoubleMatrix2D2, dArray, dArray2);
                for (n6 = 1; n6 < n2; ++n6) {
                    d = this.getDeltaM(n6, denseDoubleMatrix2D3, denseDoubleMatrix2D2, dArray, dArray2);
                    if (!(d > d5)) continue;
                    d5 = d;
                    n4 = n6;
                }
                if (this.updates > 0 && n % this.updates == 0) {
                    for (n6 = 0; n6 < n2; ++n6) {
                        DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)arrayList.get(n6);
                        drawableNonGridNode.setX(dArray[n6]);
                        drawableNonGridNode.setY(dArray2[n6]);
                    }
                    this.updateDisplay();
                }
                ++n;
            }
            d4 -= d4 / 4.0;
        }
        if (this.animate) {
            this.animateTransition(8, arrayList, dArray, dArray2);
        } else {
            for (int i = 0; i < n2; ++i) {
                DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)arrayList.get(i);
                drawableNonGridNode.setX(dArray[i]);
                drawableNonGridNode.setY(dArray2[i]);
            }
        }
    }

    private double[] getDeltas(int n, DenseDoubleMatrix2D denseDoubleMatrix2D, DenseDoubleMatrix2D denseDoubleMatrix2D2, double[] dArray, double[] dArray2) {
        int n2 = denseDoubleMatrix2D.rows();
        double[] dArray3 = new double[2];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (n == i) continue;
            double d7 = dArray[n] - dArray[i];
            double d8 = dArray2[n] - dArray2[i];
            double d9 = Math.sqrt(d7 * d7 + d8 * d8);
            double d10 = denseDoubleMatrix2D2.getQuick(n, i);
            double d11 = denseDoubleMatrix2D.getQuick(n, i);
            double d12 = d9 * d9 * d9;
            d += d10 * (d7 - d11 * d7 / d9);
            d2 += d10 * (d8 - d11 * d8 / d9);
            d3 += d10 * (1.0 - d11 * d8 * d8 / d12);
            d4 += d10 * (d11 * d7 * d8 / d12);
            d5 += d10 * (d11 * d8 * d7 / d12);
            d6 += d10 * (1.0 - d11 * d7 * d7 / d12);
        }
        dArray3[0] = (-d * d6 - d4 * -d2) / (d3 * d6 - d4 * d5);
        dArray3[1] = (d3 * -d2 - -d * d5) / (d3 * d6 - d4 * d5);
        return dArray3;
    }

    private double getDeltaM(int n, DenseDoubleMatrix2D denseDoubleMatrix2D, DenseDoubleMatrix2D denseDoubleMatrix2D2, double[] dArray, double[] dArray2) {
        int n2 = denseDoubleMatrix2D.rows();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (n == i) continue;
            double d4 = dArray[n] - dArray[i];
            double d5 = dArray2[n] - dArray2[i];
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            double d7 = denseDoubleMatrix2D2.getQuick(n, i);
            double d8 = denseDoubleMatrix2D.getQuick(n, i);
            d2 += d7 * (d4 - d8 * d4 / d6);
            d3 += d7 * (d5 - d8 * d5 / d6);
        }
        d = Math.sqrt(d2 * d2 + d3 * d3);
        return d;
    }

    private void rescalePositions(ArrayList arrayList) {
        int n;
        int n2 = arrayList.size();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        if (n2 == 0) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)arrayList.get(i);
            dArray[i] = drawableNonGridNode.getX();
            dArray2[i] = drawableNonGridNode.getY();
        }
        double d = dArray[0];
        double d2 = dArray2[0];
        double d3 = dArray[0];
        double d4 = dArray2[0];
        for (n = 1; n < n2; ++n) {
            d = Math.max(d, dArray[n]);
            d2 = Math.max(d2, dArray2[n]);
            d3 = Math.min(d3, dArray[n]);
            d4 = Math.min(d4, dArray2[n]);
        }
        if (d == d3) {
            d3 = 0.0;
            d *= 2.0;
        }
        if (d2 == d4) {
            d4 = 0.0;
            d2 *= 2.0;
        }
        for (n = 0; n < n2; ++n) {
            dArray[n] = (dArray[n] - d3) / (d - d3) * (double)(this.width - this.pad);
            dArray2[n] = (dArray2[n] - d4) / (d2 - d4) * (double)(this.height - this.pad);
        }
        n = 5;
        if (this.animate) {
            this.animateTransition(n, arrayList, dArray, dArray2);
        } else {
            for (int i = 0; i < n2; ++i) {
                DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)arrayList.get(i);
                drawableNonGridNode.setX(dArray[i]);
                drawableNonGridNode.setY(dArray2[i]);
            }
            if (this.display != null) {
                this.updateDisplay();
            }
        }
    }

    private void animateTransition(int n, ArrayList arrayList, double[] dArray, double[] dArray2) {
        int n2 = arrayList.size();
        for (int i = 1; i <= n; ++i) {
            this.updateDisplay();
            for (int j = 0; j < n2; ++j) {
                DrawableNonGridNode drawableNonGridNode = (DrawableNonGridNode)arrayList.get(j);
                drawableNonGridNode.setX(drawableNonGridNode.getX() + (dArray[j] - drawableNonGridNode.getX()) * (double)i / (double)n);
                drawableNonGridNode.setY(drawableNonGridNode.getY() + (dArray2[j] - drawableNonGridNode.getY()) * (double)i / (double)n);
            }
        }
    }

    private double getEnergy(DenseDoubleMatrix2D denseDoubleMatrix2D, DenseDoubleMatrix2D denseDoubleMatrix2D2, double[] dArray, double[] dArray2) {
        int n = denseDoubleMatrix2D.rows();
        double d = 0.0;
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double d2 = dArray[i] - dArray[j];
                double d3 = dArray2[i] - dArray2[j];
                double d4 = denseDoubleMatrix2D.getQuick(i, j);
                d += 0.5 * denseDoubleMatrix2D2.getQuick(i, j) * (d2 * d2 + d3 * d3 + d4 * d4 - 2.0 * d4 * Math.sqrt(d2 * d2 + d3 * d3));
            }
        }
        return d;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.stop = true;
    }
}

