/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.guiUtils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    protected static final int DEFAULT_SIZE = 32;
    protected static final int BORDER_SIZE = 2;
    protected Color color;
    protected Color shadowColor;
    protected int width;
    protected int height;
    protected int borderSize;
    protected int fillHeight;
    protected int fillWidth;

    public ColorIcon(Color color, int n, int n2, int n3) {
        this.color = color;
        this.width = n;
        this.height = n2;
        this.borderSize = n3;
        this.shadowColor = Color.black;
        this.fillHeight = n2 - 2 * n3;
        this.fillWidth = n - 2 * n3;
    }

    public ColorIcon(Color color, int n) {
        this(color, n, n, 2);
    }

    public ColorIcon(Color color) {
        this(color, 32, 32, 2);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color = graphics.getColor();
        if (this.borderSize > 0) {
            graphics.setColor(this.shadowColor);
            for (int i = 0; i < this.borderSize; ++i) {
                graphics.drawRect(n + i, n2 + i, this.width - 2 * i - 1, this.height - 2 * i - 1);
            }
        }
        graphics.setColor(this.color);
        graphics.fillRect(n + this.borderSize, n2 + this.borderSize, this.fillWidth, this.fillHeight);
        graphics.setColor(color);
    }
}

