/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcSolver;
import ilog.solver.hg;
import ilog.solver.uq;
import ilog.solver.ys;

final class zt
extends uq {
    ys cpb;
    ys dpb;

    public zt(ys ys2, ys ys3) {
        this.cpb = ys2;
        this.dpb = ys3;
        ys2.isUsed(this);
        ys3.isUsed(this);
        this.getSolver();
        this.initOverflow();
    }

    protected final hg[] getVars() {
        return new hg[]{this.cpb, this.dpb};
    }

    public IlcSolver getSolver() {
        return this.cpb.getSolver();
    }

    protected final boolean isOverflowSafe() {
        return !this.cpb.gr() && !this.dpb.gr() && this.cpb.getDomainMin() > -715827882 && this.cpb.getDomainMax() < 0x2AAAAAAA && this.dpb.getDomainMin() > -715827882 && this.dpb.getDomainMax() < 0x2AAAAAAA;
    }

    public int getDomainSizeInternal() {
        if (this.cpb.isBound()) {
            return this.dpb.getDomainSize();
        }
        if (this.dpb.isBound()) {
            return this.cpb.getDomainSize();
        }
        return ys.safeCastPosLong((long)this.getDomainMax() - (long)this.getDomainMin() + 1L);
    }

    protected boolean isInDomainInternal(int n2) {
        this.getSolver();
        if (this.gr()) {
            if (this.cpb.isBound()) {
                return this.dpb.isInDomainLong((long)n2 - (long)this.cpb.getDomainMin());
            }
            if (this.dpb.isBound()) {
                return this.cpb.isInDomainLong((long)n2 - (long)this.dpb.getDomainMin());
            }
            return true;
        }
        if (this.cpb.isBound()) {
            return this.dpb.isInDomain(n2 - this.cpb.getDomainMin());
        }
        if (this.dpb.isBound()) {
            return this.cpb.isInDomain(n2 - this.dpb.getDomainMin());
        }
        return true;
    }

    protected void computeRange() {
        this.getSolver();
        if (this.gr()) {
            this.safeSetBoundsLong((long)this.cpb.getDomainMin() + (long)this.dpb.getDomainMin(), (long)this.cpb.getDomainMax() + (long)this.dpb.getDomainMax());
        } else {
            this.ljb = this.cpb.getDomainMin() + this.dpb.getDomainMin();
            this.mjb = this.cpb.getDomainMax() + this.dpb.getDomainMax();
        }
    }

    protected void setRangeInternal(int n2, int n3) {
        this.getSolver();
        if (this.gr()) {
            long l2 = this.dpb.getDomainMin();
            long l3 = this.dpb.getDomainMax();
            this.cpb.setDomainRangeLong((long)n2 - l3, (long)n3 - l2);
            long l4 = this.cpb.getDomainMin();
            long l5 = this.cpb.getDomainMax();
            this.dpb.setDomainRangeLong((long)n2 - l5, (long)n3 - l4);
        } else {
            int n4 = this.dpb.getDomainMin();
            int n5 = this.dpb.getDomainMax();
            this.cpb.setDomainRange(n2 - n5, n3 - n4);
            int n6 = this.cpb.getDomainMin();
            int n7 = this.cpb.getDomainMax();
            this.dpb.setDomainRange(n2 - n7, n3 - n6);
        }
    }

    protected void removeValueInternal(int n2) {
        this.getSolver();
        if (this.gr()) {
            if (this.cpb.isBound() && this.dpb.holesOK()) {
                this.dpb.removeDomainValueLong((long)n2 - (long)this.cpb.getDomainMin());
            }
            if (this.dpb.isBound() && this.cpb.holesOK()) {
                this.cpb.removeDomainValueLong((long)n2 - (long)this.dpb.getDomainMin());
            }
        } else {
            if (this.cpb.isBound() && this.dpb.holesOK()) {
                this.dpb.removeDomainValue(n2 - this.cpb.getDomainMin());
            }
            if (this.dpb.isBound() && this.cpb.holesOK()) {
                this.cpb.removeDomainValue(n2 - this.dpb.getDomainMin());
            }
        }
    }

    protected void removeIntervalInternal(int n2, int n3) {
        this.getSolver();
        if (this.gr()) {
            long l2;
            long l3;
            long l4;
            long l5 = (long)n2 - (long)this.dpb.getDomainMin();
            if (l5 <= (l4 = (long)n3 - (long)this.dpb.getDomainMax()) && this.cpb.holesOK()) {
                this.cpb.removeDomainIntervalLong(l5, l4);
            }
            if ((l3 = (long)n2 - (long)this.cpb.getDomainMin()) <= (l2 = (long)n3 - (long)this.cpb.getDomainMax()) && this.dpb.holesOK()) {
                this.dpb.removeDomainIntervalLong(l3, l2);
            }
        } else {
            int n4;
            int n5;
            int n6;
            int n7 = n2 - this.dpb.getDomainMin();
            if (n7 <= (n6 = n3 - this.dpb.getDomainMax()) && this.cpb.holesOK()) {
                this.cpb.removeDomainInterval(n7, n6);
            }
            if ((n5 = n2 - this.cpb.getDomainMin()) <= (n4 = n3 - this.cpb.getDomainMax()) && this.dpb.holesOK()) {
                this.dpb.removeDomainInterval(n5, n4);
            }
        }
    }

    public synchronized String toString() {
        if (this.ojb != null) {
            return this.ojb.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.cpb);
        stringBuffer.append(" + ");
        stringBuffer.append(this.dpb);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

