/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloDecDomain;
import ilog.concert.IloDecVar;
import ilog.concert.IloException;
import ilog.concert.IloStorable;
import ilog.concert.model.IlcDecDomain;
import ilog.solver.IlcDec;
import ilog.solver.IlcDecExpr;
import ilog.solver.IlcGoal;
import ilog.solver.IlcInstantiable;
import ilog.solver.IlcIntVar;
import ilog.solver.IlcSolver;
import ilog.solver.gbb;
import ilog.solver.no;
import ilog.solver.nu;
import ilog.solver.sv;
import java.util.Iterator;

public final class IlcDecVar
extends IlcDecExpr
implements IloDecVar,
IlcInstantiable,
IloStorable {
    protected String _name = null;
    protected IlcDecDomain _domain = null;
    int ye = -1;
    boolean ze = false;
    IlcIntVar af = null;

    public final int getScale() {
        return this._domain.getScale();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    IlcDecVar(IloDecDomain iloDecDomain, String string) throws IloException {
        IlcDecDomain ilcDecDomain = (IlcDecDomain)iloDecDomain;
        this._name = string;
        this.ze = ilcDecDomain.isEnumerated();
        this._domain = ilcDecDomain;
    }

    IlcDecVar(IloDecDomain iloDecDomain) throws IloException {
        this(iloDecDomain, null);
    }

    IlcDecVar(double d2, double d3, int n2, String string) throws IloException {
        this._name = string;
        this._domain = new IlcDecDomain(d2, d3, n2);
    }

    IlcDecVar(double d2, double d3, int n2) throws IloException {
        this(d2, d3, n2, null);
    }

    IlcDecVar(String string, String string2, String string3) throws IloException {
        this._name = string3;
        this._domain = new IlcDecDomain(string, string2);
    }

    IlcDecVar(String string, String string2) throws IloException {
        this(string, string2, null);
    }

    IlcDecVar(String string, String string2, int n2) throws IloException {
        this(string, string2, n2, null);
    }

    IlcDecVar(String string, String string2, int n2, String string3) throws IloException {
        this._name = string3;
        this._domain = new IlcDecDomain(string, string2, n2);
    }

    IlcDecVar(long l2, long l3, int n2, String string) throws IloException {
        this._name = string;
        this._domain = new IlcDecDomain(l2, l3, n2);
    }

    IlcDecVar(long l2, long l3, int n2) throws IloException {
        this(l2, l3, n2, (String)null);
    }

    IlcDecVar(String[] stringArray, String string) throws IloException {
        this._name = string;
        this.ze = true;
        if (!IlcDec.hasSamePrecision(stringArray)) {
            throw new IloException("All decimal numbers should have the same scale.");
        }
        this._domain = new IlcDecDomain(stringArray);
    }

    IlcDecVar(String[] stringArray, int n2, String string) throws IloException {
        this._name = string;
        this.ze = true;
        this._domain = new IlcDecDomain(stringArray, n2);
    }

    IlcDecVar(String[] stringArray, int n2) throws IloException {
        this(stringArray, n2, null);
    }

    IlcDecVar(String[] stringArray) throws IloException {
        this(stringArray, null);
    }

    IlcDecVar(long[] lArray, int n2, String string) throws IloException {
        this._name = string;
        this.ze = true;
        this._domain = new IlcDecDomain(lArray, n2);
    }

    IlcDecVar(long[] lArray, int n2) throws IloException {
        this(lArray, n2, null);
    }

    public boolean isEnumerated() {
        return this.ze;
    }

    public boolean isIndexable() {
        return this._domain.isIndexable();
    }

    public int getIndex(double d2) throws IloException {
        return this._domain.getIndex(d2);
    }

    public int getIndexOfUnscaled(double d2) throws IloException {
        return this._domain.getIndexOfUnscaled(d2);
    }

    public int getIndexOfScaled(double d2) throws IloException {
        return this._domain.getIndexOfScaled(d2);
    }

    public IlcIntVar getIndexVar() throws IloException {
        if (!(this._extracted instanceof nu)) {
            return ((sv)this._extracted).getIndexVar(this);
        }
        throw new IloException("The index variable is not reachable when the decimal variable not extracted");
    }

    public void linkIndexVar(IlcIntVar ilcIntVar) throws IloException {
        ((sv)this._extracted).setIndexVar(ilcIntVar);
    }

    public boolean isIndexVarNull() throws IloException {
        return ((sv)this._extracted).isIndexVarNull();
    }

    public double getLB() {
        return this._domain.getLB();
    }

    public double getUB() {
        return this._domain.getUB();
    }

    public void setUnscaledLB(long l2) throws IloException {
        this.setLB(IlcDec.getScaledLB(l2, this.getScale()));
    }

    public void setUnscaledUB(long l2) throws IloException {
        this.setUB(IlcDec.getScaledUB(l2, this.getScale()));
    }

    public void setLB(double d2) throws IloException {
        this._domain.setLB(d2);
    }

    public void setUB(double d2) throws IloException {
        this._domain.setUB(d2);
    }

    public Iterator unscaledDomainIterator() {
        return ((gbb)this.getExtracted(this._extracted.getSolver())).unscaledDomainIterator();
    }

    public long getUnscaledDomainLB() {
        return ((gbb)this.getExtracted(this._extracted.getSolver())).getUnscaledDomainLB();
    }

    public long getUnscaledDomainUB() {
        return ((gbb)this.getExtracted(this._extracted.getSolver())).getUnscaledDomainUB();
    }

    public void setUnscaledDomainLB(long l2) {
        ((gbb)this.getExtracted(this._extracted.getSolver())).setUnscaledDomainLB(l2);
    }

    public void setUnscaledDomainUB(long l2) {
        ((gbb)this.getExtracted(this._extracted.getSolver())).setUnscaledDomainUB(l2);
    }

    public void setUnscaledDomainRange(long l2, long l3) {
        ((gbb)this.getExtracted(this._extracted.getSolver())).setUnscaledDomainRange(l2, l3);
    }

    public void setUnscaledDomainValue(long l2) {
        ((gbb)this.getExtracted(this._extracted.getSolver())).setUnscaledDomainValue(l2);
    }

    public void removeUnscaledDomainValue(long l2) {
        ((gbb)this.getExtracted(this._extracted.getSolver())).removeUnscaledDomainValue(l2);
    }

    public void setUnscaledDomainLB(double d2) {
        ((gbb)this.getExtracted(this._extracted.getSolver())).setUnscaledDomainLB(d2);
    }

    public void setUnscaledDomainUB(double d2) {
        ((gbb)this.getExtracted(this._extracted.getSolver())).setUnscaledDomainUB(d2);
    }

    public void setUnscaledDomainRange(double d2, double d3) {
        ((gbb)this.getExtracted(this._extracted.getSolver())).setUnscaledDomainRange(d2, d3);
    }

    public void setUnscaledDomainValue(double d2) {
        ((gbb)this.getExtracted(this._extracted.getSolver())).setUnscaledDomainValue(d2);
    }

    public void removeUnscaledDomainValue(double d2) {
        ((gbb)this.getExtracted(this._extracted.getSolver())).removeUnscaledDomainValue(d2);
    }

    public double getUnscaledNextLower(double d2) {
        return ((gbb)this.getExtracted(this._extracted.getSolver())).getUnscaledNextLower(d2);
    }

    public double getUnscaledNextHigher(double d2) {
        return ((gbb)this.getExtracted(this._extracted.getSolver())).getUnscaledNextHigher(d2);
    }

    public int getSize() {
        return this._domain.getSize();
    }

    public boolean isDomainEnumerated() {
        return ((sv)this.getExtracted(this._extracted.getSolver())).isDomainEnumerated();
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        ilcSolver.addVar(this);
        sv sv2 = this.ze ? new sv(ilcSolver, this._domain.getIntervals(), this._domain.getScale()) : new sv(ilcSolver, this._domain.getLB(), this._domain.getUB(), this._domain.getScale());
        sv2.ntb = this._name;
        return sv2;
    }

    public synchronized String toString() {
        if (!(this._extracted instanceof nu)) {
            return this._extracted.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this._name != null) {
            stringBuffer.append(this._name);
        }
        stringBuffer.append(this._domain);
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        return iloCPModeler.decVar((IloDecDomain)iloCopyManager.getCopy(this._domain), this._name);
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        if (check instanceof IloCopyManager.ExistGroundTerm) {
            throw check;
        }
        this._domain.needCopy(check);
    }

    public IlcGoal initDefaultGoal(IlcSolver ilcSolver) {
        return new no(this);
    }
}

