/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import java.util.ArrayList;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.network.Node;
import uchicago.src.sim.util.RepastException;
import uchicago.src.sim.util.SimUtilities;

public class SquareLatticeNet {
    Class nodeClass;
    Class edgeClass;
    int nCols = -1;
    int nRows = -1;
    int nNodes;
    int radius = -1;
    boolean torus = true;

    public SquareLatticeNet() {
    }

    public SquareLatticeNet(Class clazz, Class clazz2) {
        this.nodeClass = clazz;
        this.edgeClass = clazz2;
    }

    public SquareLatticeNet(Class clazz, Class clazz2, int n, int n2) {
        this.nodeClass = clazz;
        this.edgeClass = clazz2;
        this.nCols = n;
        this.nRows = n2;
        this.nNodes = this.nCols * this.nRows;
    }

    public SquareLatticeNet(Class clazz, Class clazz2, int n, int n2, boolean bl, int n3) {
        this.nodeClass = clazz;
        this.edgeClass = clazz2;
        this.nCols = n;
        this.nRows = n2;
        this.nNodes = this.nCols * this.nRows;
        this.torus = bl;
        this.radius = n3;
    }

    public Class getNodeClass() {
        return this.nodeClass;
    }

    public void setNodeClass(Class clazz) {
        this.nodeClass = clazz;
    }

    public Class getEdgeClass() {
        return this.edgeClass;
    }

    public void setEdgeClass(Class clazz) {
        this.edgeClass = clazz;
    }

    public int getNumCols() {
        return this.nCols;
    }

    public int getNumRows() {
        return this.nRows;
    }

    public void setDimension(int n, int n2) {
        this.nCols = n;
        this.nRows = n2;
        this.nNodes = this.nCols * this.nRows;
    }

    public int getSize() {
        return this.nNodes;
    }

    public int getConnectRadius() {
        return this.radius;
    }

    public void setConnectRadius(int n) {
        this.radius = n;
    }

    public boolean isWrapAround() {
        return this.torus;
    }

    public void setWrapAround(boolean bl) {
        this.torus = bl;
    }

    public boolean isSymmetric() {
        return true;
    }

    public ArrayList createSquareLatticeNet() throws IllegalAccessException, InstantiationException {
        int n;
        RepastException repastException;
        Object object;
        if (this.nodeClass == null || this.edgeClass == null) {
            object = "Unable to construct lattice: nodeClass or edgeClass was not set.";
            repastException = new RepastException((String)object);
            SimUtilities.showError((String)object, repastException);
        }
        if (this.nNodes < 0 || this.nRows < 1 || this.nCols < 1) {
            object = "Unable to construct lattice: dimensions out of range";
            repastException = new RepastException((String)object);
            SimUtilities.showError((String)object, repastException);
        }
        object = new ArrayList(this.nNodes);
        for (n = 0; n < this.nNodes; ++n) {
            ((ArrayList)object).add((Node)this.nodeClass.newInstance());
        }
        if (this.torus) {
            for (n = 0; n < this.nNodes; ++n) {
                Node node = (Node)((ArrayList)object).get(n);
                int n2 = n % this.nCols;
                int n3 = (int)Math.floor(n / this.nCols);
                for (int i = 1; i <= this.radius; ++i) {
                    Edge edge;
                    Edge edge2;
                    Node node2;
                    int n4 = n3;
                    int n5 = (n2 + i) % this.nCols;
                    int n6 = n4 * this.nCols + n5;
                    if (n != n6) {
                        node2 = (Node)((ArrayList)object).get(n6);
                        edge2 = (Edge)this.edgeClass.newInstance();
                        edge2.setFrom(node);
                        edge2.setTo(node2);
                        node.addOutEdge(edge2);
                        node2.addInEdge(edge2);
                        edge = (Edge)this.edgeClass.newInstance();
                        edge.setFrom(node2);
                        edge.setTo(node);
                        node2.addOutEdge(edge);
                        node.addInEdge(edge);
                    }
                    if (n == (n6 = (n4 = (n3 + i) % this.nRows) * this.nCols + (n5 = n2))) continue;
                    node2 = (Node)((ArrayList)object).get(n6);
                    edge2 = (Edge)this.edgeClass.newInstance();
                    edge2.setFrom(node);
                    edge2.setTo(node2);
                    node.addOutEdge(edge2);
                    node2.addInEdge(edge2);
                    edge = (Edge)this.edgeClass.newInstance();
                    edge.setFrom(node2);
                    edge.setTo(node);
                    node2.addOutEdge(edge);
                    node.addInEdge(edge);
                }
            }
        } else {
            for (n = 0; n < this.nNodes; ++n) {
                Node node = (Node)((ArrayList)object).get(n);
                for (int i = 1; i <= this.radius; ++i) {
                    Edge edge;
                    Edge edge3;
                    Node node3;
                    int n7 = n + i;
                    if (n7 <= (int)Math.floor(n / this.nCols) * this.nCols + this.nCols - 1) {
                        node3 = (Node)((ArrayList)object).get(n7);
                        edge3 = (Edge)this.edgeClass.newInstance();
                        edge3.setFrom(node);
                        edge3.setTo(node3);
                        node.addOutEdge(edge3);
                        node3.addInEdge(edge3);
                        edge = (Edge)this.edgeClass.newInstance();
                        edge.setFrom(node3);
                        edge.setTo(node);
                        node3.addOutEdge(edge);
                        node.addInEdge(edge);
                    }
                    if ((n7 = n + i * this.nCols) > this.nCols * this.nRows - this.nCols + n % this.nCols) continue;
                    node3 = (Node)((ArrayList)object).get(n7);
                    edge3 = (Edge)this.edgeClass.newInstance();
                    edge3.setFrom(node);
                    edge3.setTo(node3);
                    node.addOutEdge(edge3);
                    node3.addInEdge(edge3);
                    edge = (Edge)this.edgeClass.newInstance();
                    edge.setFrom(node3);
                    edge.setTo(node);
                    node3.addOutEdge(edge);
                    node.addInEdge(edge);
                }
            }
        }
        return object;
    }

    public ArrayList createSquareLatticeNet(Class clazz, Class clazz2, int n, int n2, boolean bl, int n3) throws IllegalAccessException, InstantiationException {
        this.nodeClass = clazz;
        this.edgeClass = clazz2;
        this.nCols = n;
        this.nRows = n2;
        this.nNodes = this.nCols * this.nRows;
        this.torus = bl;
        this.radius = n3;
        ArrayList arrayList = this.createSquareLatticeNet();
        return arrayList;
    }
}

