/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.network.Node;
import uchicago.src.sim.util.Random;

public class DefaultNode
implements Node {
    protected ArrayList inEdges = new ArrayList(3);
    protected OrderedHashMap inMap = new OrderedHashMap();
    protected ArrayList outEdges = new ArrayList(3);
    protected OrderedHashMap outMap = new OrderedHashMap();
    protected String label;

    public DefaultNode() {
        this("");
    }

    public DefaultNode(String string) {
        this.label = string;
    }

    public Object getId() {
        return new Integer(this.hashCode());
    }

    public String getNodeLabel() {
        return this.label;
    }

    public void setNodeLabel(String string) {
        this.label = string;
    }

    public ArrayList getInEdges() {
        return this.inEdges;
    }

    public ArrayList getOutEdges() {
        return this.outEdges;
    }

    public ArrayList getFromNodes() {
        return this.getInNodes();
    }

    public ArrayList getToNodes() {
        return this.getOutNodes();
    }

    public ArrayList getOutNodes() {
        return new ArrayList(this.outMap.keys);
    }

    public ArrayList getInNodes() {
        return new ArrayList(this.inMap.keys);
    }

    public boolean hasEdgeToOrFrom(Node node) {
        return this.inMap.containsKey(node) || this.outMap.containsKey(node);
    }

    public void addInEdge(Edge edge) {
        Node node = edge.getFrom();
        HashSet<Edge> hashSet = (HashSet<Edge>)this.inMap.get(node);
        if (hashSet == null) {
            hashSet = new HashSet<Edge>();
            this.inMap.put(node, hashSet);
            hashSet.add(edge);
            this.inEdges.add(edge);
        } else if (!hashSet.contains(edge)) {
            hashSet.add(edge);
            this.inEdges.add(edge);
        }
    }

    public void addOutEdge(Edge edge) {
        Node node = edge.getTo();
        HashSet<Edge> hashSet = (HashSet<Edge>)this.outMap.get(node);
        if (hashSet == null) {
            hashSet = new HashSet<Edge>();
            this.outMap.put(node, hashSet);
            hashSet.add(edge);
            this.outEdges.add(edge);
        } else if (!hashSet.contains(edge)) {
            hashSet.add(edge);
            this.outEdges.add(edge);
        }
    }

    public void addOutEdges(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            this.addOutEdge(edge);
        }
    }

    public void addInEdges(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            this.addInEdge(edge);
        }
    }

    public void clearInEdges() {
        this.inMap.clear();
        this.inEdges.clear();
    }

    public void clearOutEdges() {
        this.outMap.clear();
        this.outEdges.clear();
    }

    public void removeInEdge(Edge edge) {
        Node node = edge.getFrom();
        this.inMap.remove(node);
        this.inEdges.remove(edge);
    }

    public void removeOutEdge(Edge edge) {
        Node node = edge.getTo();
        this.outMap.remove(node);
        this.outEdges.remove(edge);
    }

    public Node getNode() {
        return this;
    }

    public Node getRandomNodeOut() {
        if (this.outEdges.size() > 0) {
            int n = Random.uniform.nextIntFromTo(0, this.outEdges.size() - 1);
            Edge edge = (Edge)this.outEdges.get(n);
            return edge.getTo();
        }
        return null;
    }

    public Node getRandomNodeIn() {
        if (this.inEdges.size() > 0) {
            int n = Random.uniform.nextIntFromTo(0, this.inEdges.size() - 1);
            Edge edge = (Edge)this.inEdges.get(n);
            return edge.getFrom();
        }
        return null;
    }

    public Node getRandomFromNode() {
        return this.getRandomNodeIn();
    }

    public Node getRandomToNode() {
        return this.getRandomNodeOut();
    }

    public void removeEdgesTo(Node node) {
        HashSet hashSet = (HashSet)this.outMap.remove(node);
        if (hashSet != null) {
            this.outEdges.removeAll(hashSet);
        }
    }

    public void removeEdgesFrom(Node node) {
        HashSet hashSet = (HashSet)this.inMap.remove(node);
        if (hashSet != null) {
            this.inEdges.removeAll(hashSet);
        }
    }

    public Edge makeRandomOutEdge(List list, Edge edge, boolean bl) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("list size must be greater that 0");
        }
        int n = list.size() - 1;
        Node node = null;
        if (bl) {
            int n2 = Random.uniform.nextIntFromTo(0, n);
            node = (Node)list.get(n2);
        } else {
            int n3 = Random.uniform.nextIntFromTo(0, n);
            node = (Node)list.get(n3);
            while (node == this) {
                n3 = Random.uniform.nextIntFromTo(0, n);
                node = (Node)list.get(n3);
            }
        }
        edge.setTo(node);
        edge.setFrom(this);
        node.addInEdge(edge);
        this.addOutEdge(edge);
        return edge;
    }

    public Edge makeRandomInEdge(List list, Edge edge, boolean bl) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("list size must be greater that 0");
        }
        Node node = null;
        int n = list.size() - 1;
        if (bl) {
            int n2 = Random.uniform.nextIntFromTo(0, n);
            node = (Node)list.get(n2);
        } else {
            int n3 = Random.uniform.nextIntFromTo(0, n);
            node = (Node)list.get(n3);
            while (node == this) {
                n3 = Random.uniform.nextIntFromTo(0, n);
                node = (Node)list.get(n3);
            }
        }
        edge.setTo(this);
        edge.setFrom(node);
        node.addOutEdge(edge);
        this.addInEdge(edge);
        return edge;
    }

    public int getNumOutEdges() {
        return this.outEdges.size();
    }

    public int getNumInEdges() {
        return this.inEdges.size();
    }

    public boolean hasEdgeTo(Node node) {
        return this.getEdgesTo(node) != null;
    }

    public boolean hasEdgeFrom(Node node) {
        return this.getEdgesFrom(node) != null;
    }

    public int getOutDegree() {
        return this.outEdges.size();
    }

    public int getInDegree() {
        return this.inEdges.size();
    }

    public HashSet getEdgesTo(Node node) {
        return (HashSet)this.outMap.get(node);
    }

    public HashSet getEdgesFrom(Node node) {
        return (HashSet)this.inMap.get(node);
    }

    protected static class OrderedHashMap
    extends HashMap {
        LinkedList keys = new LinkedList();

        public OrderedHashMap(int n, float f) {
            super(n, f);
        }

        public OrderedHashMap(int n) {
            super(n);
        }

        public OrderedHashMap() {
        }

        public OrderedHashMap(Map map) {
            super(map);
        }

        public Object put(Object object, Object object2) {
            if (!this.containsKey(object)) {
                this.keys.add(object);
            }
            return super.put(object, object2);
        }

        public Object remove(Object object) {
            if (this.containsKey(object)) {
                this.keys.remove(object);
            }
            return super.remove(object);
        }

        public void clear() {
            super.clear();
            this.keys.clear();
        }
    }
}

