/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import cern.colt.list.DoubleArrayList;
import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.ref.Converter;
import hep.aida.ref.Histogram1D;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.List;
import uchicago.src.sim.analysis.BinDataSource;
import uchicago.src.sim.analysis.plot.OpenGraph;
import uchicago.src.sim.engine.SimModel;

public class Histogram
extends OpenGraph {
    protected Histogram1D histogram;
    protected List histList;
    protected BinDataSource dataSource;
    protected int numBins;
    protected boolean xTickDrawn = false;
    protected boolean showStats = true;
    protected NumberFormat format = NumberFormat.getInstance();

    public Histogram(String string, int n, double d, double d2) {
        this(string, n, d, d2, null);
    }

    public Histogram(String string, int n, double d, double d2, SimModel simModel) {
        super(string);
        this.model = simModel;
        this.setXRange(d, d2);
        this.histogram = new Histogram1D(string, n, d, d2);
        this.numBins = n;
        double d3 = (d2 - d) / (double)n;
        this.setBars(d3 / 2.0, 0.0);
    }

    public Histogram(String string, double[] dArray, SimModel simModel) {
        super(string);
        this.model = simModel;
        this.setXRange(dArray[0], dArray[dArray.length - 1]);
        this.histogram = new Histogram1D(string, dArray);
        IAxis iAxis = this.histogram.xAxis();
        this.numBins = iAxis.bins();
        double d = iAxis.upperEdge() - iAxis.lowerEdge();
        for (int i = 0; i < this.numBins; ++i) {
            double d2 = iAxis.binWidth(i);
            if (!(d2 < d)) continue;
            d = d2;
        }
        this.setBars(d / 2.0, 0.0);
    }

    public Histogram(String string, double[] dArray) {
        super(string);
        this.setXRange(dArray[0], dArray[dArray.length - 1]);
        this.histogram = new Histogram1D(string, dArray);
        IAxis iAxis = this.histogram.xAxis();
        this.numBins = iAxis.bins();
        double d = iAxis.upperEdge() - iAxis.lowerEdge();
        for (int i = 0; i < this.numBins; ++i) {
            double d2 = iAxis.binWidth(i);
            if (!(d2 < d)) continue;
            d = d2;
        }
        this.setBars(d / 2.0, 0.0);
    }

    public void setBarWidth(double d) {
        this.setBars(d, 0.0);
    }

    public void setStatsVisible(boolean bl) {
        this.showStats = bl;
    }

    public boolean isStatsVisible() {
        return this.showStats;
    }

    public Histogram1D getHistogram() {
        return this.histogram;
    }

    public void createHistogramItem(String string, List list, BinDataSource binDataSource) {
        this.histList = list;
        this.dataSource = binDataSource;
        this.plot.addLegend(0, string);
        this.format.setMaximumFractionDigits(340);
    }

    public void createHistogramItem(String string, List list, BinDataSource binDataSource, int n, int n2) {
        this.histList = list;
        this.dataSource = binDataSource;
        this.plot.addLegend(0, string);
        this.format.setMaximumFractionDigits(340);
        if (n != -1) {
            this.format.setMaximumIntegerDigits(n);
        }
        if (n2 != -1) {
            this.format.setMaximumFractionDigits(n2);
        }
    }

    public void createHistogramItem(String string, List list, Object object, String string2) {
        BinDataSource binDataSource = this.createBinDataSource(object, string2);
        this.createHistogramItem(string, list, binDataSource);
    }

    public void createHistogramItem(String string, List list, Object object, String string2, int n, int n2) {
        BinDataSource binDataSource = this.createBinDataSource(object, string2);
        this.createHistogramItem(string, list, binDataSource);
        this.format.setMaximumFractionDigits(340);
        if (n != -1) {
            this.format.setMaximumIntegerDigits(n);
        }
        if (n2 != -1) {
            this.format.setMaximumFractionDigits(n2);
        }
    }

    public void createHistogramItem(String string, List list, String string2) {
        BinDataSource binDataSource = this.createListBinDataSource(list.iterator().next(), string2);
        this.createHistogramItem(string, list, binDataSource);
    }

    public void createHistogramItem(String string, List list, String string2, int n, int n2) {
        BinDataSource binDataSource = this.createListBinDataSource(list.iterator().next(), string2);
        this.createHistogramItem(string, list, binDataSource);
        this.format.setMaximumFractionDigits(340);
        if (n != -1) {
            this.format.setMaximumIntegerDigits(n);
        }
        if (n2 != -1) {
            this.format.setMaximumFractionDigits(n2);
        }
    }

    public void record() {
        this.histogram.reset();
        int n = this.histList.size();
        for (int i = 0; i < n; ++i) {
            this.histogram.fill(this.dataSource.getBinValue(this.histList.get(i)));
        }
    }

    public void record(double[] dArray) {
        this.histogram.reset();
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.histogram.fill(dArray[i]);
        }
    }

    public void record(DoubleArrayList doubleArrayList) {
        this.histogram.reset();
        int n = doubleArrayList.size();
        for (int i = 0; i < n; ++i) {
            this.histogram.fill(doubleArrayList.get(i));
        }
    }

    public void step() {
        this.record();
        this.updateGraph();
    }

    public void step(double[] dArray) {
        this.record(dArray);
        this.updateGraph();
    }

    public void step(DoubleArrayList doubleArrayList) {
        this.record(doubleArrayList);
        this.updateGraph();
    }

    public String toString() {
        Converter converter = new Converter();
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(Calendar.getInstance().getTime().toString());
        stringBuffer.append(string);
        if (this.model != null) {
            stringBuffer.append(this.model.getPropertiesValues());
        }
        stringBuffer.append(string);
        stringBuffer.append(converter.toString((IHistogram1D)this.histogram));
        return stringBuffer.toString();
    }

    public void updateGraph() {
        int n;
        IAxis iAxis;
        this.plot.clearPoints();
        if (!this.xTickDrawn) {
            iAxis = this.histogram.xAxis();
            for (n = 0; n < this.numBins; ++n) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.format.format(iAxis.binLowerEdge(n)));
                stringBuffer.append("-");
                stringBuffer.append(this.format.format(iAxis.binUpperEdge(n)));
                this.updateXTick(iAxis.binCentre(n), stringBuffer.toString(), n);
            }
            this.xTickDrawn = true;
        }
        iAxis = this.histogram.xAxis();
        for (n = 0; n < this.numBins; ++n) {
            this.plot.addPoint(0, iAxis.binCentre(n), this.histogram.binHeight(n), false);
        }
        if (this.showStats) {
            this.showStats();
        }
        this.plot.fillPlot();
    }

    private void showStats() {
        this.plot.clearDetailStrings();
        NumberFormat numberFormat = NumberFormat.getInstance();
        StringBuffer stringBuffer = new StringBuffer("All Entries: ");
        stringBuffer.append(numberFormat.format(this.histogram.allEntries()));
        this.plot.addDetailString(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("Underflow: ");
        stringBuffer.append(numberFormat.format(this.histogram.binHeight(-2)));
        this.plot.addDetailString(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("Overflow: ");
        stringBuffer.append(numberFormat.format(this.histogram.binHeight(-1)));
        this.plot.addDetailString(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("Mean: ");
        stringBuffer.append(numberFormat.format(this.histogram.mean()));
        this.plot.addDetailString(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("Rms: ");
        stringBuffer.append(numberFormat.format(this.histogram.rms()));
        this.plot.addDetailString(stringBuffer.toString());
    }
}

