/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import uchicago.src.reflector.MethodFactory;
import uchicago.src.sim.engine.IController;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.parameter.ParameterUtility;
import uchicago.src.sim.util.SimUtilities;

public class DataFileHeader {
    public static final String WRITE_HEADER = "_WRITE_HEADER";
    private String modelHeader = "";
    private boolean isBatch = false;
    private SimModel model;
    private String lineSep;
    private String headerComment = "";
    private Hashtable propertyMethod;

    public DataFileHeader() {
        this.lineSep = System.getProperty("line.separator");
    }

    public DataFileHeader(String string) {
        this.headerComment = string;
        this.lineSep = System.getProperty("line.separator");
    }

    public DataFileHeader(SimModel simModel) {
        this.model = simModel;
        this.lineSep = System.getProperty("line.separator");
        this.isBatch = simModel.getController().isBatch();
    }

    private void createHeader() {
        Hashtable hashtable = null;
        if (this.isBatch) {
            hashtable = this.createBatchHeader();
            this.createBlockHeader();
        } else if (this.model == null) {
            hashtable = new Hashtable();
        } else {
            try {
                hashtable = ParameterUtility.getInstance().getModelProperties(this.model);
            }
            catch (IntrospectionException introspectionException) {
                SimUtilities.showError("Error getting model parameters", introspectionException);
                System.exit(0);
            }
            catch (IllegalAccessException illegalAccessException) {
                SimUtilities.showError("Error getting model parameters", illegalAccessException);
                System.exit(0);
            }
            catch (InvocationTargetException invocationTargetException) {
                SimUtilities.showError("Error getting model parameters", invocationTargetException);
                System.exit(0);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.headerComment.length() != 0) {
            stringBuffer.append(this.headerComment);
            stringBuffer.append(this.lineSep);
        }
        stringBuffer.append("Timestamp: ");
        stringBuffer.append(DateFormat.getDateTimeInstance().format(new Date()));
        stringBuffer.append(this.lineSep);
        ArrayList arrayList = new ArrayList(hashtable.keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Object k = arrayList.get(i);
            stringBuffer.append(k);
            stringBuffer.append(": ");
            stringBuffer.append(hashtable.get(k));
            stringBuffer.append(this.lineSep);
        }
        this.modelHeader = stringBuffer.toString();
    }

    private Hashtable createBatchHeader() {
        Hashtable hashtable = null;
        ParameterUtility parameterUtility = ParameterUtility.getInstance();
        try {
            hashtable = parameterUtility.getDefaultParameters(this.model);
        }
        catch (IntrospectionException introspectionException) {
            SimUtilities.showError("Error getting default parameters", introspectionException);
        }
        catch (InvocationTargetException invocationTargetException) {
            SimUtilities.showError("Error getting default parameters", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            SimUtilities.showError("Error getting default parameters", illegalAccessException);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!parameterUtility.isDefaultParam(string) || parameterUtility.isConstantDefaultParam(string)) continue;
            hashtable.remove(string);
        }
        return hashtable;
    }

    private void createBlockHeader() {
        ArrayList arrayList = ParameterUtility.getInstance().getDynamicParameterNames();
        Class<?> clazz = this.model.getClass();
        try {
            this.propertyMethod = MethodFactory.getInstance().findGetMethods(clazz, arrayList);
        }
        catch (Exception exception) {
            String string = "Fatal Error finding accessor methods. See repast.log";
            SimUtilities.showError(string, exception);
            System.exit(0);
        }
    }

    public void addHeaderComment(String string) {
        if (string != null) {
            this.headerComment = string;
        }
    }

    public String getFileHeader() {
        if (this.modelHeader.length() == 0) {
            this.createHeader();
        }
        return this.modelHeader;
    }

    private String getBHeader(boolean bl) {
        if (!this.isBatch) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("# run: ");
        stringBuffer.append(String.valueOf(this.model.getController().getRunCount()));
        stringBuffer.append(this.lineSep);
        if (this.propertyMethod == null) {
            this.createBlockHeader();
        }
        Enumeration enumeration = this.propertyMethod.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (bl) {
                stringBuffer.append("# ");
            }
            stringBuffer.append(string);
            stringBuffer.append(": ");
            Method method = (Method)this.propertyMethod.get(string);
            String string2 = null;
            try {
                string2 = String.valueOf(method.invoke((Object)this.model, new Object[0]));
            }
            catch (Exception exception) {
                String string3 = "Fatal Error invoking accessor method. See repast.log";
                SimUtilities.showError(string3, exception);
                System.exit(0);
            }
            stringBuffer.append(string2);
            stringBuffer.append(this.lineSep);
        }
        return stringBuffer.toString();
    }

    public String getBlockHeader() {
        return this.getBHeader(false);
    }

    public String getBlockHeaderAsComments() {
        return this.getBHeader(true);
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public boolean doWriteHeader(String string) {
        if (this.isBatch) {
            string = string + WRITE_HEADER;
            IController iController = this.model.getController();
            Boolean bl = (Boolean)iController.getPersistentObj(string);
            if (bl == null) {
                bl = Boolean.TRUE;
                iController.putPersistentObj(string, bl);
            }
            return bl;
        }
        return true;
    }

    public void setWriteHeader(String string, boolean bl) {
        if (this.isBatch) {
            string = string + WRITE_HEADER;
            IController iController = this.model.getController();
            iController.putPersistentObj(string, bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void putPersistentObj(Object object, Object object2) {
        this.model.getController().putPersistentObj(object, object2);
    }

    public Object getPersistentObj(Object object) {
        return this.model.getController().getPersistentObj(object);
    }

    public Hashtable getDynParamMethod() {
        return this.propertyMethod;
    }
}

