/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Vector;
import uchicago.src.codegen.GeneratorException;
import uchicago.src.sim.analysis.AverageDataSource;
import uchicago.src.sim.analysis.DataFileHeader;
import uchicago.src.sim.analysis.DataSource;
import uchicago.src.sim.analysis.DataSourceRecorder;
import uchicago.src.sim.analysis.NumericDataSource;
import uchicago.src.sim.analysis.SimDataNew;
import uchicago.src.sim.engine.SimEvent;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.util.ByteCodeBuilder;
import uchicago.src.sim.util.SimUtilities;

public abstract class AbstractDataSourceRecorder
implements DataSourceRecorder {
    protected SimDataNew data;
    protected Vector sources = new Vector(7);
    protected SimModel model;
    protected DataFileHeader dfHeader;

    public void initData(SimModel simModel, String string) {
        this.model = simModel;
        this.dfHeader = new DataFileHeader(simModel);
        if (string != null) {
            this.dfHeader.addHeaderComment(string);
        }
        String string2 = this.dfHeader.getFileHeader();
        this.data = new SimDataNew(string2);
    }

    public void addNumericDataSource(String string, NumericDataSource numericDataSource, int n, int n2) {
        this.data.addToHeader(string);
        NumberFormattingDataSource numberFormattingDataSource = new NumberFormattingDataSource(numericDataSource, n, n2);
        this.sources.add(numberFormattingDataSource);
    }

    public void addNumericDataSource(String string, final NumericDataSource numericDataSource) {
        this.data.addToHeader(string);
        this.sources.add(new DataSource(){

            public Object execute() {
                return String.valueOf(numericDataSource.execute());
            }
        });
    }

    public void createObjectDataSource(String string, Object object, String string2) {
        DataSource dataSource = null;
        try {
            dataSource = ByteCodeBuilder.generateDataSource(object, string2);
        }
        catch (GeneratorException generatorException) {
            SimUtilities.showError("Error creating ObjectDataSource: " + generatorException.getMessage(), generatorException);
            System.exit(0);
        }
        this.data.addToHeader(string);
        this.sources.add(dataSource);
    }

    public void createNumericDataSource(String string, Object object, String string2, int n, int n2) {
        NumericDataSource numericDataSource = null;
        try {
            numericDataSource = ByteCodeBuilder.generateNumericDataSource(object, string2);
        }
        catch (GeneratorException generatorException) {
            SimUtilities.showError("Error creating NumericDataSource: " + generatorException.getMessage(), generatorException);
            System.exit(0);
        }
        if (this.data == null) {
            System.out.println("no data");
            System.exit(0);
        }
        this.data.addToHeader(string);
        NumberFormattingDataSource numberFormattingDataSource = new NumberFormattingDataSource(numericDataSource, n, n2);
        this.sources.add(numberFormattingDataSource);
    }

    public void createNumericDataSource(String string, Object object, String string2) {
        NumericDataSource numericDataSource = null;
        try {
            numericDataSource = ByteCodeBuilder.generateNumericDataSource(object, string2);
        }
        catch (GeneratorException generatorException) {
            SimUtilities.showError("Error creating NumericDataSource: " + generatorException.getMessage(), generatorException);
            System.exit(0);
        }
        this.addNumericDataSource(string, numericDataSource);
    }

    public void addObjectDataSource(String string, DataSource dataSource) {
        this.data.addToHeader(string);
        this.sources.add(dataSource);
    }

    public void createAverageDataSource(String string, ArrayList arrayList, String string2) {
        AverageDataSource averageDataSource = new AverageDataSource(string, arrayList, string2);
        this.data.addToHeader(string);
        this.sources.add(averageDataSource);
    }

    public void createAverageDataSource(String string, ArrayList arrayList, String string2, int n, int n2) {
        AverageDataSource averageDataSource = new AverageDataSource(string, arrayList, string2);
        this.data.addToHeader(string);
        AverageFormattingDataSource averageFormattingDataSource = new AverageFormattingDataSource(averageDataSource, n, n2);
        this.sources.add(averageFormattingDataSource);
    }

    public abstract void record();

    public abstract void writeToFile();

    public abstract void write();

    public abstract void writeEnd();

    public void simEventPerformed(SimEvent simEvent) {
        if (simEvent.getId() == 2) {
            this.writeEnd();
        }
    }

    public void setDelimeter(String string) {
        this.data.setDelimiter(string);
    }

    class NumberFormattingDataSource
    extends FormattingDataSource {
        private NumericDataSource dataSource;

        public NumberFormattingDataSource(NumericDataSource numericDataSource, int n, int n2) {
            super(n, n2);
            this.dataSource = numericDataSource;
        }

        public Object execute() {
            return this.format.format(this.dataSource.execute());
        }
    }

    class AverageFormattingDataSource
    extends FormattingDataSource {
        private AverageDataSource dataSource;

        public AverageFormattingDataSource(AverageDataSource averageDataSource, int n, int n2) {
            super(n, n2);
            this.dataSource = averageDataSource;
        }

        public Object execute() {
            return this.format.format(this.dataSource.execute());
        }
    }

    abstract class FormattingDataSource
    implements DataSource {
        protected DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance();

        public FormattingDataSource(int n, int n2) {
            boolean bl = false;
            this.format.setMaximumFractionDigits(340);
            this.format.setGroupingUsed(false);
            StringBuffer stringBuffer = new StringBuffer();
            if (n > -1) {
                this.format.setMaximumIntegerDigits(n);
                bl = true;
            } else {
                stringBuffer.append("0");
            }
            stringBuffer.append(this.format.getDecimalFormatSymbols().getDecimalSeparator());
            if (n2 > -1) {
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append("0");
                }
                this.format.applyPattern(stringBuffer.toString());
                if (bl) {
                    this.format.setMaximumIntegerDigits(n);
                }
            }
        }

        public abstract Object execute();
    }
}

