/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloNumExpr;
import ilog.concert.IloRange;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcNumExpr;
import ilog.solver.IlcSolver;
import ilog.solver.mk;
import ilog.solver.nm;
import ilog.solver.rq;
import ilog.solver.up;

class vq
extends IlcConstraint {
    protected final IlcNumExpr _exp;
    protected final double _value;

    vq(IloNumExpr iloNumExpr, double d2, String string) {
        super(string);
        this._exp = (IlcNumExpr)iloNumExpr;
        this._value = d2;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        nm nm2 = this._exp.getPNumExp(ilcSolver);
        if (Double.isNaN(this._value) || Double.isInfinite(this._value)) {
            return new rq(nm2, new up(ilcSolver, this._value));
        }
        return new mk(nm2, this._value);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._exp);
        stringBuffer.append(" >= ");
        stringBuffer.append(this._value);
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloRange iloRange = iloCPModeler.ge((IloNumExpr)iloCopyManager.getCopy(this._exp), this._value);
        iloRange.setName(this.getName());
        return iloRange;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._exp.needCopy(check);
    }
}

