/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntSetVar;
import ilog.concert.IloIntToIntExprFunction;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcIntSetVar;
import ilog.solver.IlcIterator;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.jbb;
import ilog.solver.kh;
import ilog.solver.ys;
import ilog.solver.yz;

class vp
extends IlcConstraint {
    protected IlcIntSetVar _var1;
    protected IlcIntSetVar _var2;
    protected IloIntToIntExprFunction _func;
    protected int _min;
    protected int _max;

    vp(IloIntSetVar iloIntSetVar, IloIntSetVar iloIntSetVar2, IloIntToIntExprFunction iloIntToIntExprFunction, int n2, int n3) {
        this._var1 = (IlcIntSetVar)iloIntSetVar;
        this._var2 = (IlcIntSetVar)iloIntSetVar2;
        this._func = iloIntToIntExprFunction;
        this._min = n2;
        this._max = n3;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        kh kh2 = (kh)this._var1.getExtracted(ilcSolver);
        kh kh3 = (kh)this._var2.getExtracted(ilcSolver);
        jbb jbb2 = new jbb(ilcSolver, this._func);
        return new ex(kh2, kh3, jbb2, this._min, this._max);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("rangedSubsetEq(");
        stringBuffer.append(this._var1);
        stringBuffer.append(", ");
        stringBuffer.append(this._var2);
        stringBuffer.append(", ");
        stringBuffer.append(this._func);
        stringBuffer.append(", ");
        stringBuffer.append(this._min);
        stringBuffer.append(", ");
        stringBuffer.append(this._max);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloIntSetVar iloIntSetVar = (IloIntSetVar)iloCopyManager.getCopy(this._var1);
        IloIntSetVar iloIntSetVar2 = (IloIntSetVar)iloCopyManager.getCopy(this._var2);
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.rangedSubsetEq(iloIntSetVar, iloIntSetVar2, this._func, this._min, this._max);
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._var1.needCopy(check);
        this._var2.needCopy(check);
    }

    static final class ex
    extends IlcPPropagator {
        final kh swb;
        final kh twb;
        final jbb uwb;
        final int vwb;
        final int wwb;

        public ex(kh kh2, kh kh3, jbb jbb2, int n2, int n3) {
            this.swb = kh2;
            this.twb = kh3;
            this.uwb = jbb2;
            this.vwb = n2;
            this.wwb = n3;
        }

        public void metaPost(IlcDemon ilcDemon) {
            this.swb.whenDomain(ilcDemon);
            this.twb.whenDomain(ilcDemon);
        }

        public void post() {
            this.swb.getSolver().add(new yz.pm(this.swb.getCardinality(), this.twb.getCardinality()));
            if (!this.swb.isBound()) {
                this.swb.whenDomain(new lu());
            }
            if (!this.twb.isBound()) {
                this.twb.whenDomain(new kn());
            }
            IlcIterator ilcIterator = this.twb.getDomainPossibleIterator();
            while (ilcIterator.hasNext()) {
                int n2 = ilcIterator.nextValue();
                ys ys2 = this.uwb.getValue(n2);
                if (ys2.isBound()) continue;
                ys2.whenRange(new jx(n2, ys2));
            }
        }

        public void propagate() {
            ys ys2;
            int n2;
            IlcIterator ilcIterator = this.swb.getDomainPossibleIterator();
            while (ilcIterator.hasNext()) {
                n2 = ilcIterator.nextValue();
                ys2 = this.uwb.getValue(n2);
                if (this.swb.isDomainRequired(n2)) {
                    ys2.setDomainRange(this.vwb, this.wwb);
                    this.twb.addDomainRequired(n2);
                    continue;
                }
                if (!this.twb.isDomainPossible(n2)) {
                    this.swb.removeDomainPossible(n2);
                    continue;
                }
                if (ys2.getDomainMax() < this.vwb || ys2.getDomainMin() > this.wwb) {
                    this.swb.removeDomainPossible(n2);
                    continue;
                }
                if (ys2.getDomainMax() > this.wwb || ys2.getDomainMin() < this.vwb || !this.twb.isDomainRequired(n2)) continue;
                this.swb.addDomainRequired(n2);
            }
            ilcIterator = this.twb.getDomainPossibleIterator();
            while (ilcIterator.hasNext()) {
                n2 = ilcIterator.nextValue();
                if (this.swb.isDomainPossible(n2)) continue;
                ys2 = this.uwb.getValue(n2);
                if (this.twb.isDomainRequired(n2)) {
                    ys2.removeDomainInterval(this.vwb, this.wwb);
                    continue;
                }
                if (ys2.getDomainMax() > this.wwb || ys2.getDomainMin() < this.vwb) continue;
                this.twb.removeDomainPossible(n2);
            }
        }

        public boolean isViolated() {
            ys ys2;
            int n2;
            IlcIterator ilcIterator = this.swb.getDomainRequiredIterator();
            while (ilcIterator.hasNext()) {
                n2 = ilcIterator.nextValue();
                ys2 = this.uwb.getValue(n2);
                if (ys2.getDomainMax() >= this.vwb && ys2.getDomainMin() <= this.wwb && this.twb.isDomainPossible(n2)) continue;
                return true;
            }
            ilcIterator = this.twb.getDomainRequiredIterator();
            while (ilcIterator.hasNext()) {
                n2 = ilcIterator.nextValue();
                ys2 = this.uwb.getValue(n2);
                if (ys2.getDomainMax() > this.wwb || ys2.getDomainMin() < this.vwb || this.swb.isDomainPossible(n2)) continue;
                return true;
            }
            return false;
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("rangedSubsetEq(");
            stringBuffer.append(this.swb);
            stringBuffer.append(", ");
            stringBuffer.append(this.twb);
            stringBuffer.append(", ");
            stringBuffer.append(this.uwb);
            stringBuffer.append(", ");
            stringBuffer.append(this.vwb);
            stringBuffer.append(", ");
            stringBuffer.append(this.wwb);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        final class jx
        extends IlcDemon {
            final int kxb;
            final ys lxb;

            jx(int n2, ys ys2) {
                this.kxb = n2;
                this.lxb = ys2;
            }

            public void propagate() {
                int n2 = this.lxb.getDomainMin();
                int n3 = this.lxb.getDomainMax();
                if (n3 < ex.this.vwb || n2 > ex.this.wwb) {
                    ex.this.swb.removeDomainPossible(this.kxb);
                } else if (n2 >= ex.this.vwb && n3 <= ex.this.wwb) {
                    if (ex.this.twb.isDomainRequired(this.kxb)) {
                        ex.this.swb.addDomainRequired(this.kxb);
                    }
                    if (!ex.this.swb.isDomainPossible(this.kxb)) {
                        ex.this.twb.removeDomainPossible(this.kxb);
                    }
                }
            }
        }

        final class kn
        extends IlcDemon {
            kn() {
            }

            public void propagate() {
                IlcIterator ilcIterator = ex.this.twb.getDeltaPossibleIterator();
                while (ilcIterator.hasNext()) {
                    ex.this.swb.removeDomainPossible(ilcIterator.nextValue());
                }
                ilcIterator = ex.this.twb.getDeltaRequiredIterator();
                while (ilcIterator.hasNext()) {
                    int n2 = ilcIterator.nextValue();
                    ys ys2 = ex.this.uwb.getValue(n2);
                    if (ys2.getDomainMin() >= ex.this.vwb && ys2.getDomainMax() <= ex.this.wwb) {
                        ex.this.swb.addDomainRequired(n2);
                    }
                    if (ex.this.swb.isDomainPossible(n2)) continue;
                    ys2.removeDomainInterval(ex.this.vwb, ex.this.wwb);
                }
            }
        }

        final class lu
        extends IlcDemon {
            lu() {
            }

            public void propagate() {
                ys ys2;
                int n2;
                IlcIterator ilcIterator = ex.this.swb.getDeltaRequiredIterator();
                while (ilcIterator.hasNext()) {
                    n2 = ilcIterator.nextValue();
                    ys2 = ex.this.uwb.getValue(n2);
                    ys2.setDomainRange(ex.this.vwb, ex.this.wwb);
                    ex.this.twb.addDomainRequired(n2);
                }
                ilcIterator = ex.this.swb.getDeltaPossibleIterator();
                while (ilcIterator.hasNext()) {
                    n2 = ilcIterator.nextValue();
                    ys2 = ex.this.uwb.getValue(n2);
                    if (ex.this.twb.isDomainRequired(n2)) {
                        ys2.removeDomainInterval(ex.this.vwb, ex.this.wwb);
                        continue;
                    }
                    if (ys2.getDomainMin() < ex.this.vwb || ys2.getDomainMax() > ex.this.wwb) continue;
                    ex.this.twb.removeDomainPossible(n2);
                }
            }
        }
    }
}

