/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloAnyExpr;
import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloFilterLevel;
import ilog.concert.IloIntEncoder;
import ilog.solver.IlcAnyExpr;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverError;
import ilog.solver.gc;
import ilog.solver.ys;

final class cq
extends IlcConstraint {
    protected IlcAnyExpr[] _exps;

    public cq(IloAnyExpr[] iloAnyExprArray) {
        this._exps = new IlcAnyExpr[iloAnyExprArray.length];
        int n2 = 0;
        while (n2 < iloAnyExprArray.length) {
            this._exps[n2] = (IlcAnyExpr)iloAnyExprArray[n2];
            ++n2;
        }
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        int n2 = this._exps.length;
        ys[] ysArray = new ys[n2];
        IloIntEncoder iloIntEncoder = n2 > 0 ? this._exps[0].getIntEncoder() : null;
        int n3 = 0;
        while (n3 < n2) {
            IlcAnyExpr ilcAnyExpr = this._exps[n3];
            if (ilcAnyExpr.getIntEncoder() != iloIntEncoder) {
                throw new IlcSolverError.DifferentEncoders(this._exps[0], ilcAnyExpr);
            }
            ysArray[n3] = ilcAnyExpr.getPIntExp(ilcSolver);
            ++n3;
        }
        if (ilcSolver.getFilterLevel(this) == IloFilterLevel.Basic) {
            return new gc.xt(ysArray);
        }
        return new gc.te(ysArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("allDiff([");
        int n2 = this._exps.length;
        String string = "";
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append(this._exps[n3]);
            ++n3;
        }
        stringBuffer.append("])");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloAnyExpr[] iloAnyExprArray = iloCPModeler.anyExprArray(this._exps.length);
        int n2 = 0;
        while (n2 < this._exps.length) {
            iloAnyExprArray[n2] = (IloAnyExpr)iloCopyManager.getCopy(this._exps[n2]);
            ++n2;
        }
        IloConstraint iloConstraint = iloCPModeler.allDiff(iloAnyExprArray);
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        int n2 = this._exps.length;
        int n3 = 0;
        while (n3 < n2) {
            this._exps[n3].needCopy(check);
            ++n3;
        }
    }
}

