/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloException;
import ilog.concert.IloIntExpr;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcIterator;
import ilog.solver.IlcNumExpr;
import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverRuntimeError;
import ilog.solver.nm;
import ilog.solver.os;
import ilog.solver.ys;

public abstract class IlcIntExpr
extends IlcNumExpr
implements IloIntExpr {
    protected ys _extracted;

    protected IlcIntExpr() {
    }

    public ys getPIntExp(IlcSolver ilcSolver) throws IlcSolverRuntimeError.Extraction {
        if (this._extracted instanceof os) {
            ilcSolver.registerExtracted(this);
            try {
                this._extracted = (ys)this.extract(ilcSolver);
            }
            catch (IloException iloException) {
                throw new IlcSolverRuntimeError.Extraction(iloException.getMessage(), iloException);
            }
            if (this.shouldHaveDomain()) {
                this._extracted.kn();
            }
        }
        return this._extracted;
    }

    public Object getExtracted(IlcSolver ilcSolver) throws IlcSolverRuntimeError.Extraction {
        return this.getPIntExp(ilcSolver);
    }

    public final nm getPNumExp(IlcSolver ilcSolver) throws IlcSolverRuntimeError.Extraction {
        return this.getPIntExp(ilcSolver);
    }

    public void resetExtracted(IlcSolver ilcSolver) {
        this._extracted = new os(this, ilcSolver);
    }

    public synchronized String toString() {
        if (!(this._extracted instanceof os)) {
            return this._extracted.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IlcIntExpr");
        return stringBuffer.toString();
    }

    public int getDomainValue() throws IlcSolverRuntimeError {
        return this._extracted.getDomainValue();
    }

    public boolean hasDomain() {
        return this._extracted.jn();
    }

    public void createDomain() {
        this._extracted.kn();
    }

    public IlcSolver getSolver() {
        return this._extracted.getSolver();
    }

    public int getDomainSize() {
        return this._extracted.getDomainSize();
    }

    public double getDomainDiameter() {
        return this.getDomainMax() - this.getDomainMin();
    }

    public int getNbOfConstraints() {
        return this._extracted.getNbOfConstraints();
    }

    public boolean isBound() {
        return this._extracted.isBound();
    }

    public int getDomainMin() {
        return this._extracted.getDomainMin();
    }

    public final double getDomainLB() {
        return this.getDomainMin();
    }

    public int getDomainMax() {
        return this._extracted.getDomainMax();
    }

    public final double getDomainUB() {
        return this.getDomainMax();
    }

    public boolean isInDomain(int n2) {
        this._extracted.getSolver();
        if (n2 == Integer.MIN_VALUE) {
            return false;
        }
        return this._extracted.isInDomain(n2);
    }

    public void setDomainMin(int n2) {
        this._extracted.getSolver();
        this._extracted.setDomainMin(Math.max(n2, -2147483647));
    }

    public void setDomainLB(double d2) {
        this._extracted.setDomainLB(Math.ceil(d2));
    }

    public void setDomainMax(int n2) {
        this._extracted.getSolver();
        if (n2 == Integer.MIN_VALUE) {
            this._extracted.getSolver().fail();
        } else {
            this._extracted.setDomainMax(n2);
        }
    }

    public void setDomainUB(double d2) {
        this._extracted.setDomainUB(Math.floor(d2));
    }

    public void setDomainRange(int n2, int n3) {
        this._extracted.getSolver();
        if (n3 == Integer.MIN_VALUE) {
            this._extracted.getSolver().fail();
        } else {
            this._extracted.setDomainRange(Math.max(n2, -2147483647), n3);
        }
    }

    public void setDomainRange(double d2, double d3) {
        this._extracted.setDomainRange(d2, d3);
    }

    public void setDomainRangeNoCast(double d2, double d3) {
        this.setDomainRange(d2, d3);
    }

    public void setDomainValue(int n2) {
        this._extracted.getSolver();
        if (n2 == Integer.MIN_VALUE) {
            this.getSolver().fail();
        } else {
            this._extracted.setDomainValue(n2);
        }
    }

    public void removeDomainValue(int n2) {
        this._extracted.getSolver();
        if (n2 != Integer.MIN_VALUE) {
            this._extracted.removeDomainValue(n2);
        }
    }

    public void removeDomainInterval(int n2, int n3) {
        this._extracted.getSolver();
        if (n3 != Integer.MIN_VALUE) {
            this._extracted.removeDomainInterval(Math.max(n2, -2147483647), n3);
        }
    }

    public void whenValue(IlcDemon ilcDemon) {
        this._extracted.whenValue(ilcDemon);
    }

    public void whenRange(IlcDemon ilcDemon) {
        this._extracted.whenRange(ilcDemon);
    }

    public void whenDomain(IlcDemon ilcDemon) {
        this._extracted.whenDomain(ilcDemon);
    }

    public void whenValue(IlcConstraint ilcConstraint) {
        this._extracted.whenValue(ilcConstraint.getPropagator(this.getSolver()));
    }

    public void whenRange(IlcConstraint ilcConstraint) {
        this._extracted.whenRange(ilcConstraint.getPropagator(this.getSolver()));
    }

    public void whenDomain(IlcConstraint ilcConstraint) {
        this._extracted.whenDomain(ilcConstraint.getPropagator(this.getSolver()));
    }

    public int getNextHigher(int n2) {
        return this._extracted.getNextHigher(n2);
    }

    public int getNextLower(int n2) {
        return this._extracted.getNextLower(n2);
    }

    public IlcIterator domainIterator() {
        return this._extracted.domainIterator();
    }

    public IlcIterator removedIterator() {
        return this._extracted.removedIterator();
    }

    public IlcIterator deltaIterator() {
        return this._extracted.deltaIterator();
    }

    public boolean isNaN() {
        return this._extracted.isNaN();
    }

    public double getBoundCastDownMid() {
        return this._extracted.getBoundCastDownMid();
    }

    public double boundCastDown(double d2) {
        return this._extracted.boundCastDown(d2);
    }

    public double boundCastUp(double d2) {
        return this._extracted.boundCastUp(d2);
    }

    public double boundNextDown(double d2) {
        return this._extracted.boundNextDown(d2);
    }

    public double boundNextUp(double d2) {
        return this._extracted.boundNextUp(d2);
    }

    public double propagationCastDown(double d2) {
        return this._extracted.propagationCastDown(d2);
    }

    public double propagationCastUp(double d2) {
        return this._extracted.propagationCastUp(d2);
    }

    public double propagationNextDown(double d2) {
        return this._extracted.propagationNextDown(d2);
    }

    public double propagationNextUp(double d2) {
        return this._extracted.propagationNextUp(d2);
    }

    public void setPrecision(int n2) {
        this.setPrecision(n2, n2);
    }

    public void setPrecision(int n2, int n3) {
        this.setPrecision(n2, n3, 1);
    }

    public void setPrecision(int n2, int n3, int n4) {
        throw new IlcSolverRuntimeError.hbb("Cannot set Precision on IlcIntExp.");
    }

    public int getRelativePrecision() {
        throw new IlcSolverRuntimeError.hbb("Cannot get Precision on IlcIntExp.");
    }

    public int getAbsolutePrecision() {
        throw new IlcSolverRuntimeError.hbb("Cannot get Precision on IlcIntExp.");
    }

    public int getGuardDigits() {
        throw new IlcSolverRuntimeError.hbb("Cannot get Guard Digits on IlcIntExp.");
    }

    private static IlcIntExpr oc(IlcIntExpr ilcIntExpr) {
        return ilcIntExpr;
    }

    private static IlcIntExpr cc(IlcIntExpr ilcIntExpr) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.negative(ilcIntExpr);
    }

    private static IlcIntExpr lc(IlcIntExpr ilcIntExpr, IlcIntExpr ilcIntExpr2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.sum(ilcIntExpr, ilcIntExpr2);
    }

    private static IlcIntExpr dc(IlcIntExpr ilcIntExpr, int n2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.sum(ilcIntExpr, n2);
    }

    private static IlcIntExpr tb(int n2, IlcIntExpr ilcIntExpr) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.sum(n2, ilcIntExpr);
    }

    private static IlcIntExpr qc(IlcIntExpr ilcIntExpr, IlcIntExpr ilcIntExpr2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.diff(ilcIntExpr, ilcIntExpr2);
    }

    private static IlcIntExpr hc(IlcIntExpr ilcIntExpr, int n2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.diff(ilcIntExpr, n2);
    }

    private static IlcIntExpr yb(int n2, IlcIntExpr ilcIntExpr) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.diff(n2, ilcIntExpr);
    }

    private static IlcIntExpr ic(IlcIntExpr ilcIntExpr, IlcIntExpr ilcIntExpr2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.prod(ilcIntExpr, ilcIntExpr2);
    }

    private static IlcIntExpr xb(IlcIntExpr ilcIntExpr, int n2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.prod(ilcIntExpr, n2);
    }

    private static IlcIntExpr pb(int n2, IlcIntExpr ilcIntExpr) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.prod(n2, ilcIntExpr);
    }

    private static IlcIntExpr gc(IlcIntExpr ilcIntExpr, IlcIntExpr ilcIntExpr2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.div(ilcIntExpr, ilcIntExpr2);
    }

    private static IlcIntExpr wb(IlcIntExpr ilcIntExpr, int n2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.div(ilcIntExpr, n2);
    }

    private static IlcIntExpr uc(int n2, IlcIntExpr ilcIntExpr) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.div(n2, ilcIntExpr);
    }

    private static IlcConstraint kc(IlcIntExpr ilcIntExpr, IlcIntExpr ilcIntExpr2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.eq(ilcIntExpr, ilcIntExpr2);
    }

    private static IlcConstraint rb(IlcIntExpr ilcIntExpr, int n2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.eq(ilcIntExpr, n2);
    }

    private static IlcConstraint sc(int n2, IlcIntExpr ilcIntExpr) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.eq(n2, ilcIntExpr);
    }

    private static IlcConstraint ub(IlcIntExpr ilcIntExpr, IlcIntExpr ilcIntExpr2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.neq(ilcIntExpr, ilcIntExpr2);
    }

    private static IlcConstraint nc(IlcIntExpr ilcIntExpr, int n2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.neq(ilcIntExpr, n2);
    }

    private static IlcConstraint jc(int n2, IlcIntExpr ilcIntExpr) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.neq(n2, ilcIntExpr);
    }

    private static IlcConstraint qb(IlcIntExpr ilcIntExpr, IlcIntExpr ilcIntExpr2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.lt(ilcIntExpr, ilcIntExpr2);
    }

    private static IlcConstraint fc(IlcIntExpr ilcIntExpr, int n2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.lt(ilcIntExpr, n2);
    }

    private static IlcConstraint bc(int n2, IlcIntExpr ilcIntExpr) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.lt(n2, ilcIntExpr);
    }

    private static IlcConstraint pc(IlcIntExpr ilcIntExpr, IlcIntExpr ilcIntExpr2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.gt(ilcIntExpr, ilcIntExpr2);
    }

    private static IlcConstraint vb(IlcIntExpr ilcIntExpr, int n2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.gt(ilcIntExpr, n2);
    }

    private static IlcConstraint sb(int n2, IlcIntExpr ilcIntExpr) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.gt(n2, ilcIntExpr);
    }

    private static IlcConstraint tc(IlcIntExpr ilcIntExpr, IlcIntExpr ilcIntExpr2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.le(ilcIntExpr, ilcIntExpr2);
    }

    private static IlcConstraint ec(IlcIntExpr ilcIntExpr, int n2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.le(ilcIntExpr, n2);
    }

    private static IlcConstraint zb(int n2, IlcIntExpr ilcIntExpr) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.le(n2, ilcIntExpr);
    }

    private static IlcConstraint ac(IlcIntExpr ilcIntExpr, IlcIntExpr ilcIntExpr2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.ge(ilcIntExpr, ilcIntExpr2);
    }

    private static IlcConstraint rc(IlcIntExpr ilcIntExpr, int n2) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.ge(ilcIntExpr, n2);
    }

    private static IlcConstraint mc(int n2, IlcIntExpr ilcIntExpr) {
        IlcSolver ilcSolver = ilcIntExpr.getSolver();
        return ilcSolver.ge(n2, ilcIntExpr);
    }
}

