/*
 * Decompiled with CFR 0.152.
 */
package ilog.concert;

import ilog.concert.IloIntDomain;
import ilog.concert.IloIntNaryOppositeTable;
import ilog.concert.IloNaryTableSupportSet;
import ilog.concert.IloRuntimeException;

public class IloIntNaryTable {
    IloNaryTableSupportSet[][] jn;
    public int[] _xMin;
    public int[] _xMax;
    int[] kn;
    int ln;
    boolean mn;
    rf nn;

    public IloIntNaryTable(IloIntDomain[] iloIntDomainArray) {
        this.mn = false;
        this.nn = null;
        this.ln = iloIntDomainArray.length;
        this._xMin = new int[this.ln];
        this._xMax = new int[this.ln];
        this.kn = new int[this.ln];
        this.jn = new IloNaryTableSupportSet[this.ln][];
        int n2 = 0;
        while (n2 < iloIntDomainArray.length) {
            this._xMin[n2] = iloIntDomainArray[n2].getMax();
            this._xMax[n2] = iloIntDomainArray[n2].getMin();
            ++n2;
        }
    }

    public IloIntNaryTable(int n2) {
        this.mn = false;
        this.nn = null;
        this.ln = n2;
        this._xMin = new int[this.ln];
        this._xMax = new int[this.ln];
        this.kn = new int[this.ln];
        this.jn = new IloNaryTableSupportSet[this.ln][];
        int n3 = 0;
        while (n3 < this.ln) {
            this._xMin[n3] = Integer.MAX_VALUE;
            this._xMax[n3] = -2147483647;
            ++n3;
        }
    }

    public IloIntNaryTable(int[][] nArray) {
        this.ln = nArray.length;
        this._xMin = new int[this.ln];
        this._xMax = new int[this.ln];
        this.kn = new int[this.ln];
        this.jn = new IloNaryTableSupportSet[this.ln][];
        int n2 = 0;
        while (n2 < nArray.length) {
            this._xMin[n2] = nArray[n2][0];
            this._xMax[n2] = nArray[n2][0];
            int n3 = 0;
            while (n3 < nArray[n2].length) {
                int n4 = nArray[n2][n3];
                if (this._xMin[n2] > n4) {
                    this._xMin[n2] = n4;
                }
                if (this._xMax[n2] < n4) {
                    this._xMax[n2] = n4;
                }
                ++n3;
            }
            this.kn[n2] = this._xMax[n2] - this._xMin[n2] + 1;
            this.jn[n2] = new IloNaryTableSupportSet[this.kn[n2]];
            ++n2;
        }
    }

    public void add(int[] nArray) {
        if (nArray.length != this.ln) {
            throw new IloRuntimeException("a tuple must have the same dimension as the table");
        }
        if (this.mn) {
            throw new IloRuntimeException("A tuple cannot be added to a table that is already closed");
        }
        int[] nArray2 = (int[])nArray.clone();
        this.nn = new rf(nArray2, this.nn);
        int n2 = 0;
        while (n2 < this.ln) {
            if (this._xMin[n2] > nArray[n2]) {
                this._xMin[n2] = nArray[n2];
            }
            if (this._xMax[n2] < nArray[n2]) {
                this._xMax[n2] = nArray[n2];
            }
            ++n2;
        }
    }

    public synchronized void close() {
        int n2;
        if (this.mn) {
            return;
        }
        this.mn = true;
        if (this.nn == null) {
            n2 = 0;
            while (n2 < this.ln) {
                this._xMax[n2] = 0;
                this._xMin[n2] = 0;
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.ln) {
            this.kn[n2] = this._xMax[n2] - this._xMin[n2] + 1;
            this.jn[n2] = new IloNaryTableSupportSet[this.kn[n2]];
            ++n2;
        }
        rf rf2 = this.nn;
        while (rf2 != null) {
            this.lg(rf2.cm);
            rf2 = rf2.bm;
        }
    }

    void lg(int[] nArray) {
        IloNaryTableSupportSet iloNaryTableSupportSet = new IloNaryTableSupportSet(nArray);
        int n2 = 0;
        while (n2 < this.ln) {
            int n3 = nArray[n2] - this._xMin[n2];
            if (this.jn[n2][n3] != null) {
                if (this.jn[n2][n3].lessThanFirst(iloNaryTableSupportSet, n2)) {
                    this.jn[n2][n3].addBefore(iloNaryTableSupportSet, n2);
                    this.jn[n2][n3] = iloNaryTableSupportSet;
                } else {
                    this.jn[n2][n3].add(iloNaryTableSupportSet, n2);
                }
            } else {
                this.jn[n2][n3] = iloNaryTableSupportSet;
            }
            ++n2;
        }
    }

    public IloIntNaryOppositeTable opposite() {
        return new IloIntNaryOppositeTable(this);
    }

    public IloNaryTableSupportSet firstSupport(int n2, int n3) {
        if (n3 < this._xMin[n2] || n3 > this._xMax[n2]) {
            return null;
        }
        return this.jn[n2][n3 - this._xMin[n2]];
    }

    public IloNaryTableSupportSet nextCircularSupport(int n2, int n3, IloNaryTableSupportSet iloNaryTableSupportSet) {
        if (iloNaryTableSupportSet.fdc[n2] == null) {
            return this.firstSupport(n2, n3);
        }
        return iloNaryTableSupportSet.fdc[n2];
    }

    public IloNaryTableSupportSet nextSupport(int n2, int n3, IloNaryTableSupportSet iloNaryTableSupportSet) {
        return iloNaryTableSupportSet.fdc[n2];
    }

    public synchronized String toString() {
        return "table(" + this.ln + ")";
    }

    public void aff() {
        if (!this.mn) {
            System.out.print("table not closed");
            return;
        }
        int n2 = 0;
        while (n2 < this.ln) {
            System.out.print("array" + n2 + "[");
            System.out.print(this._xMin[n2]);
            System.out.print(", ");
            System.out.print(this._xMax[n2]);
            System.out.println(")]");
            int n3 = this._xMin[n2];
            while (n3 <= this._xMax[n2]) {
                int n4 = n3 - this._xMin[n2];
                if (this.jn[n2][n4] != null) {
                    System.out.println("Value " + n3);
                    this.jn[n2][n4].aff(n2);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public class Iterator
    implements java.util.Iterator {
        rf fsb;

        public Iterator() {
            rf rf2 = IloIntNaryTable.this.nn;
        }

        public boolean hasNext() {
            return this.fsb != null;
        }

        public Object next() {
            int[] nArray = this.fsb.cm;
            this.fsb = this.fsb.bm;
            return nArray;
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    class rf {
        rf bm;
        int[] cm;

        rf(int[] nArray, rf rf2) {
            this.bm = rf2;
            this.cm = nArray;
        }
    }
}

