/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcFloat;
import ilog.solver.IlcSolver;
import ilog.solver.hg;
import ilog.solver.hy;
import ilog.solver.nm;

final class ei
extends hy {
    final nm jr;

    public ei(nm nm2) {
        this.jr = nm2;
        nm2.isUsed(this);
    }

    public IlcSolver getSolver() {
        return this.jr.getSolver();
    }

    protected hg[] getArgs() {
        return new hg[]{this.jr};
    }

    protected void computeRange() {
        double d2 = this.jr.getDomainLB();
        double d3 = this.jr.getDomainUB();
        if (this.jr.in()) {
            this.setNaN();
        } else if (d2 >= 0.0) {
            this.bzb = IlcFloat.roundDown(d2 * d2);
            this.czb = IlcFloat.roundUp(d3 * d3);
        } else if (d3 <= 0.0) {
            this.bzb = IlcFloat.roundDown(d3 * d3);
            this.czb = IlcFloat.roundUp(d2 * d2);
        } else {
            double d4 = Math.max(-d2, d3);
            this.bzb = 0.0;
            this.czb = IlcFloat.roundUp(d4 * d4);
        }
    }

    protected void setRangeInternal(double d2, double d3) {
        double d4;
        if (d2 > 0.0) {
            d4 = IlcFloat.sqrtDown(d2);
            double d5 = this.jr.getDomainLB();
            double d6 = this.jr.getDomainUB();
            if (Math.abs(d5) < d4) {
                this.jr.setDomainLB(d4);
            }
            if (Math.abs(d6) < d4) {
                this.jr.setDomainUB(-d4);
            }
        }
        if (d3 >= 0.0) {
            d4 = IlcFloat.sqrtUp(d3);
            this.jr.setDomainRange(-d4, d4);
        } else {
            this.fail();
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("square(");
        stringBuffer.append(this.jr);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

