/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloException;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcNumExpr;
import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverRuntimeError;
import ilog.solver.nm;
import ilog.solver.nu;

public abstract class IlcFloatExpr
extends IlcNumExpr {
    protected nm _extracted;
    int pf = -1;
    int qf = -1;
    int rf = -1;
    boolean sf = false;

    protected IlcFloatExpr() {
    }

    public final nm getPNumExp(IlcSolver ilcSolver) throws IlcSolverRuntimeError.Extraction {
        if (this._extracted instanceof nu) {
            ilcSolver.registerExtracted(this);
            try {
                this._extracted = (nm)this.extract(ilcSolver);
                if (this.sf) {
                    this._extracted.setPrecision(this.pf, this.qf, this.rf);
                }
            }
            catch (IloException iloException) {
                throw new IlcSolverRuntimeError.Extraction(iloException.getMessage(), iloException);
            }
            if (this.shouldHaveDomain()) {
                this._extracted.kn();
            }
        }
        return this._extracted;
    }

    public final Object getExtracted(IlcSolver ilcSolver) throws IlcSolverRuntimeError.Extraction {
        return this.getPNumExp(ilcSolver);
    }

    public void resetExtracted(IlcSolver ilcSolver) {
        this._extracted = new nu(this, ilcSolver);
    }

    public synchronized String toString() {
        if (!(this._extracted instanceof nu)) {
            return this._extracted.toString();
        }
        return super.toString();
    }

    public boolean hasDomain() {
        return this._extracted.jn();
    }

    public void createDomain() {
        this._extracted.kn();
    }

    public IlcSolver getSolver() {
        return this._extracted.getSolver();
    }

    public double getDomainDiameter() {
        return this._extracted.getDomainDiameter();
    }

    public int getNbOfConstraints() {
        return this._extracted.getNbOfConstraints();
    }

    public boolean isBound() {
        return this._extracted.isBound();
    }

    public boolean isNaN() {
        return this._extracted.isNaN();
    }

    public double getDomainLB() {
        return this._extracted.getDomainLB();
    }

    public double getDomainUB() {
        return this._extracted.getDomainUB();
    }

    public void setDomainLB(double d2) {
        this._extracted.setDomainLB(d2);
    }

    public void setDomainUB(double d2) {
        this._extracted.setDomainUB(d2);
    }

    public void setDomainRange(double d2, double d3) {
        this._extracted.setDomainRange(d2, d3);
    }

    public void setDomainRangeNoCast(double d2, double d3) {
        this._extracted.setDomainRangeNoCast(d2, d3);
    }

    public void whenRange(IlcDemon ilcDemon) {
        this._extracted.whenRange(ilcDemon);
    }

    public void whenRange(IlcConstraint ilcConstraint) {
        this._extracted.whenRange(ilcConstraint.getPropagator(this.getSolver()));
    }

    public void setPrecision(int n2) {
        this.setPrecision(n2, n2);
    }

    public void setPrecision(int n2, int n3) {
        this.setPrecision(n2, n3, 1);
    }

    public void setPrecision(int n2, int n3, int n4) {
        this.sf = true;
        this.pf = n2;
        this.qf = n3;
        this.rf = n4;
    }

    public int getRelativePrecision() {
        return this.pf;
    }

    public int getAbsolutePrecision() {
        return this.qf;
    }

    public int getGuardDigits() {
        return this.rf;
    }

    public double getBoundCastDownMid() {
        return this._extracted.getBoundCastDownMid();
    }

    public double boundCastDown(double d2) {
        return this._extracted.boundCastDown(d2);
    }

    public double boundCastUp(double d2) {
        return this._extracted.boundCastUp(d2);
    }

    public double boundNextDown(double d2) {
        return this._extracted.boundNextDown(d2);
    }

    public double boundNextUp(double d2) {
        return this._extracted.boundNextUp(d2);
    }

    public double propagationCastDown(double d2) {
        return this._extracted.propagationCastDown(d2);
    }

    public double propagationCastUp(double d2) {
        return this._extracted.propagationCastUp(d2);
    }

    public double propagationNextDown(double d2) {
        return this._extracted.propagationNextDown(d2);
    }

    public double propagationNextUp(double d2) {
        return this._extracted.propagationNextUp(d2);
    }
}

