/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloNumVarType;
import ilog.solver.IlcDemon;
import ilog.solver.IlcNum;
import ilog.solver.IlcReversibleAction;
import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverRuntimeError;
import ilog.solver.nm;
import ilog.solver.ot;
import ilog.solver.qbb;

final class gab
extends nm {
    final IlcSolver hdc;
    double idc;
    double jdc;
    int kdc;
    ot ldc;
    qbb mdc;
    boolean ndc;
    IlcNum odc;
    String pdc;
    IloNumVarType qdc;

    public gab(IlcSolver ilcSolver, double d2, double d3) {
        this(ilcSolver, d2, d3, IloNumVarType.Float, null);
    }

    public gab(IlcSolver ilcSolver, double d2, double d3, IloNumVarType iloNumVarType) {
        this(ilcSolver, d2, d3, iloNumVarType, null);
    }

    public gab(IlcSolver ilcSolver, double d2, double d3, IloNumVarType iloNumVarType, String string) {
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            throw new IlcSolverRuntimeError.vab("with NaN bound.");
        }
        if (d2 > d3) {
            throw new IlcSolverRuntimeError.vab("with max < min.");
        }
        if (d2 == Double.POSITIVE_INFINITY || d3 == Double.NEGATIVE_INFINITY) {
            throw new IlcSolverRuntimeError.vab("instantiated at Infinity.");
        }
        this.hdc = ilcSolver;
        this.hdc.rd();
        this.qdc = iloNumVarType;
        this.odc = ilcSolver.getNum();
        double d4 = d2;
        double d5 = d3;
        if (iloNumVarType != IloNumVarType.Float) {
            if (iloNumVarType == IloNumVarType.Int) {
                d4 = Math.ceil(d2);
                d5 = Math.floor(d3);
            } else if (iloNumVarType == IloNumVarType.Bool) {
                d4 = Math.ceil(d2);
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if ((d5 = Math.floor(d3)) > 1.0) {
                    d5 = 1.0;
                }
            } else {
                throw new IlcSolverRuntimeError.vab("of unknown type:" + iloNumVarType);
            }
        }
        if (d4 > d5) {
            throw new IlcSolverRuntimeError.vab("of type " + iloNumVarType + " between " + d2 + " and " + d3);
        }
        this.idc = d4;
        this.jdc = d5;
        this.mdc = new qbb(ilcSolver);
        this.kdc = ilcSolver.sj - 1;
        this.ldc = new ot(ilcSolver);
        this.ndc = false;
        this.pdc = string;
    }

    public IlcSolver getSolver() {
        return this.hdc;
    }

    boolean jn() {
        return true;
    }

    void kn() {
    }

    public double getBoundCastDownMid() {
        double d2 = this.idc * 0.5 + this.jdc * 0.5;
        if (Double.isNaN(d2)) {
            d2 = 0.0;
        } else if ((d2 = this.odc.boundCastDown(d2)) <= this.idc) {
            d2 = this.odc.boundNextUp(this.idc);
        } else if (this.jdc <= d2) {
            d2 = this.odc.boundNextDown(this.jdc);
        }
        return d2;
    }

    public boolean isBound() {
        return this.odc.isBound(this.idc, this.jdc);
    }

    public final boolean isNaN() {
        return false;
    }

    public final boolean in() {
        return false;
    }

    public void setPrecision(int n2, int n3, int n4) {
        this.odc = new IlcNum(n2, n3, n4);
    }

    public int getRelativePrecision() {
        return this.odc.getRelativePrecision();
    }

    public int getAbsolutePrecision() {
        return this.odc.getAbsolutePrecision();
    }

    public int getGuardDigits() {
        return this.odc.getGuardDigits();
    }

    public double boundCastDown(double d2) {
        return this.odc.boundCastDown(d2);
    }

    public double boundCastUp(double d2) {
        return this.odc.boundCastUp(d2);
    }

    public double boundNextDown(double d2) {
        return this.odc.boundNextDown(d2);
    }

    public double boundNextUp(double d2) {
        return this.odc.boundNextUp(d2);
    }

    public double propagationCastDown(double d2) {
        return this.odc.propagationCastDown(d2);
    }

    public double propagationCastUp(double d2) {
        return this.odc.propagationCastUp(d2);
    }

    public double propagationNextDown(double d2) {
        return this.odc.propagationNextDown(d2);
    }

    public double propagationNextUp(double d2) {
        return this.odc.propagationNextUp(d2);
    }

    public void reCompute() {
        this.ldc.gs();
    }

    protected final void isUsed(nm nm2) {
        this.ldc.fs(nm2);
    }

    public double getDomainLB() {
        return this.idc;
    }

    public double getDomainUB() {
        return this.jdc;
    }

    public void setDomainLB(double d2) {
        this.setDomainRange(d2, this.jdc);
    }

    public void setDomainUB(double d2) {
        this.setDomainRange(this.idc, d2);
    }

    public void setDomainLBNoCast(double d2) {
        this.setDomainRangeNoCast(d2, this.jdc);
    }

    public void setDomainUBNoCast(double d2) {
        this.setDomainRangeNoCast(this.idc, d2);
    }

    private void gy() {
        this.reCompute();
        this.ndc = true;
        if (this.hdc.sj > this.kdc) {
            ik ik2 = new ik(this, this.idc, this.jdc);
            this.hdc.addReversibleAction(ik2);
            this.kdc = this.hdc.sj;
        }
    }

    public void setDomainRange(double d2, double d3) {
        double d4 = d2;
        double d5 = d3;
        if (this.qdc == IloNumVarType.Float) {
            d4 = this.odc.propagationCastDown(d4);
            d5 = this.odc.propagationCastUp(d5);
        } else {
            d4 = Math.ceil(d2);
            d5 = Math.floor(d3);
        }
        if (d4 > d5 || d5 < this.idc || this.jdc < d4) {
            if (this.hdc.mj) {
                System.out.println("fail on " + this);
            }
            this.hdc.fail();
        }
        if (d4 <= this.idc && this.jdc <= d5) {
            return;
        }
        this.gy();
        if (this.idc < d4) {
            this.idc = d4;
        }
        if (d5 < this.jdc) {
            this.jdc = d5;
        }
        if (this.hdc.jj) {
            System.out.println("Set Range " + d2 + " .." + d3 + " from " + this);
        }
        this.hdc.rj.push(this);
    }

    public void setDomainRangeNoCast(double d2, double d3) {
        double d4 = d2;
        double d5 = d3;
        if (this.qdc != IloNumVarType.Float) {
            d4 = Math.ceil(d2);
            d5 = Math.floor(d3);
        }
        if (d4 > d5 || d5 < this.idc || this.jdc < d4) {
            if (this.hdc.mj) {
                System.out.println("fail on " + this);
            }
            this.hdc.fail();
        }
        if (d4 <= this.idc && this.jdc <= d5) {
            return;
        }
        this.gy();
        if (this.idc < d4) {
            this.idc = d4;
        }
        if (d5 < this.jdc) {
            this.jdc = d5;
        }
        if (this.hdc.jj) {
            System.out.println("Set Range " + d2 + " .." + d3 + " from " + this);
        }
        this.hdc.rj.push(this);
    }

    public int getNbOfConstraints() {
        return this.mdc.vy();
    }

    void kg() {
        if (this.hdc.kj) {
            System.out.println("Processing Var " + this);
        }
        if (this.ndc) {
            this.ndc = false;
            this.mdc.zy(this.hdc);
        }
    }

    public void whenRange(IlcDemon ilcDemon) {
        this.mdc.yy(this.hdc, ilcDemon);
    }

    public void whenValue(IlcDemon ilcDemon) {
        throw new UnsupportedOperationException("whenValue not supported");
    }

    public void whenDomain(IlcDemon ilcDemon) {
        this.whenRange(ilcDemon);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        double d2 = this.getDomainLB();
        double d3 = this.getDomainUB();
        if (this.pdc != null) {
            stringBuffer.append(this.pdc);
        }
        stringBuffer.append("[");
        String string = this.odc.toString_roundDown(d2);
        String string2 = this.odc.toString_roundUp(d3);
        stringBuffer.append(string);
        if (!string.equals(string2)) {
            stringBuffer.append("..");
            stringBuffer.append(string2);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static final class ik
    extends IlcReversibleAction {
        gab cw;
        double dw;
        double ew;

        ik(gab gab2, double d2, double d3) {
            this.cw = gab2;
            this.dw = d2;
            this.ew = d3;
        }

        public void restore(IlcSolver ilcSolver) {
            this.cw.idc = this.dw;
            this.cw.jdc = this.ew;
            this.cw.ndc = false;
            this.cw = null;
        }
    }
}

