/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntSet;
import ilog.solver.IlcIntSetExpr;
import ilog.solver.IlcIterator;
import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverRuntimeError;
import ilog.solver.xh;
import java.util.Arrays;

public class IlcIntSet
extends IlcIntSetExpr
implements IloIntSet {
    protected int _min;
    protected int _max;
    protected int[] _values = null;
    private xh akb;

    IlcIntSet(int n2, int n3) {
        this._min = n2;
        this._max = n3;
    }

    IlcIntSet(int[] nArray) {
        int n2 = nArray.length;
        if (n2 < 2) {
            this._values = nArray;
            if (n2 == 0) {
                this._min = -2147483647;
                this._max = Integer.MAX_VALUE;
            } else if (n2 == 1) {
                this._min = this._max = nArray[0];
            }
        } else {
            int[] nArray2 = (int[])nArray.clone();
            Arrays.sort(nArray2);
            int n3 = 1;
            int n4 = nArray2[0];
            this._min = nArray[0];
            this._max = nArray[n2 - 1];
            int n5 = 1;
            while (n5 < n2) {
                if (nArray2[n5] != n4) {
                    nArray2[n3] = n4 = nArray2[n5];
                    ++n3;
                }
                ++n5;
            }
            if (n3 < n2) {
                this._values = new int[n3];
                n5 = 0;
                while (n5 < n3) {
                    this._values[n5] = nArray2[n5];
                    ++n5;
                }
            } else {
                this._values = nArray2;
            }
        }
    }

    IlcIntSet(int[] nArray, boolean bl2) {
        int n2 = nArray.length;
        if (n2 == 0) {
            this._min = -2147483647;
            this._max = Integer.MAX_VALUE;
        } else {
            this._min = nArray[0];
            this._max = nArray[n2 - 1];
        }
        this._values = nArray;
    }

    public int getMin() {
        return this._min;
    }

    public int getMax() {
        return this._max;
    }

    public int[] getValues() {
        return this._values;
    }

    public int getSize() {
        if (this._values != null) {
            return this._values.length;
        }
        return this._max - this._min + 1;
    }

    public IlcIterator iterator() {
        if (this._values == null) {
            return new ru();
        }
        return new zbb();
    }

    public final Object getExtracted(IlcSolver ilcSolver) throws IlcSolverRuntimeError.Extraction {
        if (this.akb == null) {
            ilcSolver.registerExtracted(this);
            try {
                this.akb = (xh)this.extract(ilcSolver);
            }
            catch (IloException iloException) {
                throw new IlcSolverRuntimeError.Extraction(iloException.getMessage(), iloException);
            }
        }
        return this.akb;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        if (this._values == null) {
            return new xh(ilcSolver, this._min, this._max, true);
        }
        return new xh(ilcSolver, this._values);
    }

    public void resetExtracted(IlcSolver ilcSolver) {
        this.akb = null;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Set : [");
        if (this._values == null) {
            stringBuffer.append(this._min);
            stringBuffer.append("..");
            stringBuffer.append(this._max);
        } else {
            int n2 = 0;
            while (n2 < this._values.length) {
                stringBuffer.append(this._values[n2]);
                stringBuffer.append(" ");
                ++n2;
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        if (this._values == null) {
            return iloCPModeler.intSet(this._min, this._max);
        }
        return iloCPModeler.intSet(this._values);
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        if (check instanceof IloCopyManager.ExistGroundTerm) {
            throw check;
        }
    }

    public boolean contains(int n2) {
        if (this._values == null) {
            return this._min <= n2 && n2 <= this._max;
        }
        int n3 = 0;
        while (n3 < this._values.length) {
            if (this._values[n3] == n2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public IlcIntSet makeCopy() {
        if (this._values == null) {
            return new IlcIntSet(this._min, this._max);
        }
        return new IlcIntSet((int[])this._values.clone());
    }

    public void add(int n2) {
        if (this.contains(n2)) {
            return;
        }
        if (this._values == null) {
            int n3 = this._max - this._min + 1;
            int[] nArray = new int[n3 + 1];
            int n4 = 0;
            while (n4 < n3) {
                nArray[n4] = this._min + n4;
                ++n4;
            }
            nArray[n3] = n2;
            this._values = nArray;
        } else {
            int[] nArray = new int[this._values.length + 1];
            int n5 = 0;
            while (n5 < this._values.length) {
                nArray[n5] = this._values[n5];
                ++n5;
            }
            nArray[this._values.length] = n2;
            this._values = nArray;
        }
    }

    public void remove(int n2) {
        if (!this.contains(n2)) {
            return;
        }
        if (this._values == null) {
            int n3 = this._max - this._min + 1;
            int n4 = 0;
            int[] nArray = new int[n3 - 1];
            int n5 = 0;
            while (n5 < n3) {
                if (this._min + n5 == n2) {
                    n4 = -1;
                } else {
                    nArray[n5 + n4] = this._min + n5;
                }
                ++n5;
            }
            this._values = nArray;
        } else {
            int[] nArray = new int[this._values.length - 1];
            int n6 = 0;
            int n7 = 0;
            while (n7 < this._values.length) {
                if (this._values[n7] == n2) {
                    n6 = -1;
                } else {
                    nArray[n7 + n6] = this._values[n7];
                }
                ++n7;
            }
            this._values = nArray;
        }
    }

    class ru
    extends IlcIterator {
        private int xqb;

        ru() {
            this.xqb = IlcIntSet.this._min;
        }

        public int nextValue() {
            return this.xqb++;
        }

        public boolean hasNext() {
            return this.xqb <= IlcIntSet.this._max;
        }
    }

    class zbb
    extends IlcIterator {
        private int kgc = 0;

        zbb() {
        }

        public int nextValue() {
            return IlcIntSet.this._values[this.kgc++];
        }

        public boolean hasNext() {
            return this.kgc < IlcIntSet.this._values.length;
        }
    }
}

