/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uchicago.src.sim.parameter.NumericParameter;
import uchicago.src.sim.parameter.Parameter;

public class XMLParameterReader {
    private Document doc;
    private Vector params = new Vector();
    private Vector tempVec = new Vector();
    private Hashtable methodTable = new Hashtable();

    public XMLParameterReader(String string) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.doc = documentBuilder.parse(new FileInputStream(string), string);
            documentBuilder.parse(string);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private Parameter parseElement(Element element, Parameter parameter, long l) {
        Object object;
        NamedNodeMap namedNodeMap = element.getAttributes();
        String string = namedNodeMap.getNamedItem("name").getNodeValue();
        NumericParameter numericParameter = new NumericParameter();
        numericParameter.setNumRuns(l);
        numericParameter.setName(string);
        String string2 = "";
        if (parameter != null) {
            numericParameter.setParent(parameter);
            parameter.addChild(numericParameter);
            string2 = parameter.getName();
        }
        String string3 = "";
        if (namedNodeMap.getNamedItem("type") != null && (object = (Method)this.methodTable.get(string3 = namedNodeMap.getNamedItem("type").getNodeValue().toLowerCase())) != null) {
            try {
                ((Method)object).invoke((Object)this, numericParameter, namedNodeMap);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (namedNodeMap.getNamedItem("io") != null) {
            object = namedNodeMap.getNamedItem("io").getNodeValue();
            if (((String)object).equalsIgnoreCase("input")) {
                numericParameter.setInput(true);
            } else {
                numericParameter.setInput(false);
            }
        } else {
            numericParameter.setInput(true);
        }
        System.out.println(string + " " + string3 + " runs - " + l + " parent - " + string2);
        this.tempVec.add(numericParameter);
        return numericParameter;
    }

    private long parseParamBlock(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        Node node = namedNodeMap.getNamedItem("runs");
        return Long.parseLong(node.getNodeValue());
    }

    private void doParse(Node node, Parameter parameter, long l) {
        switch (node.getNodeType()) {
            case 9: {
                Document document = (Document)node;
                this.doParse(document.getDocumentElement(), parameter, 0L);
                break;
            }
            case 1: {
                String string = node.getNodeName();
                if (string.equalsIgnoreCase("Repast:ParamBlock")) {
                    l = this.parseParamBlock((Element)node);
                } else if (string.equalsIgnoreCase("Repast:Param")) {
                    parameter = this.parseElement((Element)node, parameter, l);
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.doParse(nodeList.item(i), parameter, l);
                }
                break;
            }
        }
        parameter = null;
    }

    public void parse() {
        this.createMethodLookupTable();
        this.doParse(this.doc, null, 0L);
        for (int i = 0; i < this.tempVec.size(); ++i) {
            Parameter parameter = (Parameter)this.tempVec.get(i);
            if (parameter.getParent() != null) continue;
            this.params.add(parameter);
        }
    }

    public Vector getParameters() {
        return this.params;
    }

    public NumericParameter handleIncr(NumericParameter numericParameter, NamedNodeMap namedNodeMap) throws IOException {
        Double d = this.getNumber(numericParameter, "start", namedNodeMap.getNamedItem("start").getNodeValue());
        Double d2 = this.getNumber(numericParameter, "end", namedNodeMap.getNamedItem("end").getNodeValue());
        Double d3 = this.getNumber(numericParameter, "incr", namedNodeMap.getNamedItem("incr").getNodeValue());
        numericParameter.setStart(d);
        numericParameter.setEnd(d2);
        numericParameter.setIncr(d3);
        return numericParameter;
    }

    public NumericParameter handleList(NumericParameter numericParameter, NamedNodeMap namedNodeMap) throws IOException {
        Vector<Double> vector = new Vector<Double>();
        String string = namedNodeMap.getNamedItem("value").getNodeValue();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(this.getNumber(numericParameter, "value", stringTokenizer.nextToken()));
        }
        numericParameter.setList(vector);
        return numericParameter;
    }

    public NumericParameter handleConst(NumericParameter numericParameter, NamedNodeMap namedNodeMap) throws IOException {
        String string = namedNodeMap.getNamedItem("value").getNodeValue();
        numericParameter.setConstVal(this.getNumber(numericParameter, "value", string));
        return numericParameter;
    }

    public NumericParameter handleBooleanList(NumericParameter numericParameter, NamedNodeMap namedNodeMap) throws IOException {
        Vector<Boolean> vector = new Vector<Boolean>();
        String string = namedNodeMap.getNamedItem("value").getNodeValue();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(this.getBoolean(numericParameter, "value", stringTokenizer.nextToken()));
        }
        numericParameter.setList(vector);
        return numericParameter;
    }

    public NumericParameter handleBooleanConst(NumericParameter numericParameter, NamedNodeMap namedNodeMap) throws IOException {
        String string = namedNodeMap.getNamedItem("value").getNodeValue();
        numericParameter.setConstVal(this.getBoolean(numericParameter, "value", string));
        return numericParameter;
    }

    public NumericParameter handleStringList(NumericParameter numericParameter, NamedNodeMap namedNodeMap) throws IOException {
        Vector<String> vector = new Vector<String>();
        String string = namedNodeMap.getNamedItem("value").getNodeValue();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        numericParameter.setList(vector);
        return numericParameter;
    }

    public NumericParameter handleStringConst(NumericParameter numericParameter, NamedNodeMap namedNodeMap) throws IOException {
        String string = namedNodeMap.getNamedItem("value").getNodeValue();
        numericParameter.setConstVal(string);
        return numericParameter;
    }

    private void createMethodLookupTable() {
        Class clazz = XMLParameterReader.class;
        try {
            Method method = clazz.getMethod("handleIncr", NumericParameter.class, NamedNodeMap.class);
            this.methodTable.put("incr", method);
            method = clazz.getMethod("handleList", NumericParameter.class, NamedNodeMap.class);
            this.methodTable.put("list", method);
            method = clazz.getMethod("handleConst", NumericParameter.class, NamedNodeMap.class);
            this.methodTable.put("const", method);
            method = clazz.getMethod("handleBooleanList", NumericParameter.class, NamedNodeMap.class);
            this.methodTable.put("boolean_list", method);
            method = clazz.getMethod("handleBooleanConst", NumericParameter.class, NamedNodeMap.class);
            this.methodTable.put("boolean_const", method);
            method = clazz.getMethod("handleStringList", NumericParameter.class, NamedNodeMap.class);
            this.methodTable.put("string_list", method);
            method = clazz.getMethod("handleStringConst", NumericParameter.class, NamedNodeMap.class);
            this.methodTable.put("string_const", method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
    }

    private Double getNumber(NumericParameter numericParameter, String string, String string2) throws IOException {
        try {
            Double d = new Double(string2);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = "Attribute '" + string + "' for parameter '" + numericParameter.getName() + "' must be a number";
            throw new IOException(string3);
        }
    }

    private Boolean getBoolean(NumericParameter numericParameter, String string, String string2) throws IOException {
        if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false")) {
            return new Boolean(string2);
        }
        String string3 = "Attribute '" + string + "' for parameter '" + numericParameter.getName() + "' must be 'true' or 'false'";
        throw new IOException(string3);
    }

    public static void main(String[] stringArray) {
        try {
            XMLParameterReader xMLParameterReader = new XMLParameterReader("/home/nick/src/uchicago/src/sim/engine/pFile.xml");
            xMLParameterReader.parse();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }
}

