/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.collection;

import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import java.util.BitSet;

public class BitMatrix2D {
    private BitSet matrix;
    private int rows;
    private int cols;

    public BitMatrix2D(int n, int n2) {
        this.matrix = new BitSet(n * n2);
        this.rows = n;
        this.cols = n2;
    }

    public BitMatrix2D(byte[][] byArray) {
        this.rows = byArray.length;
        this.cols = byArray.length == 0 ? 0 : byArray[0].length;
        for (int i = 0; i < byArray.length; ++i) {
            for (int j = 0; j < byArray[0].length; ++j) {
                if (byArray[i][j] <= 0) continue;
                this.matrix.set(i * this.cols + j);
            }
        }
    }

    public DenseDoubleMatrix1D getRow(int n) {
        double[] dArray = new double[this.cols];
        int n2 = n * this.cols;
        for (int i = 0; i < this.cols; ++i) {
            dArray[i] = this.matrix.get(n2 + i) ? 1.0 : 0.0;
        }
        return new DenseDoubleMatrix1D(dArray);
    }

    public void set(int n, int n2, byte by) {
        if (by > 0) {
            this.matrix.set(n * this.cols + n2);
        } else {
            this.matrix.clear(n * this.cols + n2);
        }
    }

    public byte get(int n, int n2) {
        return (byte)(this.matrix.get(n * this.cols + n2) ? 1 : 0);
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.cols;
    }

    public double zSum() {
        double d = 0.0;
        for (int i = 0; i < this.matrix.size(); ++i) {
            if (!this.matrix.get(i)) continue;
            d += 1.0;
        }
        return d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.rows);
        stringBuffer.append(" x ");
        stringBuffer.append(this.cols);
        stringBuffer.append("\n");
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (j != 0) {
                    stringBuffer.append(" ");
                }
                if (this.matrix.get(i * this.cols + j)) {
                    stringBuffer.append(1);
                    continue;
                }
                stringBuffer.append(0);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        BitMatrix2D bitMatrix2D = new BitMatrix2D(10, 10);
        bitMatrix2D.set(1, 4, (byte)1);
        bitMatrix2D.set(8, 2, (byte)1);
        System.out.println(bitMatrix2D.get(1, 4));
        System.out.println(bitMatrix2D.getRow(8));
        System.out.println(bitMatrix2D.toString());
    }
}

