/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.task.distribution;

import epfl.lia.logist.core.topology.City;
import epfl.lia.logist.core.topology.Topology;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.task.ProbabilityDescriptor;
import epfl.lia.logist.task.ProbabilityDistribution;
import epfl.lia.logist.task.Task;
import epfl.lia.logist.task.TaskDescriptor;
import epfl.lia.logist.task.TaskDistributionDescriptor;
import epfl.lia.logist.task.distribution.ITaskDistribution;
import epfl.lia.logist.task.distribution.function.BinaryDensityFunction;
import epfl.lia.logist.task.distribution.function.DiracDensityFunction;
import epfl.lia.logist.task.distribution.function.IFunction;
import epfl.lia.logist.task.distribution.function.NormalDensityFunction;
import epfl.lia.logist.task.distribution.function.UniformDensityFunction;
import epfl.lia.logist.tools.Convert;
import epfl.lia.logist.tools.Pair;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.math.random.RandomDataImpl;

public class ProbabilisticTaskDistribution
implements ITaskDistribution {
    ProbabilityDistribution mProbDistribution = null;
    protected IFunction mRewardDensity = null;
    protected IFunction mProbDensity = null;
    protected IFunction mWeightDensity = null;
    protected boolean mNormalize = false;
    protected int mCount = 0;
    protected RandomDataImpl mRandom = new RandomDataImpl();
    private String[] mCityArray = null;

    public ProbabilisticTaskDistribution(TaskDistributionDescriptor tdd) throws Exception {
        this.initDistribution(tdd);
        int i = 0;
        this.mCityArray = new String[Topology.getInstance().getCities().size()];
        for (City c : Topology.getInstance().getCities().values()) {
            this.mCityArray[i++] = c.getNodeLabel();
        }
    }

    protected IFunction findFunction(String name, Properties props) {
        if (name == null) {
            return null;
        }
        if (name.equals("binary")) {
            return new BinaryDensityFunction();
        }
        if (name.equals("gaussian") || name.equals("normal")) {
            return new NormalDensityFunction();
        }
        if (name.equals("uniform")) {
            return new UniformDensityFunction();
        }
        if (name.equals("constant")) {
            return new DiracDensityFunction();
        }
        if (props != null && props.containsKey("type")) {
            String type = props.getProperty("type");
            if (type.equals("binary")) {
                return new BinaryDensityFunction(props);
            }
            if (type.equals("gaussian") || type.equals("normal")) {
                return new NormalDensityFunction(props);
            }
            if (type.equals("uniform")) {
                return new UniformDensityFunction(props);
            }
            if (type.equals("constant")) {
                return new DiracDensityFunction(props);
            }
            return null;
        }
        return null;
    }

    protected void initDistribution(TaskDistributionDescriptor tdd) throws Exception {
        Topology topo = Topology.getInstance();
        LogManager log = LogManager.getInstance();
        Pair<City> pair = null;
        long seed = Convert.toLong(tdd.Props.getProperty("seed"), 12345L);
        this.mRandom.reSeed(seed);
        this.mNormalize = Convert.toBoolean(tdd.Props.getProperty("normalize"), true);
        String probDensityFn = Convert.toString(tdd.Props.getProperty("probability"), "default");
        String rewardDensityFn = Convert.toString(tdd.Props.getProperty("reward"), "default");
        String weightDensityFn = Convert.toString(tdd.Props.getProperty("weight"), "constant");
        Properties probDensityParams = tdd.DensityFunctions.get(probDensityFn);
        Properties rewardDensityParams = tdd.DensityFunctions.get(rewardDensityFn);
        Properties weightDensityParams = tdd.DensityFunctions.get(weightDensityFn);
        this.mProbDensity = this.findFunction(probDensityFn, probDensityParams);
        if (this.mProbDensity == null) {
            throw new Exception("Could not found a valid density function for probability description !");
        }
        this.mRewardDensity = this.findFunction(rewardDensityFn, rewardDensityParams);
        if (this.mRewardDensity == null) {
            throw new Exception("Could not found a valid density function for reward description !");
        }
        this.mWeightDensity = this.findFunction(weightDensityFn, weightDensityParams);
        if (this.mWeightDensity == null) {
            throw new Exception("Could not found a valid density function for weight description !");
        }
        assert (this.mProbDensity != null && this.mRewardDensity != null);
        HashMap<Pair<City>, Double> mProbMap = new HashMap<Pair<City>, Double>();
        HashMap<Pair<City>, Double> mRewardMap = new HashMap<Pair<City>, Double>();
        if (tdd.ProbDescriptorList != null && tdd.ProbDescriptorList.size() > 0) {
            for (ProbabilityDescriptor pp : tdd.ProbDescriptorList) {
                City cityFrom = topo.getCity(pp.From);
                City cityTo = topo.getCity(pp.To);
                if (cityFrom == null || cityTo == null) {
                    log.log(LogManager.DEFAULT, LogSeverityEnum.LSV_WARNING, "A task probability for pair (" + pp.From + "," + pp.To + ") was not added. One of cities " + "is invalid");
                    continue;
                }
                double dblTaskProb = this.mProbDensity.nextValue();
                double dblRewardProb = this.mRewardDensity.nextValue();
                if (pp.Task != null) {
                    dblTaskProb = pp.Task;
                }
                if (pp.Reward != null) {
                    dblRewardProb = pp.Reward;
                }
                pair = new Pair<City>(cityFrom, cityTo);
                mProbMap.put(pair, dblTaskProb);
                mRewardMap.put(pair, dblRewardProb);
            }
        }
        double dblProbability = 0.0;
        double dblReward = 0.0;
        for (City city1 : topo.getCities().values()) {
            for (City city2 : topo.getCities().values()) {
                pair = new Pair<City>(city1, city2);
                if (mProbMap.get(pair) != null || mRewardMap.get(pair) != null) continue;
                if (city1.match(city2)) {
                    dblProbability = 0.0;
                    dblReward = 0.0;
                } else {
                    dblProbability = this.mProbDensity.nextValue();
                    dblReward = this.mRewardDensity.nextValue();
                }
                mProbMap.put(pair, dblProbability);
                mRewardMap.put(pair, dblReward);
            }
        }
        if (this.mNormalize) {
            for (City city1 : topo.getCities().values()) {
                double dPositiveSum = 0.0;
                double dNoTaskProb = 1.0;
                for (City city2 : topo.getCities().values()) {
                    pair = new Pair<City>(city1, city2);
                    double dProb = mProbMap.get(pair);
                    dPositiveSum += dProb;
                    dNoTaskProb *= 1.0 - dProb;
                }
                if ((dPositiveSum += dNoTaskProb) < 1.0E-4) {
                    dPositiveSum = 1.0;
                }
                for (City city2 : topo.getCities().values()) {
                    pair = new Pair<City>(city1, city2);
                    double dProb = mProbMap.get(pair);
                    mProbMap.put(pair, dProb / dPositiveSum);
                }
            }
        }
        this.mProbDistribution = new ProbabilityDistribution(mProbMap, mRewardMap);
    }

    public boolean hasMoreTasks() {
        return true;
    }

    public Task next() {
        Topology topo = Topology.getInstance();
        int cityNum = this.mRandom.nextInt(0, this.mCityArray.length - 1);
        City cSourceCity = topo.getCity(this.mCityArray[cityNum]);
        double dProbability = this.mRandom.nextUniform(0.0, 0.1);
        double dStockedProb = 0.0;
        TaskDescriptor tdd = new TaskDescriptor();
        for (City cDestCity : topo.getCities().values()) {
            if (cDestCity.match(cSourceCity) || !(dProbability < (dStockedProb = this.mProbDistribution.getProbability(cSourceCity, cDestCity)))) continue;
            tdd.ID = this.mCount++;
            tdd.DeliveryCity = cDestCity.getNodeLabel();
            tdd.PickupCity = cSourceCity.getNodeLabel();
            tdd.RewardPerKm = this.mProbDistribution.getRewardPerKm(cSourceCity, cDestCity);
            tdd.Weight = this.mWeightDensity.nextValue();
            break;
        }
        if (tdd == null) {
            City cDestCity;
            cityNum = this.mRandom.nextInt(0, this.mCityArray.length - 1);
            cDestCity = topo.getCity(this.mCityArray[cityNum]);
            while (cDestCity.match(cSourceCity)) {
                cityNum = this.mRandom.nextInt(0, this.mCityArray.length - 1);
                cDestCity = topo.getCity(this.mCityArray[cityNum]);
            }
            tdd = new TaskDescriptor();
            tdd.ID = this.mCount++;
            tdd.DeliveryCity = cDestCity.getNodeLabel();
            tdd.PickupCity = cSourceCity.getNodeLabel();
            tdd.RewardPerKm = this.mProbDistribution.getRewardPerKm(cSourceCity, cDestCity);
            tdd.Weight = 0.0;
        }
        return new Task(tdd);
    }

    public void reset() {
    }

    public ProbabilityDistribution getProbabilityDistribution() {
        return this.mProbDistribution;
    }
}

