/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.logging;

import epfl.lia.logist.exception.AgentCreationException;
import epfl.lia.logist.logging.LogDescriptor;
import epfl.lia.logist.logging.LogEntry;
import epfl.lia.logist.logging.LogOutputFormat;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.logging.format.RawLogOutputFormat;
import epfl.lia.logist.logging.format.RtfLogOutputFormat;
import epfl.lia.logist.logging.format.StreamLogOutputFormat;
import epfl.lia.logist.logging.format.XmlLogOutputFormat;
import epfl.lia.logist.tools.LogistClassLoader;
import java.util.ArrayList;
import java.util.Date;

public class LogFile {
    private ArrayList<LogEntry> moCache = new ArrayList(this.miCacheSize);
    private LogOutputFormat moFormat = null;
    private LogSeverityEnum meDebugLevel = null;
    private int miMaxEntries = 0;
    private int miCacheSize = 1;
    private int miNumEntries = 0;
    private boolean mbStdoutput = false;
    private String mClassPath = "";

    public LogFile() {
    }

    public LogFile(String classpath) {
        this();
        this.mClassPath = classpath;
    }

    public boolean create(LogDescriptor d) throws Exception {
        this.miNumEntries = 0;
        this.moCache.clear();
        String lsFormat = d.Format.toLowerCase();
        if (lsFormat.equals("stream")) {
            this.moFormat = new StreamLogOutputFormat(d);
        } else if (lsFormat.equals("xml")) {
            d.File = String.valueOf(d.File) + ".xml";
            this.moFormat = new XmlLogOutputFormat(d);
        } else if (lsFormat.equals("rtf")) {
            d.File = String.valueOf(d.File) + ".rtf";
            this.moFormat = new RtfLogOutputFormat(d);
        } else if (lsFormat.equals("raw")) {
            d.File = String.valueOf(d.File) + ".txt";
            this.moFormat = new RawLogOutputFormat(d);
        } else if (lsFormat.equals("custom")) {
            Class[] args = new Class[]{LogDescriptor.class};
            Object[] objs = new Object[]{d};
            try {
                this.moFormat = (LogOutputFormat)LogistClassLoader.instantiateClass(d.FormatClass, this.mClassPath, args, objs);
            }
            catch (Exception e) {
                throw new AgentCreationException("Could not create a log format instance for log '" + d.ID + "' from class " + d.FormatClass + ". Please " + "verify that the global classpath variable is " + "correctly set !");
            }
        }
        this.moFormat.init();
        this.meDebugLevel = null;
        String lsDebugLevel = d.DebugLevel.toLowerCase();
        this.meDebugLevel = lsDebugLevel.equals("debug") ? LogSeverityEnum.LSV_DEBUG : (lsDebugLevel.equals("info") ? LogSeverityEnum.LSV_INFO : (lsDebugLevel.equals("warning") ? LogSeverityEnum.LSV_WARNING : (lsDebugLevel.equals("error") ? LogSeverityEnum.LSV_ERROR : (lsDebugLevel.equals("fatal") ? LogSeverityEnum.LSV_FATAL : LogSeverityEnum.LSV_DEBUG))));
        this.mbStdoutput = d.ToStdout;
        this.miMaxEntries = d.MaxEntries;
        this.miCacheSize = d.CacheSize;
        return true;
    }

    public void destroy() {
        if (this.moCache.size() > 0) {
            this.flush();
        }
        this.moCache.clear();
        this.moFormat.close();
    }

    public synchronized void flush() {
        if (this.moFormat == null) {
            return;
        }
        for (LogEntry le : this.moCache) {
            this.moFormat.outputEntry(le);
        }
        this.moCache.clear();
    }

    public synchronized void log(LogSeverityEnum ls, String msg) {
        if (ls.ordinal() < this.meDebugLevel.ordinal()) {
            return;
        }
        if (this.miMaxEntries > 0 && this.miNumEntries == this.miMaxEntries) {
            return;
        }
        if (this.mbStdoutput) {
            String outmsg = "[" + new Date() + "] " + msg;
            if (ls.compareTo(LogSeverityEnum.LSV_ERROR) >= 0) {
                System.err.println(outmsg);
            } else {
                System.out.println(outmsg);
            }
        }
        this.moCache.add(new LogEntry(new Date(), "", msg, ls, 0));
        ++this.miNumEntries;
        if (this.moCache.size() >= this.miCacheSize) {
            this.flush();
        }
    }
}

