/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.agent.plan;

import epfl.lia.logist.agent.plan.AgentActionTypeEnum;
import epfl.lia.logist.agent.plan.GMoveAction;
import epfl.lia.logist.agent.plan.IGenericAction;
import java.util.ArrayList;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plan
implements Enumeration<IGenericAction> {
    private ArrayList<IGenericAction> mActionList = new ArrayList();
    private double mDistanceDriven = 0.0;

    public Plan() {
    }

    public Plan(ArrayList<IGenericAction> actionList) {
        for (IGenericAction a : actionList) {
            this.addAction(a);
        }
    }

    public Plan(IGenericAction[] actionArray) {
        this();
        int i = 0;
        while (i < actionArray.length) {
            this.addAction(actionArray[i]);
            ++i;
        }
    }

    public Object clone() {
        Plan plan = new Plan();
        for (IGenericAction a : this.mActionList) {
            plan.addAction(a);
        }
        return plan;
    }

    public void clear() {
        this.mActionList.clear();
    }

    public void addAction(IGenericAction action) {
        this.mActionList.add(action);
        if (action.getType() == AgentActionTypeEnum.MOVE) {
            this.mDistanceDriven += ((GMoveAction)action).getDistance();
        }
    }

    @Override
    public boolean hasMoreElements() {
        return !this.mActionList.isEmpty();
    }

    @Override
    public IGenericAction nextElement() {
        if (this.mActionList.isEmpty()) {
            return null;
        }
        IGenericAction nextAction = this.mActionList.remove(0);
        return nextAction;
    }

    public double getDistanceDriven() {
        return this.mDistanceDriven;
    }

    public double getCost(double costPerKm) {
        return this.mDistanceDriven * costPerKm;
    }

    public String toString() {
        String result = "plan<actions:";
        for (IGenericAction a : this.mActionList) {
            result = String.valueOf(result) + a.toString() + ", ";
        }
        int iPos = result.lastIndexOf(",");
        if (iPos > -1) {
            result = result.substring(0, iPos);
        }
        return String.valueOf(result) + "; distance: " + this.mDistanceDriven + ">";
    }
}

