/*
 * Decompiled with CFR 0.152.
 */
package PastaLoverAgent;

import PastaLoverAgent.Node;
import PastaLoverAgent.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import logist.agent.Agent;
import logist.plan.Action;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.Task;
import logist.task.TaskDistribution;
import logist.task.TaskSet;
import logist.topology.Topology;

public class Astar {
    private Topology topology;
    private TaskDistribution td;
    private Agent agent;
    private int capacity;
    private int count = 0;
    private int numNodesVisited = 0;
    private int numNodesCreated = 1;
    private long timeout_plan;
    private long time_start;

    public Astar(Topology topology, TaskDistribution td, Agent agent) {
        this.topology = topology;
        this.td = td;
        this.agent = agent;
    }

    private Plan naivePlan(Vehicle vehicle, TaskSet tasks) {
        Topology.City current = vehicle.getCurrentCity();
        Plan plan = new Plan(current, new Action[0]);
        for (Task task : tasks) {
            for (Topology.City city : current.pathTo(task.pickupCity)) {
                plan.appendMove(city);
            }
            plan.appendPickup(task);
            for (Topology.City city : task.path()) {
                plan.appendMove(city);
            }
            plan.appendDelivery(task);
            current = task.deliveryCity;
        }
        return plan;
    }

    private Plan BFS(Vehicle vehicle, TaskSet tasks) {
        int capacity = vehicle.capacity();
        Topology.City current = vehicle.getCurrentCity();
        TaskSet delivered = TaskSet.noneOf((TaskSet)tasks);
        State s = new State(current, vehicle.getCurrentTasks(), delivered, tasks);
        Node first = new Node(s, null, 0.0);
        LinkedList Q = new LinkedList();
        HashSet C = new HashSet();
        Node n = this.BFS_search(first, Q, C, tasks, vehicle);
        Plan plan = new Plan(current, new Action[0]);
        return this.computeFinalPlan(plan, n);
    }

    private Node BFS_search(Node first, Queue Q, HashSet C, TaskSet tasks, Vehicle vehicle) {
        Q.add(first);
        while (!Q.isEmpty()) {
            ++this.numNodesVisited;
            Node current = (Node)Q.remove();
            if (this.isFinal(current.getState(), tasks, vehicle)) {
                return current;
            }
            if (C.contains(current.getState())) continue;
            C.add(current.getState());
            ArrayList S = this.getSuccessors(current, tasks, vehicle);
            Q.addAll(S);
        }
        return null;
    }

    public Plan runAStar(Vehicle vehicle, TaskSet tasks, long timeout_plan) {
        this.time_start = System.currentTimeMillis();
        this.timeout_plan = timeout_plan;
        int capacity = vehicle.capacity();
        Plan plan = new Plan(vehicle.getCurrentCity(), new Action[0]);
        State initialState = new State(vehicle.getCurrentCity(), vehicle.getCurrentTasks(), TaskSet.noneOf((TaskSet)tasks), tasks);
        Node root = new Node(initialState, null, 0.0);
        HashMap<State, Double> C = new HashMap<State, Double>();
        PriorityQueue<Node> Q = new PriorityQueue<Node>();
        Q.add(root);
        while (!Q.isEmpty()) {
            long duration = System.currentTimeMillis() - this.time_start;
            if ((double)duration > 0.95 * (double)timeout_plan) {
                this.print("!!!!!!!!!!!!! TIMEOUT, WE SHOULD RETURN FINAL RESULT !!!!!!!!!!!!");
                return null;
            }
            ++this.numNodesVisited;
            Node currentNode = (Node)Q.poll();
            State currentState = currentNode.getState();
            if (this.isFinal(currentState, tasks, vehicle)) {
                return this.computeFinalPlan(plan, currentNode);
            }
            if (C.containsKey(currentState) && !(currentNode.getCost() < (Double)C.get(currentState))) continue;
            C.put(currentState, currentNode.getCost());
            ArrayList S = this.getSuccessors(currentNode, tasks, vehicle);
            Q.addAll(S);
        }
        return null;
    }

    private ArrayList getSuccessors(Node currentNode, TaskSet tasks, Vehicle vehicle) {
        ArrayList<Node> successors = new ArrayList<Node>();
        State currentState = currentNode.getState();
        TaskSet deliveredOld = currentState.getDelivered();
        TaskSet carriedOld = currentState.getCarried();
        TaskSet availableTasks = TaskSet.noneOf((TaskSet)tasks);
        for (Task task : tasks) {
            if (task.pickupCity != currentState.getCity() || deliveredOld.contains((Object)task) || carriedOld.contains((Object)task)) continue;
            availableTasks.add((Object)task);
        }
        Set powerTaskSet = Astar.powerSet((Set)availableTasks);
        for (Set tasksSubset : powerTaskSet) {
            TaskSet pickedUp = TaskSet.noneOf((TaskSet)tasks);
            for (Task task : tasksSubset) {
                pickedUp.add((Object)task);
            }
            TaskSet deliveredNew = TaskSet.copyOf((TaskSet)deliveredOld);
            TaskSet carriedNew = TaskSet.union((TaskSet)carriedOld, (TaskSet)pickedUp);
            for (Task task : carriedOld) {
                if (!task.deliveryCity.equals((Object)currentState.getCity())) continue;
                deliveredNew.add((Object)task);
                carriedNew.remove((Object)task);
            }
            if (carriedNew.weightSum() > vehicle.capacity()) continue;
            for (Topology.City neighbor : currentState.getCity().neighbors()) {
                double cost = currentNode.getCost() + currentState.getCity().distanceTo(neighbor);
                State state = new State(neighbor, carriedNew, deliveredNew, tasks);
                Node node = new Node(state, currentNode, cost);
                ++this.numNodesCreated;
                successors.add(node);
            }
        }
        return successors;
    }

    public Plan computeFinalPlan(Plan plan, Node n) {
        Node n1;
        if (n == null) {
            this.print("no plan");
            return null;
        }
        Stack<Node> stack = new Stack<Node>();
        stack.push(n);
        while (n.getParent() != null) {
            n = n.getParent();
            stack.push(n);
        }
        Node n2 = n1 = (Node)stack.pop();
        while (!stack.isEmpty()) {
            n2 = (Node)stack.pop();
            this.addActions(plan, n1, n2);
            n1 = n2;
        }
        TaskSet lastDelivery = n1.getState().getCarried();
        for (Task task : lastDelivery) {
            plan.appendDelivery(task);
        }
        return plan;
    }

    public void addActions(Plan plan, Node n1, Node n2) {
        TaskSet delivery = TaskSet.intersectComplement((TaskSet)n2.getState().getDelivered(), (TaskSet)n1.getState().getDelivered());
        for (Task task : delivery) {
            plan.appendDelivery(task);
        }
        TaskSet pickup = TaskSet.intersectComplement((TaskSet)n2.getState().getCarried(), (TaskSet)n1.getState().getCarried());
        for (Task task : pickup) {
            plan.appendPickup(task);
        }
        plan.appendMove(n2.getState().getCity());
    }

    public boolean isFinal(State s, TaskSet tasks, Vehicle v) {
        for (Task task : s.getCarried()) {
            if (task.deliveryCity.equals((Object)s.getCity())) continue;
            return false;
        }
        return TaskSet.union((TaskSet)s.getDelivered(), (TaskSet)s.getCarried()).containsAll((Collection)TaskSet.union((TaskSet)v.getCurrentTasks(), (TaskSet)tasks));
    }

    public static Set powerSet(Set originalSet) {
        HashSet<Set> sets = new HashSet<Set>();
        if (originalSet.isEmpty()) {
            sets.add(new HashSet());
            return sets;
        }
        ArrayList list = new ArrayList(originalSet);
        Task head = (Task)list.get(0);
        HashSet rest = new HashSet(list.subList(1, list.size()));
        for (Set set : Astar.powerSet(rest)) {
            HashSet<Task> newSet = new HashSet<Task>();
            newSet.add(head);
            newSet.addAll(set);
            sets.add(newSet);
            sets.add(set);
        }
        return sets;
    }

    public void print(Node n) {
        State s = n.getState();
        ++this.count;
    }

    public void print(String s) {
    }

    public void print(int i) {
    }

    public void print(TaskSet tasks) {
    }
}

