/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.compat;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import ptolemy.plot.CmdLineArgException;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;

public class PxgraphParser {
    protected Plot _plot;
    private static final int _NATIVE_ENDIAN = 0;
    private static final int _BIG_ENDIAN = 1;
    private static final int _LITTLE_ENDIAN = 2;
    private boolean binary = false;
    private int _endian = 0;
    private static int _debug = 0;

    public PxgraphParser(Plot plot) {
        this._plot = plot;
    }

    private double[] _parseDoubles(String string) {
        int n = string.indexOf(",");
        if (n < 0) {
            double[] dArray = new double[]{Double.valueOf(string)};
            return dArray;
        }
        double[] dArray = new double[2];
        String string2 = string.substring(0, n);
        dArray[0] = Double.valueOf(string2);
        String string3 = string.substring(n + 1);
        dArray[1] = Double.valueOf(string3);
        return dArray;
    }

    public int parseArgs(String[] stringArray) throws CmdLineArgException, FileNotFoundException, IOException {
        return this.parseArgs(stringArray, null);
    }

    public int parseArgs(String[] stringArray, URL uRL) throws CmdLineArgException, FileNotFoundException, IOException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string = "none";
        this.binary = false;
        int n3 = 400;
        int n4 = 400;
        String[] stringArray2 = new String[]{"-bd", "-brb", "-bw", "-gw", "-lw", "-zg", "-zw"};
        while (stringArray != null && n < stringArray.length && (stringArray[n].startsWith("-") || stringArray[n].startsWith("="))) {
            int n5;
            int n6;
            String string2;
            if ((string2 = stringArray[n++]).startsWith("-")) {
                n6 = 0;
                int n7 = 0;
                while (n7 < stringArray2.length) {
                    if (string2.equals(stringArray2[n7])) {
                        System.err.println("Warning: pxgraph: " + string2 + " is not supported");
                        ++n;
                        n6 = 1;
                    }
                    ++n7;
                }
                if (n6 != 0 || string2.equals("-bb")) continue;
                if (string2.equals("-bg")) {
                    this._plot.setBackground(PlotBox.getColorByName(stringArray[n++]));
                    continue;
                }
                if (string2.equals("-brw")) {
                    double[] dArray;
                    if ((dArray = this._parseDoubles(stringArray[n++])).length == 1) {
                        this._plot.setBars(dArray[0], 0.0);
                        continue;
                    }
                    this._plot.setBars(dArray[0], dArray[1]);
                    continue;
                }
                if (string2.equals("-lf")) {
                    this._plot.setLabelFont(stringArray[n++]);
                    continue;
                }
                if (string2.equals("-lx")) {
                    double[] dArray;
                    if ((dArray = this._parseDoubles(stringArray[n++])).length == 1) {
                        throw new CmdLineArgException("Failed to parse `" + string2 + "'");
                    }
                    this._plot.setXRange(dArray[0], dArray[1]);
                    continue;
                }
                if (string2.equals("-ly")) {
                    double[] dArray;
                    if ((dArray = this._parseDoubles(stringArray[n++])).length == 1) {
                        throw new CmdLineArgException("Failed to parse `" + string2 + "'");
                    }
                    this._plot.setYRange(dArray[0], dArray[1]);
                    continue;
                }
                if (string2.equals("-t")) {
                    String string3 = stringArray[n++];
                    this._plot.setTitle(string3);
                    continue;
                }
                if (string2.equals("-tf")) {
                    this._plot.setTitleFont(stringArray[n++]);
                    continue;
                }
                if (string2.equals("-x")) {
                    this._plot.setXLabel(stringArray[n++]);
                    continue;
                }
                if (string2.equals("-y")) {
                    this._plot.setYLabel(stringArray[n++]);
                    continue;
                }
                if (string2.equals("-bar")) {
                    bl = true;
                    if (bl2) {
                        this._plot.setImpulses(true);
                    } else {
                        this._plot.setBars(true);
                        this._plot.setMarksStyle("none");
                    }
                    this._plot.setConnected(false);
                    continue;
                }
                if (string2.equals("-binary")) {
                    this.binary = true;
                    this._endian = 0;
                    continue;
                }
                if (string2.equals("-bigendian")) {
                    this.binary = true;
                    this._endian = 1;
                    continue;
                }
                if (string2.equals("-littleendian")) {
                    this.binary = true;
                    this._endian = 2;
                    continue;
                }
                if (string2.equals("-db")) {
                    _debug = 10;
                    continue;
                }
                if (string2.equals("-debug")) {
                    _debug = Integer.valueOf(stringArray[n++]);
                    continue;
                }
                if (string2.equals("-fg")) {
                    this._plot.setForeground(PlotBox.getColorByName(stringArray[n++]));
                    continue;
                }
                if (string2.equals("-help")) continue;
                if (string2.equals("-impulses")) {
                    this._plot.setImpulses(true);
                    this._plot.setConnected(false);
                    continue;
                }
                if (string2.equals("-lnx")) {
                    this._plot.setXLog(true);
                    continue;
                }
                if (string2.equals("-lny")) {
                    this._plot.setYLog(true);
                    continue;
                }
                if (string2.equals("-m")) {
                    this._plot.setMarksStyle("various");
                    string = "various";
                    continue;
                }
                if (string2.equals("-M")) {
                    this._plot.setMarksStyle("various");
                    string = "various";
                    continue;
                }
                if (string2.equals("-nl")) {
                    bl2 = true;
                    if (bl) {
                        this._plot.setMarksStyle(string);
                        this._plot.setBars(false);
                        this._plot.setImpulses(true);
                    }
                    this._plot.setConnected(false);
                    continue;
                }
                if (string2.equals("-o")) {
                    ++n;
                    continue;
                }
                if (string2.equals("-p")) {
                    this._plot.setMarksStyle("points");
                    string = "points";
                    continue;
                }
                if (string2.equals("-P")) {
                    this._plot.setMarksStyle("dots");
                    string = "dots";
                    continue;
                }
                if (string2.equals("-print")) continue;
                if (string2.equals("-rv")) {
                    this._plot.setBackground(PlotBox.getColorByName("black"));
                    this._plot.setForeground(PlotBox.getColorByName("white"));
                    continue;
                }
                if (string2.equals("-test")) continue;
                if (string2.equals("-tk")) {
                    this._plot.setGrid(false);
                    continue;
                }
                if (string2.equals("-v") || string2.equals("-version")) continue;
                if (string2.length() > 1 && string2.charAt(0) == '-') {
                    try {
                        Integer n8 = new Integer(string2.substring(1));
                        n5 = n8;
                        if (n5 >= 0) {
                            this._plot.addLegend(n5, stringArray[n++]);
                            continue;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
            } else if (string2.startsWith("=")) {
                n3 = Integer.valueOf(string2.substring(1, string2.indexOf(120)));
                n6 = string2.indexOf(43);
                int n9 = string2.indexOf(45);
                if (n6 != -1 || n9 != -1) {
                    if (n6 != -1 && n9 != -1) {
                        n5 = n9;
                        if (n6 < n9) {
                            n5 = n6;
                        }
                        n4 = Integer.valueOf(string2.substring(string2.indexOf(120) + 1, n5));
                        continue;
                    }
                    if (n6 != -1) {
                        n4 = Integer.valueOf(string2.substring(string2.indexOf(120) + 1, n6));
                        continue;
                    }
                    n4 = Integer.valueOf(string2.substring(string2.indexOf(120) + 1, n9));
                    continue;
                }
                if (string2.length() <= string2.indexOf(120)) continue;
                n4 = Integer.valueOf(string2.substring(string2.indexOf(120) + 1, string2.length()));
                continue;
            }
            throw new CmdLineArgException("Failed to parse `" + string2 + "'");
        }
        n2 = n++;
        this._plot.setSize(n3, n4);
        n = n2;
        while (n < stringArray.length) {
            InputStream inputStream;
            try {
                URL uRL2 = new URL(uRL, stringArray[n]);
                inputStream = uRL2.openStream();
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = new FileInputStream(stringArray[n]);
            }
            this.read(inputStream);
            ++n;
        }
        return n2;
    }

    /*
     * Exception decompiling
     */
    public int parsePxgraphargs(String var1_1, URL var2_2) throws CmdLineArgException, FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        if (this.binary) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            boolean bl = false;
            boolean bl2 = false;
            byte[] byArray = new byte[4];
            int n = 0;
            switch (this._endian) {
                case 0: {
                    try {
                        if (!System.getProperty("os.arch").equals("x86")) break;
                        bl = true;
                    }
                    catch (SecurityException securityException) {}
                    break;
                }
                case 2: {
                    bl = true;
                    break;
                }
                default: {
                    throw new IOException("Internal Error: Don't know about '" + this._endian + "' style of endian");
                }
                case 1: 
            }
            try {
                int n2 = dataInputStream.readByte();
                if (n2 != 100) {
                    int n3 = n2;
                    n3 <<= 8;
                    n3 += dataInputStream.readByte();
                    n3 <<= 8;
                    n3 += dataInputStream.readByte();
                    n3 <<= 8;
                    f = Float.intBitsToFloat(n3 += dataInputStream.readByte());
                    f2 = dataInputStream.readFloat();
                    this._plot.addPoint(n, f, f2, bl2);
                    bl2 = true;
                    while (true) {
                        f = dataInputStream.readFloat();
                        f2 = dataInputStream.readFloat();
                        this._plot.addPoint(n, f, f2, bl2);
                        bl2 = true;
                    }
                }
                while (true) {
                    switch (n2) {
                        case 100: {
                            if (bl) {
                                dataInputStream.readFully(byArray);
                                f = Float.intBitsToFloat((byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF);
                                dataInputStream.readFully(byArray);
                                f2 = Float.intBitsToFloat((byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF);
                            } else {
                                f = dataInputStream.readFloat();
                                f2 = dataInputStream.readFloat();
                            }
                            f3 += 1.0f;
                            this._plot.addPoint(n, f, f2, bl2);
                            bl2 = true;
                            break;
                        }
                        case 101: {
                            bl2 = false;
                            break;
                        }
                        case 110: {
                            StringBuffer stringBuffer = new StringBuffer();
                            ++n;
                            while (n2 != 10) {
                                stringBuffer.append(dataInputStream.readChar());
                            }
                            this._plot.addLegend(n, stringBuffer.toString());
                            this._plot.setConnected(true);
                            break;
                        }
                        case 109: {
                            bl2 = false;
                            break;
                        }
                        default: {
                            throw new IOException("Don't understand `" + (char)n2 + "' character " + "(decimal value = " + n2 + ") in binary file.  Last point was (" + f + "," + f2 + ").\nProcessed " + f3 + " points successfully");
                        }
                    }
                    n2 = dataInputStream.readByte();
                }
            }
            catch (EOFException eOFException) {}
        } else {
            this._plot.read(inputStream);
        }
    }
}

