/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.awt.Color;
import logist.Measures;
import logist.simulation.Vehicle;
import logist.task.TaskSet;
import logist.topology.Topology;

public class OurVehicle
implements Vehicle {
    private final String name;
    private final int id;
    private final int capacity;
    private final int costPerKm;
    private final Topology.City homeCity;
    private long totalReward;
    private long totalDistance;
    private TaskSet currentTasks;
    private Topology.City nextCity;
    private long speed;
    private Color color;

    public OurVehicle(Vehicle vehicle) {
        this.name = vehicle.name();
        this.id = vehicle.id();
        this.capacity = vehicle.capacity();
        this.costPerKm = vehicle.costPerKm();
        this.homeCity = vehicle.homeCity();
        this.totalReward = vehicle.getReward();
        this.totalDistance = vehicle.getDistanceUnits();
        this.currentTasks = vehicle.getCurrentTasks();
        this.nextCity = vehicle.getCurrentCity();
        this.speed = (long)vehicle.speed();
        this.color = vehicle.color();
    }

    public int capacity() {
        return this.capacity;
    }

    public int id() {
        return this.id;
    }

    public TaskSet getCurrentTasks() {
        return this.currentTasks.clone();
    }

    public Topology.City getCurrentCity() {
        return this.nextCity;
    }

    public Topology.City homeCity() {
        return this.homeCity;
    }

    public String name() {
        return this.name;
    }

    public double speed() {
        return Measures.unitsToKM((long)this.speed);
    }

    public long getReward() {
        return this.totalReward;
    }

    public long getDistanceUnits() {
        return this.totalDistance;
    }

    public double getDistance() {
        return Measures.unitsToKM((long)this.totalDistance);
    }

    public int costPerKm() {
        return this.costPerKm;
    }

    public Color color() {
        return this.color;
    }
}

