/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import logist.LogistSettings;
import logist.agent.Agent;
import logist.behavior.AuctionBehavior;
import logist.config.Parsers;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.DefaultTaskDistribution;
import logist.task.Task;
import logist.task.TaskDistribution;
import logist.task.TaskSet;
import logist.topology.Topology;
import template.AgentState;
import template.BidHelper;

public class AuctionTemplate
implements AuctionBehavior {
    private Topology topology;
    private DefaultTaskDistribution taskDistribution;
    private Agent agent;
    private List<Vehicle> vehicles;
    private long timeout_setup;
    private AgentState ourAgent;
    private AgentState theirAgent;
    private Map<Topology.City, Long> pickUpCities;
    private double p;
    private double futureDiscount = 0.1;
    private double cityApproximation = 0.1;
    private int highestCapacity;
    private int correctGuesses = 0;
    private int wrongGuesses = 0;
    private long cumulativeLoss = 0L;
    private long cumulativeGain = 0L;
    private double aggro = 1.0;
    private boolean debug = false;

    public void setup(Topology topology, TaskDistribution distribution, Agent agent) {
        this.topology = topology;
        this.taskDistribution = (DefaultTaskDistribution)distribution;
        this.agent = agent;
        this.vehicles = agent.vehicles();
        this.pickUpCities = new HashMap<Topology.City, Long>();
        for (Vehicle vehicle : this.vehicles) {
            this.highestCapacity = Math.max(vehicle.capacity(), this.highestCapacity);
        }
        for (Topology.City city : topology.cities()) {
            this.pickUpCities.put(city, 0L);
        }
        LogistSettings ls = null;
        try {
            ls = Parsers.parseSettings((String)("config" + File.separator + "settings_auction.xml"));
        }
        catch (Exception exc) {
            System.out.println("There was a problem loading the configuration file.");
        }
        this.timeout_setup = ls.get(LogistSettings.TimeoutKey.SETUP);
        long timeout_plan = ls.get(LogistSettings.TimeoutKey.PLAN) - 200L;
        if (this.debug) {
            System.out.println("Adding our agent");
        }
        this.ourAgent = new AgentState(this.vehicles, timeout_plan, false, topology.cities(), new HashSet<Topology.City>());
        HashSet<Topology.City> occupiedCities = new HashSet<Topology.City>();
        for (Vehicle vehicle : this.vehicles) {
            occupiedCities.add(vehicle.homeCity());
        }
        if (this.debug) {
            System.out.println("Adding their agent");
        }
        this.theirAgent = new AgentState(this.vehicles, timeout_plan, true, topology.cities(), occupiedCities);
        if (this.debug) {
            System.out.println("Printing agents");
        }
        if (this.debug) {
            System.out.println("Our agent: " + this.ourAgent.toString());
        }
        if (this.debug) {
            System.out.println("Their agent: " + this.theirAgent.toString());
        }
    }

    public void auctionResult(Task previous, int winner, Long[] bids) {
        boolean rightCorrection;
        long opponentBid = 0L;
        long ourBid = 0L;
        for (int i = 0; i < bids.length; ++i) {
            if (i == this.agent.id()) continue;
            opponentBid = bids[i];
        }
        long bidDifference = opponentBid - this.theirAgent.getLowestBid();
        boolean overEstimate = bidDifference < 0L;
        long correction = this.pickUpCities.get(previous.pickupCity);
        boolean pickUpPredict = this.pickUpCities.get(previous.pickupCity) != 0L;
        boolean bl = rightCorrection = correction < 0L;
        if (pickUpPredict) {
            if (overEstimate == rightCorrection) {
                ++this.correctGuesses;
                this.cumulativeGain += Math.abs(correction);
                if (this.debug) {
                    System.out.println("Correctly predicted: " + bidDifference);
                }
                if (this.debug) {
                    System.out.println("Correct guesses: " + this.correctGuesses);
                }
                if (this.debug) {
                    System.out.println("Cumulative gain: " + this.cumulativeGain);
                }
            } else {
                ++this.wrongGuesses;
                this.cumulativeLoss += Math.abs(correction);
                if (this.debug) {
                    System.out.println("Wrongly predicted: " + bidDifference);
                }
                if (this.debug) {
                    System.out.println("Wrong guesses: " + this.wrongGuesses);
                }
                if (this.debug) {
                    System.out.println("Cumulative loss: " + this.cumulativeLoss);
                }
            }
        } else if (this.debug) {
            System.out.println("No data on opponent!");
        }
        opponentBid = Math.min(opponentBid, 5000L);
        this.pickUpCities.put(previous.pickupCity, bidDifference);
        if (winner == this.agent.id()) {
            this.ourAgent.updateCandidate(previous, bids[this.agent.id()]);
            if (this.debug) {
                System.out.println("Won the auction, Opponent bid " + opponentBid);
            }
            if (this.debug) {
                System.out.println("Current cost: " + this.ourAgent.getCost());
            }
        } else {
            this.theirAgent.updateCandidate(previous, bids[this.agent.id()]);
            if (this.debug) {
                System.out.println("Lost the auction, Opponent bid " + opponentBid);
            }
        }
        if (this.debug) {
            System.out.println("Our profit: " + this.ourAgent.getProfit());
        }
        if (this.debug) {
            System.out.println("Their profit: " + this.theirAgent.getProfit());
        }
    }

    public Long askPrice(Task task) {
        double bid;
        double theirLowestBidTemp;
        if (task.weight > this.highestCapacity) {
            return Long.MAX_VALUE;
        }
        double ourMarginalCost = this.ourAgent.calculateMarginalCost(task, 0.25);
        double theirMarginalCost = this.theirAgent.calculateMarginalCost(task, 0.25);
        int totalTasksAuctioned = this.ourAgent.getWonTasks() + this.theirAgent.getWonTasks();
        double ourFutureSavings = BidHelper.computeFutureSavings(task, this.ourAgent, this.taskDistribution, 0.25);
        double theirFutureSavings = BidHelper.computeFutureSavings(task, this.theirAgent, this.taskDistribution, 0.25);
        double ourLowestBid = ourMarginalCost + this.futureDiscount * ourFutureSavings;
        double theirLowestBid = theirMarginalCost + this.futureDiscount * theirFutureSavings;
        double learnedDiscount = this.pickUpCities.get(task.pickupCity).longValue();
        theirLowestBid = theirLowestBidTemp = theirLowestBid + this.cityApproximation * learnedDiscount;
        if (this.debug) {
            System.out.println("\nBidding round " + (totalTasksAuctioned + 1) + ":");
        }
        if (this.debug) {
            System.out.println("Our lowest bid: " + ourLowestBid);
        }
        if (this.debug) {
            System.out.println("Their lowest bid: " + theirLowestBid);
        }
        if (this.debug) {
            System.out.println("Their lowest bid with learning: " + theirLowestBidTemp);
        }
        this.theirAgent.setLowestBid(Math.round(theirLowestBid));
        if (ourLowestBid < theirLowestBid) {
            long eps = Math.round((theirLowestBid - ourLowestBid) / 5.0 * 4.0);
            bid = Math.max(0L, Math.round(ourLowestBid) + eps);
        } else {
            bid = ourLowestBid > theirLowestBid ? (this.ourAgent.getWonTasks() < 3 ? theirLowestBid : ourLowestBid) : ourLowestBid;
        }
        if (this.debug) {
            System.out.println("Our bid: " + bid);
        }
        return (long)Math.max(0.0, Math.max(ourMarginalCost * 0.85, (double)Math.round(bid)));
    }

    public List<Plan> plan(List<Vehicle> vehicles, TaskSet tasks) {
        return this.ourAgent.getPlan();
    }
}

