/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.testing.security;

import epfl.lia.logist.security.SecurityManager;
import epfl.lia.logist.security.SecurityPolicy;
import epfl.lia.logist.security.SecurityRuleOpEnum;
import epfl.lia.logist.security.SecurityRuleRightsEnum;

public class TestSecurity1 {
    public TestSecurity1() {
        new SecurityManager();
    }

    public static void main(String[] args) {
        new TestSecurity1().run();
    }

    public void consumeResource1() {
        try {
            SecurityManager.getInstance().checkAccess();
        }
        catch (Exception e) {
            System.out.println("Access to resource 1 is denied to thread...");
            return;
        }
        System.out.println("Access to resource 1 was granted !!!");
    }

    public void consumeResource2() {
        try {
            SecurityManager.getInstance().checkAccess();
        }
        catch (Exception e) {
            System.out.println("Access to resource 2 is denied to thread...");
            return;
        }
        System.out.println("Access to resource 2 was granted !!!");
    }

    public void run() {
        ThreadGroup l_ThreadGroup = new ThreadGroup("agents");
        SecurityPolicy loPolicy = new SecurityPolicy();
        loPolicy.append(SecurityRuleOpEnum.SROP_EQ, Thread.currentThread().getThreadGroup().getName(), SecurityRuleRightsEnum.SRRG_GRANT);
        loPolicy.append(SecurityRuleOpEnum.SROP_ANY, "", SecurityRuleRightsEnum.SRRG_DENY);
        SecurityManager.getInstance().definePolicy(loPolicy);
        System.out.print("Thread <" + Thread.currentThread().getName() + "> - ");
        this.consumeResource1();
        System.out.print("Thread <" + Thread.currentThread().getName() + "> - ");
        this.consumeResource2();
        new SampleWorkerThread(l_ThreadGroup, "worker1", this).start();
        new SampleWorkerThread(l_ThreadGroup, "worker2", this).start();
    }

    private class SampleWorkerThread
    extends Thread {
        private TestSecurity1 moParent;

        public SampleWorkerThread(ThreadGroup group, String name, TestSecurity1 obj) {
            super(group, name);
            this.moParent = obj;
            System.out.println("Thread <" + this.getName() + "> was created...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SampleWorkerThread sampleWorkerThread = this;
            synchronized (sampleWorkerThread) {
                System.out.print("Thread <" + this.getName() + "> - ");
                this.moParent.consumeResource1();
                System.out.print("Thread <" + this.getName() + "> - ");
                this.moParent.consumeResource2();
            }
        }
    }
}

