/*
 * Decompiled with CFR 0.152.
 */
package TrialAgent;

import TrialAgent.Action;
import TrialAgent.CentralizedPlan;
import TrialAgent.MyVehicle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import logist.task.Task;
import logist.task.TaskSet;

public class PDPlan {
    private MyVehicle biggestMyVehicle;
    private List<MyVehicle> vehicles;
    private CentralizedPlan bestPlan;
    private CentralizedPlan searchPlan;
    private CentralizedPlan newPlan;
    private static double prop = 0.35;
    private double minCost = 2.147483647E9;

    public PDPlan(List<MyVehicle> MyVehicles) {
        int capacity = Integer.MIN_VALUE;
        this.vehicles = MyVehicles;
        this.searchPlan = new CentralizedPlan();
        for (MyVehicle MyVehicle2 : MyVehicles) {
            LinkedList actionList = new LinkedList();
            this.searchPlan.getVehicleActions().put(MyVehicle2, actionList);
            if (capacity >= MyVehicle2.getCapacity()) continue;
            capacity = MyVehicle2.getCapacity();
            this.biggestMyVehicle = MyVehicle2;
        }
    }

    public MyVehicle getBiggestVehicle() {
        return this.biggestMyVehicle;
    }

    public CentralizedPlan solveWithNewTask(Task task) {
        try {
            this.newPlan = (CentralizedPlan)this.searchPlan.clone();
            List<CentralizedPlan> planSet = this.newPlan.insertTask(task);
            this.newPlan = this.localChoice(this.searchPlan, planSet);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return this.newPlan;
    }

    public void solveWithTaskSet(TaskSet tasks) {
        for (Task task : tasks) {
            List<CentralizedPlan> planSet = this.searchPlan.insertTask(task);
            this.searchPlan = this.localChoice(this.searchPlan, planSet);
        }
    }

    public void updatePlan() {
        this.searchPlan = this.newPlan;
    }

    public CentralizedPlan getBestPlan() {
        return this.bestPlan;
    }

    public CentralizedPlan getSearchPlan() {
        return this.searchPlan;
    }

    private CentralizedPlan localChoice(CentralizedPlan oldPlan, List<CentralizedPlan> planSet) {
        CentralizedPlan minCostPlan = oldPlan;
        double minCost = 2.147483647E9;
        for (CentralizedPlan plan : planSet) {
            double tmpCost = plan.cost();
            if (!(tmpCost < minCost)) continue;
            minCostPlan = plan;
            minCost = tmpCost;
        }
        this.bestPlan = minCostPlan;
        return minCostPlan;
    }

    public CentralizedPlan SLSAlgorithm(int iterationNum, long allowedTime, long startTime) {
        CentralizedPlan plan;
        allowedTime = allowedTime * 3L / 4L;
        this.bestPlan = plan = this.searchPlan;
        for (int i = 0; i < iterationNum; ++i) {
            if (System.currentTimeMillis() - startTime > allowedTime) {
                return this.bestPlan;
            }
            CentralizedPlan oldPlan = plan;
            ArrayList<CentralizedPlan> planSet = this.ChooseNeighbours(oldPlan);
            plan = this.localChoiceSLS(oldPlan, planSet);
        }
        return plan;
    }

    public ArrayList<CentralizedPlan> ChooseNeighbours(CentralizedPlan oldPlan) {
        ArrayList<CentralizedPlan> planSet = new ArrayList<CentralizedPlan>();
        Random random = new Random();
        int selectVehicleNum = random.nextInt(this.vehicles.size());
        MyVehicle selectVehicle = this.vehicles.get(selectVehicleNum);
        for (MyVehicle exchangeVehicle : this.vehicles) {
            for (MyVehicle currentVehicle : this.vehicles) {
                LinkedList<Action> vehicleActions = oldPlan.getVehicleActions().get(exchangeVehicle);
                if (currentVehicle == exchangeVehicle || vehicleActions.size() <= 0) continue;
                for (int i = 0; i < oldPlan.getVehicleActions().get(exchangeVehicle).size(); ++i) {
                    Action exchangeAction = oldPlan.getVehicleActions().get(exchangeVehicle).get(0);
                    if (exchangeAction.currentTask.weight > currentVehicle.getCapacity()) continue;
                    List<CentralizedPlan> planList = this.changingVehicle(oldPlan, exchangeVehicle, currentVehicle);
                    for (CentralizedPlan plan : planList) {
                        if (plan.violateConstraint()) continue;
                        planSet.add(plan);
                    }
                }
            }
        }
        LinkedList<Action> vehicleAction = oldPlan.getVehicleActions().get(selectVehicle);
        int length = vehicleAction.size();
        if (length > 2) {
            for (int tIdx = 0; tIdx < length; ++tIdx) {
                if (vehicleAction.get((int)tIdx).type != Action.Type.PICKUP) continue;
                List<CentralizedPlan> planList = this.changingTaskOrder(oldPlan, selectVehicle, tIdx);
                for (CentralizedPlan plan : planList) {
                    if (plan.violateConstraint()) continue;
                    planSet.add(plan);
                }
            }
        }
        return planSet;
    }

    public List<CentralizedPlan> changingVehicle(CentralizedPlan oldPlan, MyVehicle v1, MyVehicle v2) {
        CentralizedPlan newPlan = null;
        try {
            newPlan = (CentralizedPlan)oldPlan.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        Task startTask = newPlan.getVehicleActions().get((Object)v1).get((int)0).currentTask;
        newPlan.removeTask(startTask);
        Action pickupAction = new Action(Action.Type.PICKUP, startTask);
        Action deliverAction = new Action(Action.Type.DELIVERY, startTask);
        LinkedList<Action> stateListV2 = newPlan.getVehicleActions().get(v2);
        stateListV2.addFirst(pickupAction);
        ArrayList<CentralizedPlan> planSet = new ArrayList<CentralizedPlan>();
        for (int i = 1; i <= stateListV2.size(); ++i) {
            LinkedList stateListCopy = (LinkedList)stateListV2.clone();
            stateListCopy.add(i, deliverAction);
            try {
                CentralizedPlan copyPlan = (CentralizedPlan)newPlan.clone();
                copyPlan.getVehicleActions().put(v2, stateListCopy);
                planSet.add(copyPlan);
                continue;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return planSet;
    }

    private List<CentralizedPlan> changingTaskOrder(CentralizedPlan oldPlan, MyVehicle v1, int tIdx) {
        ArrayList<CentralizedPlan> planSet = new ArrayList<CentralizedPlan>();
        CentralizedPlan newPlan = null;
        try {
            newPlan = (CentralizedPlan)oldPlan.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        LinkedList<Action> actionList = newPlan.getVehicleActions().get(v1);
        Task task = actionList.get((int)tIdx).currentTask;
        newPlan.removeTask(task);
        Action pickupAction = new Action(Action.Type.PICKUP, task);
        Action deliveryAction = new Action(Action.Type.DELIVERY, task);
        for (int insert1 = 0; insert1 <= actionList.size(); ++insert1) {
            for (int insert2 = insert1 + 1; insert2 <= actionList.size() + 1; ++insert2) {
                try {
                    CentralizedPlan copyPlan = (CentralizedPlan)newPlan.clone();
                    LinkedList copyList = (LinkedList)actionList.clone();
                    copyList.add(insert1, pickupAction);
                    copyList.add(insert2, deliveryAction);
                    copyPlan.getVehicleActions().put(v1, copyList);
                    planSet.add(copyPlan);
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
        }
        return planSet;
    }

    private CentralizedPlan localChoiceSLS(CentralizedPlan oldPlan, ArrayList<CentralizedPlan> planSet) {
        Random random;
        int num;
        CentralizedPlan returnPlan = oldPlan;
        CentralizedPlan minCostPlan = null;
        double minCost = 2.147483647E9;
        for (CentralizedPlan plan : planSet) {
            double tmpCost = plan.cost();
            if (!(tmpCost < minCost)) continue;
            minCostPlan = plan;
            minCost = tmpCost;
        }
        if (minCost < this.minCost) {
            this.bestPlan = minCostPlan;
            this.minCost = minCost;
        }
        returnPlan = (double)(num = (random = new Random()).nextInt(100)) < prop * 100.0 ? minCostPlan : ((double)num < 2.0 * prop * 100.0 ? oldPlan : planSet.get(random.nextInt(planSet.size())));
        return returnPlan;
    }
}

