/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import logist.LogistSettings;
import logist.agent.Agent;
import logist.behavior.AuctionBehavior;
import logist.config.Parsers;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.Task;
import logist.task.TaskDistribution;
import logist.task.TaskSet;
import logist.topology.Topology;
import template.Candidate;
import template.CentralizedPlan;
import template.Pair;

public class AuctionTemplate
implements AuctionBehavior {
    private Topology topology;
    private TaskDistribution distribution;
    private Agent agent;
    private Random random;
    private List<Vehicle> vehicles;
    private long timeout_setup;
    private long timeout_plan;
    private long timeout_bid;
    private Candidate previousCandidate;
    private int previousIterationNumber;
    private Candidate auctionCandidate;
    private ArrayList<Task> wonTasks = new ArrayList();
    private double rounds = 1.0;
    private double p_planning;
    private double p_bidding;
    private HashMap<Topology.City, Double> deliveryScoresHashmap;
    private double maxDeliveryScore;
    private double medianDeliveryScore;
    private HashMap<Pair<Topology.City, Topology.City>, Double> pathScoresHashmap;
    private double maxPathScore;
    private double medianPathScore;
    private double nb_bidders;

    private double getNeighborDeliveryScore(Topology.City city, Topology topology, TaskDistribution distribution) {
        double scoreNeighbor = 0.0;
        for (Topology.City neighbor : city.neighbors()) {
            for (Topology.City deliveryCity : topology.cities()) {
                scoreNeighbor += distribution.probability(neighbor, deliveryCity);
            }
        }
        return scoreNeighbor;
    }

    private void setupScoreDelivery(Topology topology, TaskDistribution distribution) {
        this.deliveryScoresHashmap = new HashMap();
        this.maxDeliveryScore = 0.0;
        for (Topology.City city : topology.cities()) {
            double deliveryScore = 0.0;
            for (Topology.City neighbor : city.neighbors()) {
                deliveryScore += this.getNeighborDeliveryScore(city, topology, distribution);
            }
            if (deliveryScore > this.maxDeliveryScore) {
                this.maxDeliveryScore = deliveryScore;
            }
            this.deliveryScoresHashmap.put(city, deliveryScore);
        }
        this.medianDeliveryScore = this.computeMedian(new ArrayList<Double>(this.deliveryScoresHashmap.values()));
    }

    private double getDeliveryScoreNormalized(Topology.City city) {
        return this.deliveryScoresHashmap.get(city) / this.maxDeliveryScore;
    }

    private double getPathScore(Topology.City city1, Topology.City city2) {
        Pair<Topology.City, Topology.City> key = new Pair<Topology.City, Topology.City>(city1, city2);
        if (this.pathScoresHashmap.containsKey(key)) {
            return this.pathScoresHashmap.get(key);
        }
        double scorePath = 0.0;
        List pathCity = city1.pathTo(city2);
        pathCity.add(0, city1);
        pathCity.add(city2);
        for (int i = 0; i < pathCity.size(); ++i) {
            Topology.City startCity = (Topology.City)pathCity.get(i);
            for (int j = i + 1; j < pathCity.size(); ++j) {
                Topology.City endCity = (Topology.City)pathCity.get(j);
                scorePath += this.distribution.probability(startCity, endCity);
            }
        }
        return scorePath;
    }

    private void setupScorePath(Topology topology, TaskDistribution distribution) {
        this.pathScoresHashmap = new HashMap();
        this.maxPathScore = 0.0;
        for (Topology.City city1 : topology.cities()) {
            for (Topology.City city2 : topology.cities()) {
                Pair<Topology.City, Topology.City> key = new Pair<Topology.City, Topology.City>(city1, city2);
                double scorePath = this.getPathScore(city1, city2);
                if (scorePath > this.maxPathScore) {
                    this.maxPathScore = scorePath;
                }
                this.pathScoresHashmap.put(key, scorePath);
            }
        }
        this.medianPathScore = this.computeMedian(new ArrayList<Double>(this.pathScoresHashmap.values()));
    }

    private double getPathScoreNormalized(Topology.City city1, Topology.City city2) {
        return this.pathScoresHashmap.get(new Pair<Topology.City, Topology.City>(city1, city2)) / this.maxPathScore;
    }

    private double computeMedian(ArrayList<Double> values) {
        Collections.sort(values);
        int nb_values = values.size();
        double median = nb_values % 2 == 0 ? (values.get(nb_values / 2) + values.get(nb_values / 2 - 1)) / 2.0 : values.get(nb_values / 2);
        return median;
    }

    private double clip(double x, double minX, double maxX) {
        if (x >= maxX) {
            return maxX;
        }
        if (x <= minX) {
            return minX;
        }
        return x;
    }

    private double getBid(Task task, double marginalCost) {
        double final_factor;
        double obj;
        double roundImpactPercentage;
        boolean USE_ROUND_NUMBER = true;
        int NUMBER_PACKAGE_PER_AGENTS_ESTIMATE = 3;
        double scorePath = this.pathScoresHashmap.get(new Pair<Topology.City, Topology.City>(task.pickupCity, task.deliveryCity));
        double deliveryScore = this.deliveryScoresHashmap.get(task.pickupCity);
        double d = roundImpactPercentage = this.nb_bidders > 1.0 ? this.clip(this.rounds / (this.nb_bidders * (double)NUMBER_PACKAGE_PER_AGENTS_ESTIMATE), 0.0, 1.0) : 0.0;
        if (scorePath >= this.medianPathScore && deliveryScore >= this.medianDeliveryScore) {
            double factor = 0.9;
            obj = (1.0 - factor) * roundImpactPercentage;
            double d2 = final_factor = marginalCost <= 0.0 ? 1.0 : factor + obj;
            if (marginalCost <= 0.0) {
                for (Task wonTask : this.wonTasks) {
                    Topology.City startCity = wonTask.pickupCity;
                    Topology.City endCity = wonTask.deliveryCity;
                    List pathCity = startCity.pathTo(endCity);
                    pathCity.add(0, startCity);
                    pathCity.add(endCity);
                    if (!pathCity.contains(task.pickupCity) || !pathCity.contains(task.deliveryCity)) continue;
                    System.out.println("Make some profits on the interesting paths, bidding: " + marginalCost * 0.9 + " instead of " + marginalCost);
                    final_factor = 0.9;
                    break;
                }
            }
        } else if (scorePath >= this.medianPathScore || deliveryScore >= this.medianDeliveryScore) {
            double factor = 0.95;
            obj = (1.0 - factor) * roundImpactPercentage;
            final_factor = marginalCost <= 0.0 ? 0.0 : factor + obj;
        } else {
            double factor = marginalCost > 0.0 ? 0.13 : -0.13;
            obj = 0.0;
            final_factor = 1.0 + factor;
        }
        double bid = marginalCost * final_factor;
        System.out.println("Bid calculated: " + bid + " (final_factor: " + final_factor + ", obj: " + obj + ")");
        return bid;
    }

    public void setup(Topology topology, TaskDistribution distribution, Agent agent) {
        Long time_start = System.currentTimeMillis();
        this.topology = topology;
        this.distribution = distribution;
        this.agent = agent;
        this.vehicles = agent.vehicles();
        this.random = new Random();
        LogistSettings ls = null;
        try {
            ls = Parsers.parseSettings((String)("config" + File.separator + "settings_auction.xml"));
        }
        catch (Exception exc) {
            System.out.println("There was a problem loading the configuration file.");
        }
        this.timeout_setup = ls.get(LogistSettings.TimeoutKey.SETUP);
        this.timeout_plan = ls.get(LogistSettings.TimeoutKey.PLAN) - 200L;
        this.timeout_bid = ls.get(LogistSettings.TimeoutKey.BID) - 200L;
        System.out.println("Timeout setup: " + this.timeout_setup);
        System.out.println("Timeout plan: " + this.timeout_plan);
        System.out.println("Timeout bid: " + this.timeout_bid);
        this.previousCandidate = null;
        this.auctionCandidate = null;
        this.p_planning = 0.1;
        this.p_bidding = 0.35;
        this.nb_bidders = 0.0;
        this.setupScoreDelivery(topology, distribution);
        this.setupScorePath(topology, distribution);
        Long time_end = System.currentTimeMillis();
        System.out.println("Max path: " + this.maxPathScore + " median path: " + this.medianPathScore);
        System.out.println("Median delivery score: " + this.maxDeliveryScore + " median delivery score: " + this.medianDeliveryScore);
        System.out.println("Setup in: " + (time_end - time_start) + " milliseconds");
    }

    public void auctionResult(Task previous, int winner, Long[] bids) {
        this.rounds += 1.0;
        if ((double)bids.length > this.nb_bidders) {
            this.nb_bidders = bids.length;
        }
        if (winner == this.agent.id()) {
            this.wonTasks.add(previous);
            this.previousCandidate = this.auctionCandidate;
        }
    }

    public Long askPrice(Task task) {
        double previous_cost = 0.0;
        if (this.previousCandidate != null) {
            previous_cost = this.previousCandidate.cost;
        }
        ArrayList<Task> tasksToPlan = new ArrayList<Task>(this.wonTasks);
        tasksToPlan.add(task);
        int nb_retry = 4;
        long retry_milliseconds = (long)Math.floor(this.timeout_bid / (long)nb_retry);
        if (retry_milliseconds <= 100L) {
            retry_milliseconds = this.timeout_bid;
            nb_retry = 1;
        }
        double lowest_cost = Double.POSITIVE_INFINITY;
        Candidate lowest_auctionCandidate = null;
        System.out.println("Running " + nb_retry + " times with " + retry_milliseconds + " each.");
        for (int i = 0; i < nb_retry; ++i) {
            Pair<List<Plan>, Candidate> plan_cost = CentralizedPlan.plan(this.vehicles, tasksToPlan, this.random, retry_milliseconds, this.p_bidding);
            double plan_cost_value = ((Candidate)plan_cost.y).cost;
            if (plan_cost_value < lowest_cost) {
                lowest_auctionCandidate = (Candidate)plan_cost.y;
            }
            this.auctionCandidate = (Candidate)plan_cost.y;
            System.out.println("[Bidding] Computed plan: " + plan_cost_value);
        }
        this.auctionCandidate = lowest_auctionCandidate;
        System.out.println("Final plan cost: " + this.auctionCandidate.cost);
        double transportation_cost = this.auctionCandidate.cost;
        double marginal_cost = transportation_cost - previous_cost;
        Long bid = Math.round(this.getBid(task, marginal_cost));
        System.out.println("[Negative] Bid: " + bid);
        return bid;
    }

    public List<Plan> plan(List<Vehicle> vehicles, TaskSet tasks) {
        List<Plan> planFromBefore;
        ArrayList<Task> tasksList = new ArrayList<Task>((Collection<Task>)tasks);
        int nb_retry = 2;
        long retry_milliseconds = (long)Math.floor(this.timeout_plan / (long)nb_retry);
        if (retry_milliseconds <= 100L) {
            retry_milliseconds = this.timeout_plan;
            nb_retry = 1;
        }
        double lowest_cost = Double.POSITIVE_INFINITY;
        Candidate lowest_candidate = null;
        List lowest_plan = null;
        System.out.println("[Planning] Running " + nb_retry + " times with " + retry_milliseconds + " each.");
        for (int i = 0; i < nb_retry; ++i) {
            Pair<List<Plan>, Candidate> plan_cost = CentralizedPlan.plan(vehicles, tasksList, this.random, retry_milliseconds, this.p_planning);
            List plan = (List)plan_cost.x;
            Candidate candidate = (Candidate)plan_cost.y;
            double plan_cost_value = ((Candidate)plan_cost.y).cost;
            if (plan_cost_value < lowest_cost) {
                lowest_candidate = (Candidate)plan_cost.y;
                lowest_plan = plan;
            }
            System.out.println("Computed plan: " + plan_cost_value);
        }
        System.out.println("Final plan cost: " + lowest_candidate.cost);
        Candidate candidate = lowest_candidate;
        List plan = lowest_plan;
        if (this.previousCandidate != null && candidate.cost > this.previousCandidate.cost && (planFromBefore = CentralizedPlan.PlanFromSolution(this.previousCandidate)) != null) {
            System.out.println("Saved for :" + (candidate.cost - this.previousCandidate.cost));
            return CentralizedPlan.PlanFromSolution(this.previousCandidate, this.wonTasks, tasksList);
        }
        return plan;
    }
}

