/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import ptolemy.plot.LogicAnalyzer;
import ptolemy.plot.Message;

public class LogicAnalyzerFrame
extends Frame {
    public LogicAnalyzer logicAnalyzer = new LogicAnalyzer();
    protected MenuBar _menubar = new MenuBar();
    protected Menu _fileMenu = new Menu("File");
    protected Menu _specialMenu = new Menu("Special");
    protected String _directory = null;
    protected String _filename = null;

    public LogicAnalyzerFrame() {
        this("Ptolemy Plot Frame");
    }

    public LogicAnalyzerFrame(String string) {
        super(string);
        MenuItem[] menuItemArray = new MenuItem[]{new MenuItem("Open", new MenuShortcut(79)), new MenuItem("Save", new MenuShortcut(83)), new MenuItem("SaveAs", new MenuShortcut(65)), new MenuItem("Print", new MenuShortcut(80)), new MenuItem("Close", new MenuShortcut(67))};
        FileMenuListener fileMenuListener = new FileMenuListener();
        int n = 0;
        while (n < menuItemArray.length) {
            menuItemArray[n].setActionCommand(menuItemArray[n].getLabel());
            menuItemArray[n].addActionListener(fileMenuListener);
            this._fileMenu.add(menuItemArray[n]);
            ++n;
        }
        this._menubar.add(this._fileMenu);
        MenuItem[] menuItemArray2 = new MenuItem[]{new MenuItem("About", null), new MenuItem("Help", new MenuShortcut(72)), new MenuItem("Clear", new MenuShortcut(67)), new MenuItem("Fill", new MenuShortcut(70))};
        SpecialMenuListener specialMenuListener = new SpecialMenuListener();
        int n2 = 0;
        while (n2 < menuItemArray2.length) {
            menuItemArray2[n2].setActionCommand(menuItemArray2[n2].getLabel());
            menuItemArray2[n2].addActionListener(specialMenuListener);
            this._specialMenu.add(menuItemArray2[n2]);
            ++n2;
        }
        this._menubar.add(this._specialMenu);
        this.setMenuBar(this._menubar);
        this.add("Center", this.logicAnalyzer);
        ((Component)this).setSize(500, 300);
        ((Component)this).setVisible(true);
    }

    protected void _about() {
        Message message = new Message("Ptolemy plot frame\nBy: Edward A. Lee, eal@eecs.berkeley.edu\nand Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 3.1, Build: $Id: LogicAnalyzerFrame.java,v 1.15 1999/08/11 23:23:16 cxh Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n");
        message.setTitle("About Ptolemy Plot");
    }

    protected void _close() {
        this.dispose();
    }

    protected void _help() {
        Message message = new Message("Help information should go here!");
        message.setTitle("Plot frame");
    }

    protected void _open() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Select a plot file");
        fileDialog.setFilenameFilter(new PlotFilenameFilter());
        if (this._directory != null) {
            fileDialog.setDirectory(this._directory);
        }
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        if (string == null) {
            return;
        }
        this._directory = fileDialog.getDirectory();
        File file = new File(this._directory, string);
        this._filename = null;
        try {
            this.logicAnalyzer.clear(true);
            this.logicAnalyzer.read(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Message message = new Message("File not found: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            Message message = new Message("Error reading input: " + iOException);
        }
        this._filename = string;
    }

    protected void _print() {
        PrintJob printJob = this.getToolkit().getPrintJob(this, this.getTitle(), null);
        if (printJob != null) {
            try {
                Graphics graphics = printJob.getGraphics();
                if (graphics != null) {
                    try {
                        this.logicAnalyzer.printAll(graphics);
                    }
                    finally {
                        Object var6_3 = null;
                        graphics.dispose();
                    }
                }
                Object var3_6 = null;
                printJob.end();
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                printJob.end();
                throw throwable;
            }
        }
    }

    protected void _save() {
        if (this._filename != null) {
            File file = new File(this._directory, this._filename);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.logicAnalyzer.write(fileOutputStream);
            }
            catch (IOException iOException) {
                Message message = new Message("Error writing file: " + iOException);
            }
        } else {
            this._saveAs();
        }
    }

    protected void _saveAs() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save plot as...");
        fileDialog.setFilenameFilter(new PlotFilenameFilter());
        if (this._directory != null) {
            fileDialog.setDirectory(this._directory);
        }
        fileDialog.setFile("plot.plt");
        ((Component)fileDialog).setVisible(true);
        this._filename = fileDialog.getFile();
        if (this._filename == null) {
            return;
        }
        this._directory = fileDialog.getDirectory();
        this._save();
    }

    class FileMenuListener
    implements ActionListener {
        FileMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = menuItem.getActionCommand();
            if (string.equals("Open")) {
                LogicAnalyzerFrame.this._open();
            } else if (string.equals("Save")) {
                LogicAnalyzerFrame.this._save();
            } else if (string.equals("SaveAs")) {
                LogicAnalyzerFrame.this._saveAs();
            } else if (string.equals("Print")) {
                LogicAnalyzerFrame.this._print();
            } else if (string.equals("Close")) {
                LogicAnalyzerFrame.this._close();
            }
        }
    }

    class SpecialMenuListener
    implements ActionListener {
        SpecialMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = menuItem.getActionCommand();
            if (string.equals("About")) {
                LogicAnalyzerFrame.this._about();
            } else if (string.equals("Help")) {
                LogicAnalyzerFrame.this._help();
            } else if (string.equals("Fill")) {
                LogicAnalyzerFrame.this.logicAnalyzer.fillPlot();
            } else if (string.equals("Clear")) {
                LogicAnalyzerFrame.this.logicAnalyzer.clear(false);
                LogicAnalyzerFrame.this.logicAnalyzer.repaint();
            }
        }
    }

    class PlotFilenameFilter
    implements FilenameFilter {
        PlotFilenameFilter() {
        }

        public boolean accept(File file, String string) {
            return (string = string.toLowerCase()).endsWith(".plt");
        }
    }
}

