/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.awt.Color;
import uchicago.src.sim.analysis.GuiChartDataSource;

public class SequenceSource
implements GuiChartDataSource {
    private String name = "A Sequence";
    private String methodName;
    private String fieldName;
    private Object feedFrom;
    private String feedFromName;
    private String sourceName;
    private int markType = 0;
    private Color color = Color.blue;

    public SequenceSource(Object object) {
        this.feedFrom = object;
        this.feedFromName = object.getClass().getName();
        int n = this.feedFromName.lastIndexOf(46);
        if (n != -1) {
            this.feedFromName = this.feedFromName.substring(n + 1);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
        this.sourceName = this.feedFromName + "." + string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        this.methodName = string;
        this.sourceName = this.feedFromName + "." + string;
    }

    public Object getFeedFrom() {
        return this.feedFrom;
    }

    public void setFeedFrom(Object object) {
        this.feedFrom = object;
    }

    public int getMarkStyle() {
        return this.markType;
    }

    public void setMarkStyle(int n) {
        this.markType = n;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getFullName() {
        return this.sourceName;
    }

    public String getShortName() {
        if (this.methodName == null) {
            return this.fieldName;
        }
        return this.methodName;
    }

    public GuiChartDataSource copy() {
        SequenceSource sequenceSource = new SequenceSource(this.feedFrom);
        sequenceSource.methodName = this.methodName;
        sequenceSource.name = this.name;
        sequenceSource.fieldName = this.fieldName;
        sequenceSource.feedFromName = this.feedFromName;
        sequenceSource.sourceName = this.sourceName;
        sequenceSource.markType = this.markType;
        sequenceSource.color = this.color;
        return sequenceSource;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer("<DataSource name=\"");
        stringBuffer.append(this.name);
        stringBuffer.append("\" color=\"");
        stringBuffer.append(this.color.getRGB());
        stringBuffer.append("\" methodName=\"");
        stringBuffer.append(this.methodName);
        stringBuffer.append("\" markStyle=\"");
        stringBuffer.append(this.markType);
        stringBuffer.append("\" />");
        return stringBuffer.toString();
    }
}

