/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.math;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uchicago.src.sim.engine.ActionQueue;
import uchicago.src.sim.engine.BasicAction;
import uchicago.src.sim.engine.Schedule;
import uchicago.src.sim.math.CEquation;

public class CEquationFactory {
    private Set scheduledIntervals = new HashSet();
    private Map eqActionsByInterval = new HashMap();
    private ActionQueue queue = new ActionQueue();
    private List execList = new ArrayList();
    private Schedule schedule;

    public CEquationFactory(Schedule schedule) {
        this.schedule = schedule;
    }

    public CEquation createEquation(Object object, String string, String string2, double d) {
        return this.createEquation(object, string, string2, 0.0, d);
    }

    public CEquation createEquation(Object object, String string, String string2, double d, double d2) {
        CEquation cEquation = new CEquation(object, this.schedule, string, string2, d);
        this.scheduleEquation(cEquation, d2);
        return cEquation;
    }

    private void scheduleEquation(CEquation cEquation, double d) {
        EqAction eqAction;
        Double d2 = new Double(d);
        if (!this.scheduledIntervals.contains(d2)) {
            this.schedule.scheduleActionAtInterval(d, new MainAction());
            this.scheduledIntervals.add(d2);
        }
        if ((eqAction = (EqAction)this.eqActionsByInterval.get(d2)) == null) {
            eqAction = new EqAction(cEquation);
            eqAction.setNextTime(this.schedule.getCurrentTime() + d);
            eqAction.setIntervalTime(d);
            this.eqActionsByInterval.put(d2, eqAction);
            this.queue.toss(eqAction);
        } else {
            eqAction.addEquation(cEquation);
        }
    }

    private void update() {
        EqAction eqAction;
        int n;
        BasicAction basicAction;
        this.execList.clear();
        double d = this.schedule.getCurrentTime();
        while (this.queue.size() > 0 && (basicAction = this.queue.peekMin()).getNextTime() <= d) {
            this.execList.add(this.queue.popMin());
        }
        int n2 = this.execList.size();
        for (n = 0; n < n2; ++n) {
            eqAction = (EqAction)this.execList.get(n);
            eqAction.evaluate();
        }
        n2 = this.execList.size();
        for (n = 0; n < n2; ++n) {
            eqAction = (EqAction)this.execList.get(n);
            eqAction.postEvaluate(this.queue);
        }
    }

    static class EqAction
    extends BasicAction {
        private List equations = new ArrayList();

        public EqAction(CEquation cEquation) {
            this.equations.add(cEquation);
        }

        public void addEquation(CEquation cEquation) {
            this.equations.add(cEquation);
        }

        public void execute() {
            throw new UnsupportedOperationException();
        }

        public void evaluate() {
            Iterator iterator = this.equations.iterator();
            while (iterator.hasNext()) {
                CEquation cEquation = (CEquation)iterator.next();
                cEquation.evaluate();
            }
        }

        public void postEvaluate(ActionQueue actionQueue) {
            Iterator iterator = this.equations.iterator();
            while (iterator.hasNext()) {
                CEquation cEquation = (CEquation)iterator.next();
                cEquation.assign();
            }
            this.reSchedule(actionQueue);
        }
    }

    class MainAction
    extends BasicAction {
        MainAction() {
        }

        public void execute() {
            CEquationFactory.this.update();
        }
    }
}

