/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.StringTokenizer;
import uchicago.src.sim.gui.Display;
import uchicago.src.sim.gui.DisplayInfo;
import uchicago.src.sim.gui.Moveable;
import uchicago.src.sim.gui.Probeable;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.gui.ViewEvent;

public class TextDisplay
extends Display
implements Probeable {
    protected Color textColor;
    protected boolean drawBox = true;
    protected ArrayList text = new ArrayList();
    protected String header = null;
    protected Font curFont = new Font("monospace", 0, 12);
    protected Box box;
    private Moveable mbox = new Moveable(){

        public void setX(int n) {
            TextDisplay.this.setX(n);
        }

        public void setY(int n) {
            TextDisplay.this.setY(n);
        }
    };

    public TextDisplay(int n, int n2, Color color) {
        this(0, 0, n, n2, color);
    }

    public TextDisplay(int n, int n2, int n3, int n4, Color color) {
        super(n, n2);
        this.textColor = color;
        this.box = new Box();
        this.box.x = n3;
        this.box.y = n4;
    }

    public void setBoxVisible(boolean bl) {
        this.drawBox = bl;
    }

    public void setHeader(String string) {
        this.header = string;
    }

    public void addLine(String string) {
        if (string.indexOf("\n") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.text.add(stringTokenizer.nextToken());
            }
        } else {
            this.text.add(string);
        }
    }

    public void addLine(String string, int n) {
        int n2 = 0;
        if (string.indexOf("\n") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.text.add(n + n2, stringTokenizer.nextToken());
                ++n2;
            }
        } else {
            this.text.add(n, string);
        }
    }

    public void clearLines() {
        this.text.clear();
    }

    public void clearLine(int n) {
        this.text.remove(n);
    }

    public void setColor(Color color) {
        this.textColor = color;
    }

    public void setFontSize(int n) {
        this.curFont = new Font("monospace", 0, n);
    }

    public int getFontSize() {
        return this.curFont.getSize();
    }

    public void setTextCoordinates(int n, int n2) {
        this.box.x = n;
        this.box.y = n2;
    }

    public int getX() {
        return this.box.x;
    }

    public void setX(int n) {
        this.box.x = n;
    }

    public int getY() {
        return this.box.y;
    }

    public void setY(int n) {
        this.box.y = n;
    }

    public Box getBoundingBox() {
        return this.box;
    }

    public void drawDisplay(SimGraphics simGraphics) {
        if (this.view) {
            int n;
            int n2;
            int n3;
            Graphics2D graphics2D = simGraphics.getGraphics();
            Font font = graphics2D.getFont();
            Color color = graphics2D.getColor();
            graphics2D.setFont(this.curFont);
            graphics2D.setColor(this.textColor);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n4 = 0;
            int n5 = fontMetrics.getHeight();
            if (this.drawBox) {
                n3 = this.box.x + 6;
                n2 = this.box.y + n5;
            } else {
                n3 = this.box.x;
                n2 = this.box.y;
            }
            int n6 = 0;
            if (this.header != null) {
                n4 = n = fontMetrics.stringWidth(this.header);
                graphics2D.drawString(this.header, n3, n2);
                n2 += n5 + 4;
                n6 = n5 + 4;
            }
            for (n = 0; n < this.text.size(); ++n) {
                String string = (String)this.text.get(n);
                int n7 = fontMetrics.stringWidth(string);
                if (n7 > n4) {
                    n4 = n7;
                }
                graphics2D.drawString(string, n3, n2);
                n2 += n5;
                n6 += n5;
            }
            if (this.drawBox) {
                graphics2D.drawRect(this.box.x, this.box.y, n4 + 12, n6 + 6);
                this.box.width = n4 + 12;
                this.box.height = n6 + 6;
            } else {
                this.box.width = n4;
                this.box.height = n6;
            }
            graphics2D.setFont(font);
            graphics2D.setColor(color);
        }
    }

    public ArrayList getDisplayableInfo() {
        ArrayList<DisplayInfo> arrayList = new ArrayList<DisplayInfo>();
        arrayList.add(new DisplayInfo("", -1, this));
        return arrayList;
    }

    public void viewEventPerformed(ViewEvent viewEvent) {
        this.view = viewEvent.showView();
    }

    public ArrayList getObjectsAt(int n, int n2) {
        ArrayList<Moveable> arrayList = new ArrayList<Moveable>();
        if (this.box.contains(n, n2)) {
            arrayList.add(this.mbox);
        }
        return arrayList;
    }

    public void setMoveableXY(Moveable moveable, int n, int n2) {
        moveable.setX(n);
        moveable.setY(n2);
    }

    public static class Box {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;

        public boolean contains(int n, int n2) {
            return n >= this.x && n <= this.x + this.width && n2 >= this.y && n2 <= this.y + this.height;
        }
    }
}

