/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.util.ArrayList;
import uchicago.src.sim.gui.DisplaySurface;
import uchicago.src.sim.gui.Displayable;
import uchicago.src.sim.gui.SimGraphics;

public abstract class Painter {
    protected ArrayList orderedDisplayables = new ArrayList();
    protected DisplaySurface surface;
    protected BufferedImage buffImage = null;
    protected Graphics2D g2 = null;
    protected int width;
    protected int height;
    protected float origWidth;
    protected float origHeight;
    protected ArrayList displayables = new ArrayList();
    protected SimGraphics simGraphics = new SimGraphics();
    protected Toolkit toolkit;
    protected Color bgColor = Color.black;

    public Painter() {
    }

    public Painter(DisplaySurface displaySurface, int n, int n2) {
        this.surface = displaySurface;
        this.width = n;
        this.origWidth = this.width;
        this.height = n2;
        this.origHeight = this.height;
        this.toolkit = displaySurface.getToolkit();
    }

    public void init(DisplaySurface displaySurface, int n, int n2) {
        this.surface = displaySurface;
        this.toolkit = displaySurface.getToolkit();
        this.width = n;
        this.origWidth = this.width;
        this.height = n2;
        this.origHeight = this.height;
    }

    protected void createBufferedImage() {
        this.buffImage = this.surface.getGraphicsConfiguration().createCompatibleImage(this.width, this.height);
    }

    public void reSize(int n, int n2) {
        float f = (float)n / this.origWidth;
        float f2 = (float)n2 / this.origHeight;
        this.width = n;
        this.height = n2;
        if (this.buffImage != null) {
            this.buffImage.flush();
            this.buffImage = null;
            this.buffImage = this.surface.getGraphicsConfiguration().createCompatibleImage(n, n2);
            this.simGraphics.setYScale(f2);
            this.simGraphics.setXScale(f);
        }
    }

    protected void createGraphics2D() {
        this.g2 = this.buffImage.createGraphics();
        this.g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
    }

    public void addDisplayable(Displayable displayable) {
        this.displayables.add(displayable);
    }

    public void addDisplayable(DisplaySurface.DisplayableOrder displayableOrder) {
        this.orderedDisplayables.add(displayableOrder);
    }

    public void removeDisplayable(Displayable displayable) {
        this.displayables.remove(displayable);
    }

    public Graphics2D getGraphics() {
        return this.g2;
    }

    public abstract void paint(Graphics var1);

    public abstract void drawRect(Graphics var1, int var2, int var3, int var4, int var5);

    public abstract void eraseRect(Graphics var1);

    public void finalize() {
        if (this.g2 != null) {
            this.g2.dispose();
        }
    }

    public void dispose() {
        if (this.g2 != null) {
            this.g2.dispose();
        }
        this.displayables.clear();
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = color;
    }

    protected void paintBackground() {
        this.g2.setColor(this.bgColor);
        this.g2.fillRect(0, 0, this.width, this.height);
    }

    public abstract void takeSnapshot(DataOutputStream var1);

    public Image getCurrentImage() {
        return this.buffImage;
    }
}

