/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.reflector;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import uchicago.src.collection.Pair;
import uchicago.src.reflector.Invoker;
import uchicago.src.reflector.InvokerException;
import uchicago.src.reflector.InvokerFactory;
import uchicago.src.reflector.MethodFactory;
import uchicago.src.sim.util.SimUtilities;

public class Introspector {
    public static final int GET = 0;
    public static final int SET = 1;
    private TreeMap getSetMethods = new TreeMap();
    private Object spectee = null;
    private HashSet stringables = new HashSet();

    public Introspector() {
        this.stringables.add(Integer.class);
        this.stringables.add(Long.class);
        this.stringables.add(String.class);
        this.stringables.add(Float.class);
        this.stringables.add(Byte.class);
        this.stringables.add(Double.class);
        this.stringables.add(Boolean.class);
    }

    public void introspect(Object object, String[] stringArray) throws IntrospectionException {
        this.spectee = object;
        Class<?> clazz = this.spectee.getClass();
        this.getSetMethods = MethodFactory.getInstance().getAccessorMethods(clazz, stringArray);
    }

    public Method getAccessorMethod(String string, int n) {
        Pair pair = (Pair)this.getSetMethods.get(string);
        if (pair == null) {
            throw new IllegalArgumentException("Accessor Method for: " + string + " not found");
        }
        if (n == 0) {
            return (Method)pair.first;
        }
        if (n == 1) {
            return (Method)pair.second;
        }
        throw new IllegalArgumentException("Illegal type");
    }

    public void printProperties() {
        Iterator iterator = this.getSetMethods.keySet().iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public Iterator getPropertyNames() {
        return this.getSetMethods.keySet().iterator();
    }

    public Object getPropertyValue(String string) throws InvocationTargetException, IllegalAccessException {
        Pair pair = (Pair)this.getSetMethods.get(string);
        if (pair == null) {
            throw new IllegalArgumentException("Property: " + string + " not found");
        }
        Method method = (Method)pair.first;
        return method.invoke(this.spectee, new Object[0]);
    }

    public boolean isPropertyStringable(String string) throws InvocationTargetException, IllegalAccessException {
        Object object = this.getPropertyValue(string);
        if (object != null) {
            return this.stringables.contains(object.getClass());
        }
        return false;
    }

    public Class getPropertyClass(String string) {
        return this.getAccessorMethod(string, 0).getReturnType();
    }

    public boolean isPropertyBoolean(String string) throws InvocationTargetException, IllegalAccessException {
        Method method = this.getAccessorMethod(string, 0);
        return method.getReturnType().equals(Boolean.class) || method.getReturnType().equals(Boolean.TYPE);
    }

    public String getPropertyAsString(String string) throws InvocationTargetException, IllegalAccessException {
        Object object = this.getPropertyValue(string);
        return object.toString();
    }

    public boolean hasProperty(String string) {
        return this.getSetMethods.containsKey(string);
    }

    public String getPropertiesValues() throws InvocationTargetException, IllegalAccessException {
        Iterator iterator = this.getSetMethods.keySet().iterator();
        String string = "";
        String string2 = System.getProperty("line.separator");
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = this.getPropertyAsString(string3);
            string = string + string3 + ": " + string4 + string2;
        }
        return string;
    }

    public Hashtable getPropValues() throws InvocationTargetException, IllegalAccessException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Iterator iterator = this.getSetMethods.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            hashtable.put(string, this.getPropertyValue(string));
        }
        return hashtable;
    }

    public void invokeSetMethod(String string, Object object) throws InvocationTargetException, IllegalAccessException {
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = Character.toUpperCase(stringBuffer.charAt(0));
        stringBuffer.setCharAt(0, c);
        Pair pair = (Pair)this.getSetMethods.get(stringBuffer.toString());
        Method method = (Method)pair.second;
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz = classArray[0];
        Invoker invoker = InvokerFactory.createInvoker(clazz, this.spectee, method, object);
        try {
            invoker.execute();
        }
        catch (InvokerException invokerException) {
            SimUtilities.showError("Invalid Parameter for " + string + "\n" + invokerException.getMessage(), invokerException);
        }
    }

    public boolean isReadOnly(String string) {
        Pair pair = (Pair)this.getSetMethods.get(string);
        if (pair == null) {
            throw new IllegalArgumentException("Property: " + string + " not found");
        }
        return pair.second == null;
    }

    public boolean isWriteOnly(String string) {
        Pair pair = (Pair)this.getSetMethods.get(string);
        if (pair == null) {
            throw new IllegalArgumentException("Property: " + string + " not found");
        }
        return pair.first == null;
    }

    public void reset() {
        this.getSetMethods = new TreeMap();
        this.spectee = null;
        this.stringables = new HashSet();
    }
}

