/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.task;

import epfl.lia.logist.core.topology.City;
import epfl.lia.logist.tools.Pair;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbabilityDistribution {
    private HashMap<Pair<City>, Double> mProbabilityMap = new HashMap();
    private HashMap<Pair<City>, Double> mRewardMap = new HashMap();

    public ProbabilityDistribution(HashMap<Pair<City>, Double> mapProbs, HashMap<Pair<City>, Double> mapReward) {
        this.mProbabilityMap = mapProbs;
        this.mRewardMap = mapReward;
    }

    public double getProbability(City c1, City c2) {
        Pair<City> pair = new Pair<City>(c1, c2);
        Double prob = this.mProbabilityMap.get(pair);
        if (prob != null) {
            return prob;
        }
        return 0.0;
    }

    public double getSumNeighborsProb(City c) {
        double probability = 0.0;
        Pair<City> pair = null;
        ArrayList nodes = c.getOutNodes();
        for (Object node : nodes) {
            pair = new Pair<City>(c, (City)((Object)node));
            Double prob = this.mProbabilityMap.get(pair);
            if (prob == null) continue;
            probability += prob.doubleValue();
        }
        return probability;
    }

    public double getRewardPerKm(City c1, City c2) {
        Pair<City> pair = new Pair<City>(c1, c2);
        Double reward = this.mRewardMap.get(pair);
        if (reward != null) {
            return reward;
        }
        return 0.0;
    }
}

