/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.logging.format;

import epfl.lia.logist.logging.LogDescriptor;
import epfl.lia.logist.logging.LogEntry;
import epfl.lia.logist.logging.LogOutputFormat;
import java.io.PrintStream;
import java.util.GregorianCalendar;

public class XmlLogOutputFormat
implements LogOutputFormat {
    private PrintStream moFileStream = null;
    private LogDescriptor moDescriptor = null;
    private int miCount = 0;

    public XmlLogOutputFormat(LogDescriptor d) throws Exception {
        this.moDescriptor = d;
        this.moFileStream = new PrintStream(d.File);
    }

    public void outputEntry(LogEntry e) {
        String lsSeverity = "<entry-severity>" + (Object)((Object)e.getSeverity()) + "</entry-severity>";
        String lsModule = "<entry-module>" + e.getModule() + "</entry-module>";
        String lsLine = "<entry-line>" + e.getLine() + "</entry-line>";
        String lsTime = "<entry-time>" + String.format("%1$tH:%1$tM:%1$tS", new GregorianCalendar()) + "</entry-time>";
        String lsMsg = "<entry-message>" + e.getText() + "</entry-message>";
        this.moFileStream.println("    <log-entry id=\"" + this.miCount++ + "\">");
        this.moFileStream.println("      " + lsSeverity);
        this.moFileStream.println("      " + lsModule);
        this.moFileStream.println("      " + lsLine);
        this.moFileStream.println("      " + lsTime);
        this.moFileStream.println("      " + lsMsg);
        this.moFileStream.println("    </log-entry>");
    }

    public void init() {
        this.outputFileHeader();
    }

    public void close() {
        this.outputFileFooter();
    }

    private void outputFileHeader() {
        String lsStartDate = "<start-date>" + String.format("%1$ta %1$tb %1$td %1$tT %1$tZ %1$tY", new GregorianCalendar()) + "</start-date>";
        String lsStartTime = "<start-time>" + String.format("%1$tH:%1$tM:%1$tS", new GregorianCalendar()) + "</start-time>";
        String lsJVMVendor = "<java-vendor>" + System.getProperty("java.vendor") + "</java-vendor>";
        String lsJVMVendorURL = "<java-vendor-url>" + System.getProperty("java.vendor.url") + "</java-vendor-url>";
        String lsJVMVersion = "<java-version>" + System.getProperty("java.version") + "</java-version>";
        String lsOsArch = "<os-arch>" + System.getProperty("os.arch") + "</os-arch>";
        String lsOsName = "<os-name>" + System.getProperty("os.name") + "</os-name>";
        String lsUsername = "<user-name>" + System.getProperty("user.name") + "</user-name>";
        String lsCacheSize = "<cache-size>" + this.moDescriptor.CacheSize + "</cache-size>";
        String lsMaxEntries = "<max-entries>" + this.moDescriptor.MaxEntries + "</max-entries>";
        String lsDebugLevel = "<debug-level>" + this.moDescriptor.DebugLevel + "</debug-level>";
        this.moFileStream.println("<log>");
        this.moFileStream.println("  <general-info>");
        this.moFileStream.println("    " + lsStartDate);
        this.moFileStream.println("    " + lsStartTime);
        this.moFileStream.println("    " + lsJVMVendor);
        this.moFileStream.println("    " + lsJVMVendorURL);
        this.moFileStream.println("    " + lsJVMVersion);
        this.moFileStream.println("    " + lsOsArch);
        this.moFileStream.println("    " + lsOsName);
        this.moFileStream.println("    " + lsUsername);
        this.moFileStream.println("    " + lsCacheSize);
        this.moFileStream.println("    " + lsMaxEntries);
        this.moFileStream.println("    " + lsDebugLevel);
        this.moFileStream.println("  </general-info>");
        this.moFileStream.println();
        this.moFileStream.println("  <log-entries>");
    }

    private void outputFileFooter() {
        this.moFileStream.println("  </log-entries>");
        this.moFileStream.println("</log>");
    }
}

