/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.core;

import epfl.lia.logist.agent.AgentManager;
import epfl.lia.logist.agent.AgentProfile;
import epfl.lia.logist.config.Configuration;
import epfl.lia.logist.core.IService;
import epfl.lia.logist.core.listeners.ITopologyListener;
import epfl.lia.logist.core.topology.Topology;
import epfl.lia.logist.core.view.CustomNetworkDisplay;
import epfl.lia.logist.core.view.ModelView;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.messaging.MessageDispatcher;
import epfl.lia.logist.task.TaskManager;
import epfl.lia.logist.tools.Convert;
import epfl.lia.logist.tools.LogistGlobals;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import uchicago.src.sim.engine.Schedule;
import uchicago.src.sim.engine.SimEvent;
import uchicago.src.sim.engine.SimEventListener;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.engine.SimModelImpl;
import uchicago.src.sim.gui.DisplaySurface;
import uchicago.src.sim.gui.Displayable;
import uchicago.src.sim.space.VectorSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationModel
extends SimModelImpl
implements SimEventListener {
    private static LogistGlobals mGlobals = new LogistGlobals();
    private Schedule mSchedule = null;
    protected DisplaySurface mDisplay = null;
    private ModelView mViews = null;
    private AgentManager mAgentMgr = null;
    private MessageDispatcher mMsgDisp = null;
    private TaskManager mTaskMgr = null;
    private LogManager mLogMgr = LogManager.getInstance();
    private Topology mTopology = null;
    private int mRound = 1;
    private ArrayList<IService> mServices = new ArrayList();
    private ArrayList<ITopologyListener> mListeners = new ArrayList();
    private boolean mFirstRound = true;
    private boolean mKilling = false;

    public void createFromConfiguration(Configuration c) throws Exception {
        this.parseGlobals(c.Propset);
        this.instantiateAllServices();
        this.registerAllServices();
        this.initializeAllServices();
        this.setupAllServices(c);
    }

    public void addListener(ITopologyListener tcl) {
        this.mListeners.add(tcl);
    }

    public ArrayList<ITopologyListener> getListeners() {
        return this.mListeners;
    }

    public void parseGlobals(Properties propset) throws Exception {
        SimulationModel.mGlobals.WorldXSize = Convert.toInt((String)propset.get("world-xsize"), SimulationModel.mGlobals.WorldXSize);
        SimulationModel.mGlobals.WorldXSize = Convert.toInt((String)propset.get("world-ysize"), SimulationModel.mGlobals.WorldYSize);
        SimulationModel.mGlobals.Backcolor = Convert.toColor((String)propset.get("backcolor"), SimulationModel.mGlobals.Backcolor);
        SimulationModel.mGlobals.Forecolor = Convert.toColor((String)propset.get("forecolor"), SimulationModel.mGlobals.Forecolor);
        SimulationModel.mGlobals.Rounds = Convert.toInt((String)propset.get("num-rounds"), SimulationModel.mGlobals.Rounds);
        SimulationModel.mGlobals.ResetTimeout = Convert.toLong((String)propset.get("reset-timeout"), SimulationModel.mGlobals.ResetTimeout);
        SimulationModel.mGlobals.InitTimeout = Convert.toLong((String)propset.get("init-timeout"), SimulationModel.mGlobals.InitTimeout);
        SimulationModel.mGlobals.SetupTimeout = Convert.toLong((String)propset.get("setup-timeout"), SimulationModel.mGlobals.SetupTimeout);
        SimulationModel.mGlobals.AuctionTimeout = Convert.toLong((String)propset.get("auction-timeout"), SimulationModel.mGlobals.AuctionTimeout);
        SimulationModel.mGlobals.KillTimeout = Convert.toLong((String)propset.get("kill-timeout"), SimulationModel.mGlobals.KillTimeout);
        SimulationModel.mGlobals.CityNameColor = Convert.toColor((String)propset.get("city-name-color"), SimulationModel.mGlobals.CityNameColor);
        SimulationModel.mGlobals.CityColor = Convert.toColor((String)propset.get("city-color"), SimulationModel.mGlobals.CityColor);
        SimulationModel.mGlobals.CityPerimColor = Convert.toColor((String)propset.get("city-perim-color"), SimulationModel.mGlobals.CityPerimColor);
        SimulationModel.mGlobals.CityRadius = Convert.toInt((String)propset.get("city-radius"), SimulationModel.mGlobals.CityRadius);
        SimulationModel.mGlobals.RouteSize = (float)Convert.toDouble((String)propset.get("route-size"), SimulationModel.mGlobals.RouteSize);
        SimulationModel.mGlobals.RouteColor = Convert.toColor((String)propset.get("route-color"), SimulationModel.mGlobals.RouteColor);
        SimulationModel.mGlobals.TaskIndicatorColor = Convert.toColor((String)propset.get("task-text-color"), SimulationModel.mGlobals.TaskIndicatorColor);
        SimulationModel.mGlobals.TaskToPickupColor = Convert.toColor((String)propset.get("task-pickup-color"), SimulationModel.mGlobals.TaskToPickupColor);
        SimulationModel.mGlobals.TaskToDeliverColor = Convert.toColor((String)propset.get("task-deliver-color"), SimulationModel.mGlobals.TaskToDeliverColor);
        SimulationModel.mGlobals.TaskIndicatorColor = Convert.toColor((String)propset.get("task-indicator-color"), SimulationModel.mGlobals.TaskIndicatorColor);
        SimulationModel.mGlobals.TaskThreshold = Convert.toInt((String)propset.get("task-threshold"), SimulationModel.mGlobals.TaskThreshold);
        SimulationModel.mGlobals.Antialias = Convert.toBoolean((String)propset.get("antialias-scene"), SimulationModel.mGlobals.Antialias);
        SimulationModel.mGlobals.TextAntialias = Convert.toBoolean((String)propset.get("antialias-text"), SimulationModel.mGlobals.TextAntialias);
        SimulationModel.mGlobals.ShowLegend = Convert.toBoolean((String)propset.get("show-legend"), SimulationModel.mGlobals.ShowLegend);
        SimulationModel.mGlobals.ShowGui = Convert.toBoolean((String)propset.get("show-gui"), SimulationModel.mGlobals.ShowGui);
        SimulationModel.mGlobals.ClassPath = Convert.toString((String)propset.get("classpath"), SimulationModel.mGlobals.ClassPath);
        SimulationModel.mGlobals.LogPath = Convert.toString((String)propset.get("log-dir"), System.getProperty("user.dir"));
        SimulationModel.mGlobals.HistoryPath = Convert.toString((String)propset.get("history-dir"), System.getProperty("user.dir"));
        File logFilepath = new File(SimulationModel.mGlobals.LogPath);
        File historyFilepath = new File(SimulationModel.mGlobals.HistoryPath);
        if (!logFilepath.exists() || !logFilepath.isDirectory()) {
            SimulationModel.mGlobals.LogPath = System.getProperty("user.dir");
        }
        if (!historyFilepath.exists() || !historyFilepath.isDirectory()) {
            SimulationModel.mGlobals.HistoryPath = System.getProperty("user.dir");
        }
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Log file path: " + SimulationModel.mGlobals.LogPath);
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "History file path: " + SimulationModel.mGlobals.HistoryPath);
    }

    public void simEventPerformed(SimEvent e) {
        if (e.getId() == 0 || e.getId() == 2) {
            this.destroyAllServices();
            this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Flushing entries in the log management subsystem...");
            this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Simulation ended successfully...");
            this.mLogMgr.flush(LogManager.DEFAULT);
            this.mLogMgr.flush(LogManager.OUT);
            this.mLogMgr.shutdown();
            System.exit(0);
        }
    }

    public void instantiateAllServices() {
        this.mViews = new ModelView(SimulationModel.mGlobals.WorldXSize, SimulationModel.mGlobals.WorldYSize);
        this.mTopology = new Topology();
        this.mMsgDisp = new MessageDispatcher();
        this.mTaskMgr = new TaskManager(this.mTopology);
        this.mAgentMgr = new AgentManager();
    }

    public void registerAllServices() {
        this.mServices.add(this.mViews);
        this.mServices.add(this.mTopology);
        this.mServices.add(this.mMsgDisp);
        this.mServices.add(this.mTaskMgr);
        this.mServices.add(this.mAgentMgr);
        this.mTopology.addListener(this.mViews.getTopologyView());
        this.mTopology.addListener(this.mTaskMgr);
        this.mAgentMgr.addListener(this.mViews.getAgentView());
        this.mAgentMgr.addListener(this.mTaskMgr);
    }

    public void initializeAllServices() throws Exception {
        for (IService service : this.mServices) {
            this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "'" + service.toString() + "' is initilizing...");
            service.init();
        }
    }

    public void setupAllServices(Configuration c) throws Exception {
        for (IService service : this.mServices) {
            this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "'" + service.toString() + "' is auto-setting up...");
            service.setup(c, mGlobals);
        }
        this.mLogMgr.setup(c, mGlobals);
    }

    public void resetAllServices(int round) {
        for (IService service : this.mServices) {
            service.reset(round);
        }
    }

    public void destroyAllServices() {
        int i = this.mServices.size() - 1;
        while (i >= 0) {
            this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "'" + this.mServices.get(i).toString() + "' is shutting down...");
            this.mServices.get(i).shutdown();
            --i;
        }
    }

    public void begin() {
        this.addSimEventListener(this);
        this.initModel();
        this.initScheduler();
        if (SimulationModel.mGlobals.ShowGui) {
            this.initDisplay();
        }
    }

    public void setup() {
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Running setup()...");
        this.mSchedule = new Schedule(1.0);
        if (SimulationModel.mGlobals.ShowGui) {
            if (this.mDisplay != null) {
                this.mDisplay.dispose();
                this.mDisplay = null;
            }
            this.mDisplay = new DisplaySurface(new Dimension(SimulationModel.mGlobals.WorldXSize, SimulationModel.mGlobals.WorldYSize), (SimModel)this, "PICKUP AND DELIVERY SIMULATION");
            this.registerDisplaySurface("PICKUP AND DELIVERY SIMULATION", this.mDisplay);
        }
    }

    protected void initScheduler() {
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Initializing the scheduler...");
        this.mSchedule.scheduleActionBeginning(2.0, (Object)this, "step");
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Initializing of the scheduler is complete.");
    }

    protected void initDisplay() {
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Initializing the display objects...");
        CustomNetworkDisplay networkDisplay = new CustomNetworkDisplay((VectorSpace)this.mViews.getTopologyView().space(), (VectorSpace)this.mViews.getAgentView().space(), mGlobals);
        this.mDisplay.addDisplayable((Displayable)networkDisplay, "Topology");
        this.mDisplay.setDoubleBuffered(true);
        this.mDisplay.setMinimumSize(new Dimension(SimulationModel.mGlobals.WorldXSize, SimulationModel.mGlobals.WorldYSize));
        this.mDisplay.setMaximumSize(new Dimension(SimulationModel.mGlobals.WorldXSize, SimulationModel.mGlobals.WorldYSize));
        this.mDisplay.setPreferredSize(new Dimension(SimulationModel.mGlobals.WorldXSize, SimulationModel.mGlobals.WorldYSize));
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Initialization of the display objects is complete...");
        this.mDisplay.setBackground(SimulationModel.mGlobals.Backcolor);
        this.mDisplay.setForeground(SimulationModel.mGlobals.Forecolor);
        if (SimulationModel.mGlobals.ShowLegend) {
            this.mDisplay.createLegend("Vehicles");
            for (AgentProfile ap : this.mAgentMgr.getProfileList()) {
                if (ap.getDisplayable() != null) {
                    this.mDisplay.addLegendLabel(ap.getName(), 0, ap.getDisplayable().getColor(), false);
                    continue;
                }
                this.mDisplay.addLegendLabel(ap.getName(), 1, Color.BLACK, false);
            }
        }
        this.mDisplay.display();
    }

    protected void initModel() {
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Initializing the simulation model...");
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Initializing the simulation model is complete.");
    }

    public void step() {
        int lAliveCount = 0;
        if (this.mFirstRound) {
            this.initializeRound(true);
            this.mFirstRound = false;
            this.mKilling = false;
        }
        this.mAgentMgr.verifyScheduledAgents();
        for (AgentProfile ap : this.mAgentMgr.getProfileList()) {
            if (!ap.isAlive()) continue;
            ap.step();
            ++lAliveCount;
        }
        if (lAliveCount == 0) {
            this.stop();
        }
        this.mTaskMgr.generateMoreTasks();
        if (this.mTaskMgr.allTasksDelivered() && !this.mKilling) {
            if (this.mRound < SimulationModel.mGlobals.Rounds) {
                this.initializeRound(false);
                this.mKilling = false;
            } else {
                this.mAgentMgr.killAllAgents();
                this.mKilling = true;
            }
        }
        if (SimulationModel.mGlobals.ShowGui) {
            this.mDisplay.updateDisplay();
        }
    }

    protected void initializeRound(boolean bFirst) {
        if (bFirst) {
            this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Lauching agents on first run...");
            this.mAgentMgr.initAllAgents();
        } else {
            ++this.mRound;
            this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Initializing round #" + this.mRound);
            this.resetAllServices(this.mRound);
        }
    }

    public String[] getInitParam() {
        String[] params = new String[]{};
        return params;
    }

    public String getName() {
        return "EPFL-LIA Logist Platform v.1.0.67";
    }

    public Schedule getSchedule() {
        return this.mSchedule;
    }
}

