/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter.rpl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.parameter.AbstractParameterSetter;
import uchicago.src.sim.parameter.rpl.RPLCompiler;
import uchicago.src.sim.parameter.rpl.RPLParameter;
import uchicago.src.sim.util.Random;
import uchicago.src.sim.util.RepastException;
import uchicago.src.sim.util.SimUtilities;

public class RPLParameterSetter
extends AbstractParameterSetter {
    private RPLCompiler compiler;
    private Set paramSet;
    private Set constSet;
    private boolean compiled = false;
    private RPLParameter main;
    private boolean finished = false;
    private Map getMethodMap = new HashMap();
    private boolean isRngDynamic = false;

    public void init(String string) throws IOException {
        String string2;
        this.compiler = new RPLCompiler(string);
        this.compiler.preProcess();
        this.paramSet = new HashSet();
        Object object = this.compiler.getParamNames().iterator();
        while (object.hasNext()) {
            string2 = (String)object.next();
            this.paramSet.add(new AbstractParameterSetter.ParamName(string2));
        }
        this.constSet = new HashSet();
        object = this.compiler.getConstNames().iterator();
        while (object.hasNext()) {
            string2 = (String)object.next();
            this.constSet.add(new AbstractParameterSetter.ParamName(string2));
        }
        object = new AbstractParameterSetter.ParamName("RngSeed");
        this.isRngDynamic = !this.constSet.contains(object);
        this.compiler.clearNames();
    }

    public void setModelParameters(SimModel simModel) {
        block5: {
            try {
                if (!this.compiled) {
                    this.compiler.compile(simModel);
                    this.compiled = true;
                    this.main = this.compiler.getMain();
                }
                this.main.setModelParameter(simModel);
            }
            catch (IOException iOException) {
                SimUtilities.showError("Error setting model parameters", iOException);
                if (simModel.getController().getExitOnExit()) {
                    System.exit(0);
                }
            }
            catch (RepastException repastException) {
                SimUtilities.showError("Error setting model parameters", repastException);
                if (!simModel.getController().getExitOnExit()) break block5;
                System.exit(0);
            }
        }
    }

    public void setNextModelParameters(SimModel simModel) {
        block7: {
            try {
                if (!this.compiled) {
                    this.compiler.compile(simModel);
                    this.compiled = true;
                    this.main = this.compiler.getMain();
                } else {
                    this.incrementParameters();
                }
                if (!this.finished) {
                    this.main.setModelParameter(simModel);
                }
            }
            catch (IOException iOException) {
                SimUtilities.showError("Error setting model parameters", iOException);
                if (simModel.getController().getExitOnExit()) {
                    System.exit(0);
                }
            }
            catch (RepastException repastException) {
                SimUtilities.showError("Error setting model parameters", repastException);
                if (!simModel.getController().getExitOnExit()) break block7;
                System.exit(0);
            }
        }
    }

    private void incrementParameters() {
        this.finished = !this.main.next();
    }

    public boolean hasNext() {
        return !this.finished;
    }

    public ArrayList getDynamicParameterNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = this.paramSet.iterator();
        while (object.hasNext()) {
            arrayList.add(this.capitalize(((AbstractParameterSetter.ParamName)object.next()).name));
        }
        object = new AbstractParameterSetter.ParamName("RngSeed");
        if (!this.paramSet.contains(object) && !this.constSet.contains(object)) {
            arrayList.add(((AbstractParameterSetter.ParamName)object).getCapName());
        }
        return arrayList;
    }

    public boolean isParameter(String string) {
        AbstractParameterSetter.ParamName paramName = new AbstractParameterSetter.ParamName(string);
        if (paramName.equals(new AbstractParameterSetter.ParamName("RngSeed"))) {
            return true;
        }
        return this.paramSet.contains(paramName) || this.constSet.contains(paramName);
    }

    public boolean isConstant(String string) {
        AbstractParameterSetter.ParamName paramName = new AbstractParameterSetter.ParamName(string);
        if (paramName.equals(new AbstractParameterSetter.ParamName("RngSeed"))) {
            return !this.isRngDynamic;
        }
        return this.constSet.contains(paramName) && !this.paramSet.contains(paramName);
    }

    public Object getParameterValue(String string, SimModel simModel) {
        Object object;
        block5: {
            object = null;
            try {
                if (!this.compiled) {
                    this.compiler.compile(simModel);
                    this.compiled = true;
                    this.main = this.compiler.getMain();
                }
                object = this.getParameterValue(this.main, string, simModel);
            }
            catch (IOException iOException) {
                SimUtilities.showError("Error getting model parameters", iOException);
                if (simModel.getController().getExitOnExit()) {
                    System.exit(0);
                }
            }
            catch (RepastException repastException) {
                SimUtilities.showError("Error getting model parameters", repastException);
                if (!simModel.getController().getExitOnExit()) break block5;
                System.exit(0);
            }
        }
        return object;
    }

    private Object getParameterValue(RPLParameter rPLParameter, String string, SimModel simModel) throws RepastException {
        Object object = null;
        if (rPLParameter.getName().equalsIgnoreCase(string)) {
            object = rPLParameter.getValue(simModel);
        } else {
            Object object2;
            RPLParameter rPLParameter2;
            Iterator iterator = rPLParameter.parameterIterator();
            while (iterator.hasNext()) {
                rPLParameter2 = (RPLParameter)iterator.next();
                object2 = this.getParameterValue(rPLParameter2, string, simModel);
                if (object2 == null) continue;
                return object2;
            }
            iterator = rPLParameter.constantIterator();
            while (iterator.hasNext()) {
                rPLParameter2 = (RPLParameter)iterator.next();
                object2 = this.getParameterValue(rPLParameter2, string, simModel);
                if (object2 == null) continue;
                return object2;
            }
        }
        return object;
    }

    public Iterator parameterNames() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.paramSet);
        arrayList.addAll(this.constSet);
        return new AbstractParameterSetter.ParamNameIterator(arrayList.iterator());
    }

    public Hashtable getDefaultModelParameters(SimModel simModel) {
        Hashtable<String, Object> hashtable;
        block18: {
            hashtable = new Hashtable<String, Object>();
            try {
                if (!this.compiled) {
                    this.compiler.compile(simModel);
                    this.compiled = true;
                    this.main = this.compiler.getMain();
                }
                String[] stringArray = simModel.getInitParam();
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object;
                    Object object2;
                    String string = stringArray[i];
                    AbstractParameterSetter.ParamName paramName = new AbstractParameterSetter.ParamName(string);
                    if (this.paramSet.contains(paramName) || this.constSet.contains(paramName)) {
                        object2 = this.getParameterValue(string, simModel);
                        if (object2 != null) {
                            hashtable.put(paramName.getCapName(), object2);
                            continue;
                        }
                        object = (Method)this.getMethodMap.get(string.toLowerCase());
                        if (object == null) {
                            this.fillGetMethodMap(simModel, stringArray);
                        }
                        if ((object = (Method)this.getMethodMap.get(string.toLowerCase())) == null) {
                            SimUtilities.showError("Error getting model parameter '" + string + "'", new NullPointerException());
                            if (simModel.getController().getExitOnExit()) {
                                System.exit(0);
                            }
                            return null;
                        }
                        object = (Method)this.getMethodMap.get(string.toLowerCase());
                        Object object3 = ((Method)object).invoke((Object)simModel, new Object[0]);
                        hashtable.put(paramName.getCapName(), object3);
                        continue;
                    }
                    object2 = (Method)this.getMethodMap.get(string.toLowerCase());
                    if (object2 == null) {
                        this.fillGetMethodMap(simModel, stringArray);
                    }
                    if ((object2 = (Method)this.getMethodMap.get(string.toLowerCase())) == null) {
                        SimUtilities.showError("Error getting model parameter '" + string + "'", new NullPointerException());
                        if (simModel.getController().getExitOnExit()) {
                            System.exit(0);
                        }
                        return null;
                    }
                    object = ((Method)object2).invoke((Object)simModel, new Object[0]);
                    hashtable.put(paramName.getCapName(), object);
                }
                AbstractParameterSetter.ParamName paramName = new AbstractParameterSetter.ParamName("RngSeed");
                if (this.paramSet.contains(paramName) || this.constSet.contains(paramName)) {
                    hashtable.put(paramName.getCapName(), this.getParameterValue("RngSeed", simModel));
                } else {
                    hashtable.put("RngSeed", new Long(Random.getSeed()));
                }
            }
            catch (IOException iOException) {
                SimUtilities.showError("Error getting model parameter", iOException);
                if (simModel.getController().getExitOnExit()) {
                    System.exit(0);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                SimUtilities.showError("Error getting model parameters", illegalAccessException);
                if (simModel.getController().getExitOnExit()) {
                    System.exit(0);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                SimUtilities.showError("Error getting model parameters", invocationTargetException);
                if (!simModel.getController().getExitOnExit()) break block18;
                System.exit(0);
            }
        }
        return hashtable;
    }

    private void fillGetMethodMap(SimModel simModel, String[] stringArray) {
        this.getMethodMap.clear();
        Method[] methodArray = simModel.getClass().getMethods();
        int n = methodArray.length;
        block0: for (int i = 0; i < n; ++i) {
            int n2;
            String string;
            Method method = methodArray[i];
            String string2 = method.getName();
            if (string2.startsWith("get") && method.getParameterTypes().length == 0) {
                string = string2.substring(3).toLowerCase();
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    if (!string.equalsIgnoreCase(stringArray[n2])) continue;
                    this.getMethodMap.put(string, method);
                    continue block0;
                }
                continue;
            }
            if (!string2.startsWith("is") || method.getParameterTypes().length != 0 || !method.getReturnType().equals(Boolean.TYPE)) continue;
            string = string2.substring(2).toLowerCase();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (!string.equalsIgnoreCase(stringArray[n2])) continue;
                this.getMethodMap.put(string, method);
                continue block0;
            }
        }
    }
}

