/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter.rpl;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.parameter.rpl.CompilerException;
import uchicago.src.sim.parameter.rpl.JavaClass;
import uchicago.src.sim.parameter.rpl.ParseException;
import uchicago.src.sim.parameter.rpl.RPLDottedName;
import uchicago.src.sim.parameter.rpl.RPLParameter;
import uchicago.src.sim.parameter.rpl.RPLParser;
import uchicago.src.sim.parameter.rpl.SimpleNode;

public class RPLCompiler {
    private Map globalVars = new HashMap();
    private Set paramNames = new HashSet();
    private Set constNames = new HashSet();
    private Map params = new HashMap();
    private SimModel model;
    private JavaClass jcModel;
    private String fileName;
    private RPLParameter main;
    private boolean hasMain = false;
    private SimpleNode root;

    public RPLCompiler(String string) {
        this.fileName = string;
    }

    public void preProcess() throws IOException {
        RPLParser rPLParser = new RPLParser(new BufferedReader(new FileReader(this.fileName)));
        try {
            this.root = rPLParser.compilationUnit();
            this.root.preProcess(this);
            if (!this.hasMain) {
                String string = "File '" + this.fileName + "' does not defined a 'main' block";
                throw this.createCompilerException(string, 0);
            }
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.getMessage());
        }
    }

    public void compile(SimModel simModel) throws IOException {
        this.setModel(simModel);
        if (this.root == null) {
            this.preProcess();
        }
        this.root.compile(this);
    }

    void addGlobalVar(String string, Object object) {
        this.globalVars.put(string, object);
    }

    boolean hasGlobalVariable(String string) {
        return this.globalVars.containsKey(string);
    }

    Object getGlobalVariable(String string) {
        return this.globalVars.get(string);
    }

    void addParameterName(String string) {
        this.paramNames.add(string);
    }

    void addConstantName(String string) {
        this.constNames.add(string);
    }

    boolean hasParameterName(String string) {
        return this.paramNames.contains(string);
    }

    void addParameter(String string, RPLParameter rPLParameter) {
        this.params.put(string, rPLParameter);
    }

    RPLParameter getParameter(String string) {
        return (RPLParameter)this.params.get(string);
    }

    void clearNames() {
        this.paramNames.clear();
        this.constNames.clear();
    }

    boolean isParameter(String string) {
        return this.params.containsKey(string);
    }

    boolean isModelParameter(String string) {
        String[] stringArray = this.model.getInitParam();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return "RngSeed".equalsIgnoreCase(string);
    }

    public void setModel(SimModel simModel) {
        this.model = simModel;
        this.jcModel = new JavaClass(simModel.getClass());
    }

    void setMain(RPLParameter rPLParameter) {
        this.main = rPLParameter;
        Iterator iterator = this.params.values().iterator();
        while (iterator.hasNext()) {
            RPLParameter rPLParameter2 = (RPLParameter)iterator.next();
            if (!this.constNames.contains(rPLParameter2.getName())) continue;
            rPLParameter.addChildConstant(rPLParameter2);
        }
    }

    public RPLParameter getMain() {
        return this.main;
    }

    public Set getParamNames() {
        return new HashSet(this.paramNames);
    }

    public Set getConstNames() {
        return new HashSet(this.constNames);
    }

    void resolveDottedName(RPLDottedName rPLDottedName) {
        String string = rPLDottedName.getLHS();
        String string2 = rPLDottedName.getRHS();
        if (string.equals(this.jcModel.getShortName())) {
            if (!this.jcModel.hasStaticField(string2)) {
                String string3 = "field '" + string2 + "' not found in '" + string + "'";
                throw this.createCompilerException(string3, rPLDottedName.line);
            }
        } else {
            String string4 = "name '" + string + "' is not defined";
            throw this.createCompilerException(string4, rPLDottedName.line);
        }
        rPLDottedName.init(this.jcModel.getStaticFieldType(string2), this.jcModel.getStaticFieldValue(string2));
    }

    public CompilerException createCompilerException(String string, int n) {
        return this.createCompilerException(string, n, null);
    }

    public CompilerException createCompilerException(String string, int n, Exception exception) {
        CompilerException compilerException = exception == null ? new CompilerException(string) : new CompilerException(string, exception);
        compilerException.setFileName(this.fileName);
        compilerException.setLine(n);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fileName));
            int n2 = n - 1;
            for (int i = 0; i < n2; ++i) {
                bufferedReader.readLine();
            }
            compilerException.setCode(bufferedReader.readLine());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return compilerException;
    }

    void setHasMain(boolean bl) {
        this.hasMain = true;
    }
}

