/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter;

import java.util.Vector;
import uchicago.src.sim.engine.ConstIncrementer;
import uchicago.src.sim.engine.Incrementer;
import uchicago.src.sim.engine.ListIncrementer;

public abstract class Parameter {
    public static final int INCREMENT = 0;
    public static final int CONSTANT = 1;
    public static final int LIST = 2;
    private int parameterType;
    protected String name;
    protected Parameter parent;
    protected Vector list;
    protected int listIndex = 0;
    protected Vector subParams = new Vector();
    protected long numRunsIndex = 2L;
    protected long subRuns = -1L;
    protected long numRuns = -1L;
    protected Incrementer incrementer;
    private boolean isInput;

    public void setParent(Parameter parameter) {
        this.parent = parameter;
    }

    public Parameter getParent() {
        return this.parent;
    }

    public void setSubRuns(long l) {
        this.subRuns = l;
    }

    public long getSubRuns() {
        return this.subRuns;
    }

    public void setName(String string) {
        if (string.endsWith("(input)")) {
            string = string.substring(0, string.length() - "(input)".length());
        } else if (string.endsWith("(output)")) {
            string = string.substring(0, string.length() - "(output)".length());
        } else if (string.endsWith("()")) {
            string = string.substring(0, string.length() - "()".length());
        }
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isComplete();

    public void addChild(Parameter parameter) {
        this.subParams.add(parameter);
    }

    public Vector getChildren() {
        return this.subParams;
    }

    public boolean hasChildren() {
        return this.subParams.size() > 0;
    }

    public void removeChild(Parameter parameter) {
        this.subParams.remove(parameter);
    }

    public void setNumRuns(long l) {
        this.numRuns = l;
    }

    public long getNumRuns() {
        return this.numRuns;
    }

    public void setList(Vector vector) {
        this.list = vector;
        this.incrementer = new ListIncrementer(vector);
        this.setParameterType(2);
    }

    public Vector getList() {
        return this.list;
    }

    public void setConstVal(Object object) {
        this.incrementer = new ConstIncrementer(object);
        this.setParameterType(1);
    }

    public String getValAsParameterSet() {
        return this.incrementer.getValAsParameterSet();
    }

    public abstract boolean increment();

    public abstract String getStringValue();

    public abstract Object getValue();

    public boolean isConstant() {
        return this.parameterType == 1;
    }

    public boolean isList() {
        return this.parameterType == 2;
    }

    public boolean isIncrement() {
        return this.parameterType == 0;
    }

    public abstract void setStart(Object var1);

    public abstract void setEnd(Object var1);

    public abstract void setIncr(Object var1);

    public abstract Object getStart();

    public abstract Object getEnd();

    public abstract Object getIncr();

    public boolean isInput() {
        return this.isInput;
    }

    public void setInput(boolean bl) {
        this.isInput = bl;
    }

    public int getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(int n) {
        this.parameterType = n;
    }
}

