/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import java.util.ArrayList;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.network.Node;
import uchicago.src.sim.util.Random;
import uchicago.src.sim.util.RepastException;
import uchicago.src.sim.util.SimUtilities;

public class RandomDensityNet {
    Class nodeClass;
    Class edgeClass;
    int nNodes = -1;
    double density = -1.0;
    boolean loops = false;
    boolean symmetric = false;

    public RandomDensityNet() {
    }

    public RandomDensityNet(Class clazz, Class clazz2) {
        this.nodeClass = clazz;
        this.edgeClass = clazz2;
    }

    public RandomDensityNet(Class clazz, Class clazz2, int n) {
        this.nodeClass = clazz;
        this.edgeClass = clazz2;
        this.nNodes = n;
    }

    public RandomDensityNet(Class clazz, Class clazz2, int n, double d, boolean bl, boolean bl2) {
        this.nodeClass = clazz;
        this.edgeClass = clazz2;
        this.nNodes = n;
        this.density = d;
        this.loops = bl;
        this.symmetric = bl2;
    }

    public Class getNodeClass() {
        return this.nodeClass;
    }

    public void setNodeClass(Class clazz) {
        this.nodeClass = clazz;
    }

    public Class getEdgeClass() {
        return this.edgeClass;
    }

    public void setEdgeClass(Class clazz) {
        this.edgeClass = clazz;
    }

    public int getSize() {
        return this.nNodes;
    }

    public void setSize(int n) {
        this.nNodes = n;
    }

    public double getDensity() {
        return this.density;
    }

    public void setDensity(double d) {
        this.density = d;
    }

    public boolean isAllowLoops() {
        return this.loops;
    }

    public void setAllowLoops(boolean bl) {
        this.loops = bl;
    }

    public boolean isSymmetric() {
        return this.symmetric;
    }

    public void setSymmetric(boolean bl) {
        this.symmetric = bl;
    }

    public ArrayList createRandomDensityNet() throws IllegalAccessException, InstantiationException {
        int n;
        RepastException repastException;
        Object object;
        if (this.nodeClass == null || this.edgeClass == null) {
            object = "Unable to construct randomDensityNetwork: nodeClass or edgeClass was not set.";
            repastException = new RepastException((String)object);
            SimUtilities.showError((String)object, repastException);
        }
        if (this.nNodes < 0 || this.density < 0.0 || this.density > 1.0) {
            object = "Unable to construct randomDensityNetwork: parameter out of range";
            repastException = new RepastException((String)object);
            SimUtilities.showError((String)object, repastException);
        }
        object = new ArrayList(this.nNodes);
        for (n = 0; n < this.nNodes; ++n) {
            ((ArrayList)object).add((Node)this.nodeClass.newInstance());
        }
        if (this.symmetric && !this.loops) {
            for (n = 0; n < this.nNodes; ++n) {
                Node node = (Node)((ArrayList)object).get(n);
                for (int i = n + 1; i < this.nNodes; ++i) {
                    Node node2 = (Node)((ArrayList)object).get(i);
                    if (!(Random.uniform.nextDoubleFromTo(0.0, 1.0) < this.density)) continue;
                    Edge edge = (Edge)this.edgeClass.newInstance();
                    edge.setFrom(node);
                    edge.setTo(node2);
                    Edge edge2 = (Edge)this.edgeClass.newInstance();
                    edge2.setFrom(node2);
                    edge2.setTo(node);
                    node.addOutEdge(edge);
                    node2.addInEdge(edge);
                    node2.addOutEdge(edge2);
                    node.addInEdge(edge2);
                }
            }
        } else if (this.symmetric && this.loops) {
            for (n = 0; n < this.nNodes; ++n) {
                Node node = (Node)((ArrayList)object).get(n);
                for (int i = 0; i < this.nNodes; ++i) {
                    Node node3 = (Node)((ArrayList)object).get(i);
                    if (!(Random.uniform.nextDoubleFromTo(0.0, 1.0) < this.density)) continue;
                    Edge edge = (Edge)this.edgeClass.newInstance();
                    edge.setFrom(node);
                    edge.setTo(node3);
                    Edge edge3 = (Edge)this.edgeClass.newInstance();
                    edge3.setFrom(node3);
                    edge3.setTo(node);
                    node.addOutEdge(edge);
                    node3.addInEdge(edge);
                    node3.addOutEdge(edge3);
                    node.addInEdge(edge3);
                }
            }
        } else if (!this.symmetric && this.loops) {
            for (n = 0; n < this.nNodes; ++n) {
                Node node = (Node)((ArrayList)object).get(n);
                for (int i = 0; i < this.nNodes; ++i) {
                    Node node4 = (Node)((ArrayList)object).get(i);
                    if (!(Random.uniform.nextDoubleFromTo(0.0, 1.0) < this.density)) continue;
                    Edge edge = (Edge)this.edgeClass.newInstance();
                    edge.setFrom(node);
                    edge.setTo(node4);
                    node.addOutEdge(edge);
                    node4.addInEdge(edge);
                }
            }
        } else {
            for (n = 0; n < this.nNodes; ++n) {
                Node node = (Node)((ArrayList)object).get(n);
                for (int i = 0; i < this.nNodes; ++i) {
                    if (n == i) continue;
                    Node node5 = (Node)((ArrayList)object).get(i);
                    if (!(Random.uniform.nextDoubleFromTo(0.0, 1.0) < this.density)) continue;
                    Edge edge = (Edge)this.edgeClass.newInstance();
                    edge.setFrom(node);
                    edge.setTo(node5);
                    node.addOutEdge(edge);
                    node5.addInEdge(edge);
                }
            }
        }
        return object;
    }

    public ArrayList createRandomDensityNet(Class clazz, Class clazz2, int n, double d, boolean bl, boolean bl2) throws IllegalAccessException, InstantiationException {
        this.nodeClass = clazz;
        this.edgeClass = clazz2;
        this.nNodes = n;
        this.density = d;
        this.loops = bl;
        this.symmetric = bl2;
        ArrayList arrayList = this.createRandomDensityNet();
        return arrayList;
    }
}

