/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine;

import java.util.NoSuchElementException;
import uchicago.src.sim.engine.BasicAction;
import uchicago.src.sim.engine.ScheduleGroup;

public class ActionQueue {
    private int maxSize;
    private int origMax;
    private int currentSize = 0;
    private boolean orderOk = true;
    private BasicAction[] array;

    public ActionQueue() {
        this(6);
    }

    public ActionQueue(int n) {
        this.maxSize = n;
        this.origMax = n;
        this.allocateArray(n);
        DummyAction dummyAction = new DummyAction();
        this.array[0] = dummyAction;
    }

    private void checkSize() {
        if (this.currentSize == this.maxSize) {
            BasicAction[] basicActionArray = this.array;
            this.allocateArray(this.maxSize * 2);
            System.arraycopy(basicActionArray, 0, this.array, 0, basicActionArray.length);
            basicActionArray = null;
            this.maxSize *= 2;
        }
    }

    private void percolateDown(int n) {
        if (this.currentSize > 0) {
            BasicAction basicAction = this.array[n];
            while (n * 2 <= this.currentSize) {
                int n2 = n * 2;
                if (n2 != this.currentSize && this.array[n2 + 1].nextTime < this.array[n2].nextTime) {
                    ++n2;
                }
                if (!(this.array[n2].nextTime < basicAction.nextTime)) break;
                this.array[n] = this.array[n2];
                n = n2;
            }
            this.array[n] = basicAction;
        }
    }

    public boolean voidAction(BasicAction basicAction) {
        boolean bl = false;
        int n = this.array.length;
        for (int i = 0; i < n; ++i) {
            if (!basicAction.equals(this.array[i])) continue;
            this.array[i] = new EmptyAction(basicAction.nextTime);
            bl = true;
        }
        return bl;
    }

    public void insert(BasicAction basicAction) {
        if (!this.orderOk) {
            this.toss(basicAction);
            return;
        }
        this.checkSize();
        int n = ++this.currentSize;
        if (n != 1) {
            while (basicAction.nextTime < this.array[n / 2].nextTime) {
                this.array[n] = this.array[n / 2];
                n /= 2;
            }
        }
        this.array[n] = basicAction;
    }

    public BasicAction peekMin() {
        if (this.currentSize == 0) {
            throw new NoSuchElementException("Queue is Empty");
        }
        if (!this.orderOk) {
            this.fixHeap();
        }
        return this.array[1];
    }

    public BasicAction popMin() {
        BasicAction basicAction = this.peekMin();
        this.array[1] = this.array[this.currentSize--];
        this.percolateDown(1);
        return basicAction;
    }

    public void toss(BasicAction basicAction) {
        this.checkSize();
        this.array[++this.currentSize] = basicAction;
        if (this.currentSize != 1 && basicAction.nextTime < this.array[this.currentSize / 2].nextTime) {
            this.orderOk = false;
        }
    }

    public void clear() {
        this.currentSize = 0;
        this.orderOk = true;
        this.allocateArray(this.origMax);
        this.maxSize = this.origMax;
        DummyAction dummyAction = new DummyAction();
        this.array[0] = dummyAction;
    }

    public void fixHeap() {
        for (int i = this.currentSize / 2; i > 0; --i) {
            this.percolateDown(i);
        }
        this.orderOk = true;
    }

    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    public int size() {
        return this.currentSize;
    }

    private void allocateArray(int n) {
        this.array = new BasicAction[n + 1];
    }

    public String toString() {
        return super.toString() + ", size: " + this.currentSize;
    }

    static class DummyAction
    extends BasicAction {
        DummyAction() {
            this.nextTime = Double.NEGATIVE_INFINITY;
        }

        public void execute() {
        }
    }

    static class EmptyAction
    extends BasicAction {
        EmptyAction(double d) {
            this.nextTime = d;
            this.setUpdater(2);
        }

        public void execute() {
        }

        public void addToGroup(ScheduleGroup scheduleGroup) {
        }
    }
}

