/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.awt.Color;
import uchicago.src.sim.analysis.plot.OpenGraph;
import uchicago.src.sim.engine.SimModel;

public class Plot
extends OpenGraph {
    public Plot(String string) {
        super(string);
        this.plot.setMarksStyle("dots");
        this.plot.setDrawOnAddPoint(false);
        this.setXRange(0.0, 100.0);
        this.setYRange(0.0, 100.0);
    }

    public Plot(String string, SimModel simModel) {
        this(string);
        this.model = simModel;
    }

    public void setConnected(boolean bl) {
        this.plot.setConnected(bl);
    }

    public void setConnected(boolean bl, int n) {
        this.plot.setConnected(bl, n);
    }

    public void plotPoint(double d, double d2, int n) {
        this.plot.addPoint(n, d, d2, this.plot.getConnected());
    }

    public void record() {
    }

    public void updateGraph() {
        this.plot.repaint();
    }

    public void clear(int n) {
        this.plot.clear(n);
        this.plot.repaint();
    }

    public void addLegend(int n, String string) {
        this.plot.addLegend(n, string);
    }

    public void addLegend(int n, String string, Color color) {
        this.plot.addLegend(n, string, color);
    }

    public void addLegend(int n, String string, int n2) {
        this.plot.addLegend(n, string, n2);
    }

    public void addLegend(int n, String string, Color color, int n2) {
        this.plot.addLegend(n, string, color, n2);
    }

    public void fillPlot() {
        this.plot.fillPlot();
    }

    public void addString(String string) {
        this.plot.addDetailString(string);
    }

    public void clearStrings() {
        this.plot.clearDetailStrings();
    }

    public static void main(String[] stringArray) {
        try {
            Plot plot = new Plot("Test Plot");
            plot.display();
            plot.setConnected(true);
            for (double d = 0.0; d < 100.0; d += 1.0) {
                plot.plotPoint(d, Math.sin(d), 0);
            }
            plot.updateGraph();
            plot.fillPlot();
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            plot.plotPoint(3.0, 4.0, 1);
            plot.plotPoint(5.0, 1.4, 1);
            plot.fillPlot();
            plot.addString("hello");
        }
        catch (Exception exception) {
            System.exit(0);
        }
    }
}

