/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.collection;

import cern.colt.map.OpenIntObjectHashMap;
import uchicago.src.collection.BaseMatrix;

public class SparseObjectMatrix
implements BaseMatrix {
    private int sizeX;
    private int sizeY;
    private OpenIntObjectHashMap elements;

    public SparseObjectMatrix(int n, int n2) {
        this.sizeX = n;
        this.sizeY = n2;
        this.elements = new OpenIntObjectHashMap();
    }

    public Object get(int n, int n2) {
        return this.elements.get(n2 * this.sizeX + n);
    }

    public void put(int n, int n2, Object object) {
        this.elements.put(n2 * this.sizeX + n, object);
    }

    public Object remove(int n, int n2) {
        int n3 = n2 * this.sizeX + n;
        Object object = this.elements.get(n3);
        this.elements.put(n3, null);
        return object;
    }

    public int elementSize() {
        return this.elements.size();
    }

    public int size() {
        return this.sizeY * this.sizeX;
    }

    public int getNumRows() {
        return this.sizeY;
    }

    public int getNumCols() {
        return this.sizeX;
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    public void trim() {
        this.trimToSize();
    }
}

