/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.Task;
import logist.topology.Topology;
import template.Action;

public class Solution
implements Cloneable {
    public HashMap<Vehicle, Action> nextActionVehicle;
    public HashMap<Action, Action> nextAction;
    List<Vehicle> vehicles;

    public Solution(List<Vehicle> vehicles) {
        this.vehicles = vehicles;
        this.nextActionVehicle = new HashMap();
        this.nextAction = new HashMap();
        for (Vehicle v : vehicles) {
            this.nextActionVehicle.put(v, null);
        }
    }

    public Solution clone() {
        Solution c = new Solution(this.vehicles);
        c.nextActionVehicle = new HashMap<Vehicle, Action>(this.nextActionVehicle);
        c.nextAction = new HashMap<Action, Action>(this.nextAction);
        return c;
    }

    public boolean containsTask(Task t) {
        for (Vehicle v : this.vehicles) {
            Action a = this.nextActionVehicle.get(v);
            while (a != null) {
                if (a.task.equals(t)) {
                    return true;
                }
                a = this.nextAction.get(a);
            }
        }
        return false;
    }

    public boolean isValid() {
        HashMap<Task, Integer> pickups = new HashMap<Task, Integer>();
        HashMap<Task, Integer> deliveries = new HashMap<Task, Integer>();
        for (Vehicle v : this.vehicles) {
            Action a = this.nextActionVehicle.get(v);
            while (a != null) {
                if (a.pickup) {
                    pickups.put(a.task, pickups.getOrDefault(a.task, 0) + 1);
                } else {
                    deliveries.put(a.task, deliveries.getOrDefault(a.task, 0) + 1);
                }
                a = this.nextAction.get(a);
            }
        }
        for (Task t : pickups.keySet()) {
            int p = (Integer)pickups.get(t);
            int d = deliveries.getOrDefault(t, 0);
            if (p == 1 && d == 1) continue;
            System.out.println("[Solution.isValid] Task " + t.id + " invalid counts: p=" + p + " d=" + d);
            return false;
        }
        for (Task t : deliveries.keySet()) {
            if (pickups.containsKey(t)) continue;
            System.out.println("[Solution.isValid] Task " + t.id + " delivered but not picked up.");
            return false;
        }
        return true;
    }

    public void addTask(Task t, Random rn) {
        System.out.println("[Solution.addTask] Adding task " + t.id);
        Vehicle chosen = null;
        double bestCost = Double.MAX_VALUE;
        for (Vehicle v : this.vehicles) {
            double cost;
            if (v.capacity() < t.weight || !((cost = this.insertionCost(v, t)) < bestCost)) continue;
            bestCost = cost;
            chosen = v;
        }
        if (chosen == null) {
            System.out.println("[Solution.addTask] No suitable vehicle found for task " + t.id);
            return;
        }
        Action.Pickup pick = new Action.Pickup(t);
        Action.Delivery del = new Action.Delivery(t);
        Action oldFirst = this.nextActionVehicle.get(chosen);
        this.nextActionVehicle.put(chosen, pick);
        this.nextAction.put(pick, del);
        this.nextAction.put(del, oldFirst);
        System.out.println("[Solution.addTask] Task " + t.id + " added to vehicle " + chosen.id());
    }

    private double insertionCost(Vehicle v, Task t) {
        Topology.City current = v.getCurrentCity();
        if (current == null) {
            System.out.println("[Solution.insertionCost] v.getCurrentCity() is null, using homeCity");
            current = v.homeCity();
        }
        double cost = current.distanceTo(t.pickupCity) * (double)v.costPerKm();
        return cost += t.pickupCity.distanceTo(t.deliveryCity) * (double)v.costPerKm();
    }

    public double totalCost(List<Vehicle> vs) {
        double total = 0.0;
        for (Vehicle v : vs) {
            double dist = this.computeDistance(v);
            total += dist * (double)v.costPerKm();
        }
        return total;
    }

    private double computeDistance(Vehicle v) {
        double dist = 0.0;
        Action a = this.nextActionVehicle.get(v);
        Topology.City current = v.getCurrentCity();
        if (current == null) {
            System.out.println("[Solution.computeDistance] v.getCurrentCity() is null, using homeCity");
            current = v.homeCity();
        }
        while (a != null) {
            dist += current.distanceTo(a.city);
            current = a.city;
            a = this.nextAction.get(a);
        }
        return dist;
    }

    public List<Solution> chooseNeighbors(Random rn) {
        ArrayList<Solution> neighbors = new ArrayList<Solution>();
        for (Vehicle v_i : this.vehicles) {
            Action a = this.nextActionVehicle.get(v_i);
            if (a == null || !a.pickup) continue;
            Task t = a.task;
            for (Vehicle v_j : this.vehicles) {
                Solution neigh;
                if (v_j == v_i || v_j.capacity() < t.weight || (neigh = this.changeVehicle(t, v_i, v_j)) == null) continue;
                neighbors.add(neigh);
            }
            List<Solution> orderNeigh = this.changeTaskOrder(v_i, t, rn);
            neighbors.addAll(orderNeigh);
        }
        return neighbors;
    }

    private Solution changeVehicle(Task t, Vehicle v_i, Vehicle v_j) {
        Solution sol = this.clone();
        Action pickup = null;
        Action delivery = null;
        Action a = sol.nextActionVehicle.get(v_i);
        while (a != null) {
            if (a.pickup && a.task.equals(t)) {
                pickup = a;
            }
            if (!a.pickup && a.task.equals(t)) {
                delivery = a;
            }
            a = sol.nextAction.get(a);
        }
        if (pickup == null || delivery == null) {
            return null;
        }
        Action afterDelivery = sol.nextAction.get(delivery);
        Action prePickup = sol.getPrevAction(v_i, pickup);
        Action preDelivery = sol.getPrevAction(v_i, delivery);
        if (prePickup == null) {
            sol.nextActionVehicle.put(v_i, afterDelivery);
        } else {
            sol.nextAction.put(prePickup, afterDelivery);
        }
        if (preDelivery != null && preDelivery != pickup) {
            sol.nextAction.put(preDelivery, afterDelivery);
        }
        Action oldFirst = sol.nextActionVehicle.get(v_j);
        Action.Pickup newPick = new Action.Pickup(t);
        Action.Delivery newDel = new Action.Delivery(t);
        sol.nextActionVehicle.put(v_j, newPick);
        sol.nextAction.put(newPick, newDel);
        sol.nextAction.put(newDel, oldFirst);
        return sol.isValid() ? sol : null;
    }

    private List<Solution> changeTaskOrder(Vehicle v_i, Task t, Random rn) {
        ArrayList<Solution> neighbors = new ArrayList<Solution>();
        List<Action> seq = this.getSequence(v_i);
        if (seq.size() < 2) {
            return neighbors;
        }
        for (int i = 0; i < Math.min(2, seq.size() - 1); ++i) {
            Solution sol;
            int idx2;
            int idx1 = rn.nextInt(seq.size());
            if (idx1 == (idx2 = rn.nextInt(seq.size())) || !(sol = this.clone()).swapActions(v_i, idx1, idx2) || !sol.isValid()) continue;
            neighbors.add(sol);
        }
        return neighbors;
    }

    private boolean swapActions(Vehicle v, int idx1, int idx2) {
        List<Action> seq = this.getSequence(v);
        if (idx1 >= seq.size() || idx2 >= seq.size()) {
            return false;
        }
        Action a1 = seq.get(idx1);
        Action a2 = seq.get(idx2);
        seq.set(idx1, a2);
        seq.set(idx2, a1);
        if (!this.checkWeightConstraint(v, seq)) {
            return false;
        }
        this.updateSequence(v, seq);
        return true;
    }

    private boolean checkWeightConstraint(Vehicle v, List<Action> seq) {
        int capacity = v.capacity();
        for (Action A : seq) {
            if ((capacity += A.capacity) >= 0) continue;
            return false;
        }
        return true;
    }

    private void updateSequence(Vehicle v, List<Action> seq) {
        if (seq.isEmpty()) {
            this.nextActionVehicle.put(v, null);
            return;
        }
        this.nextActionVehicle.put(v, seq.get(0));
        for (int i = 0; i < seq.size() - 1; ++i) {
            this.nextAction.put(seq.get(i), seq.get(i + 1));
        }
        this.nextAction.put(seq.get(seq.size() - 1), null);
    }

    private List<Action> getSequence(Vehicle v) {
        ArrayList<Action> res = new ArrayList<Action>();
        Action a = this.nextActionVehicle.get(v);
        while (a != null) {
            res.add(a);
            a = this.nextAction.get(a);
        }
        return res;
    }

    public Action getPrevAction(Vehicle v, Action A) {
        Action curr = this.nextActionVehicle.get(v);
        Action prev = null;
        while (curr != null && curr != A) {
            prev = curr;
            curr = this.nextAction.get(curr);
        }
        return prev;
    }

    public List<Plan> getPlans(List<Vehicle> vehicles) {
        ArrayList<Plan> plans = new ArrayList<Plan>();
        for (Vehicle v : vehicles) {
            plans.add(this.buildPlan(v));
        }
        return plans;
    }

    private Plan buildPlan(Vehicle v) {
        Plan plan = new Plan(v.getCurrentCity(), new logist.plan.Action[0]);
        Action a = this.nextActionVehicle.get(v);
        Topology.City current = v.getCurrentCity();
        if (current == null) {
            System.out.println("[Solution.buildPlan] v.getCurrentCity() is null in final plan, using homeCity");
            current = v.homeCity();
            plan = new Plan(current, new logist.plan.Action[0]);
        }
        ArrayList<Task> carried = new ArrayList<Task>();
        while (a != null) {
            for (Topology.City city : current.pathTo(a.city)) {
                plan.appendMove(city);
            }
            current = a.city;
            if (a.pickup) {
                plan.appendPickup(a.task);
                carried.add(a.task);
            } else {
                if (!carried.contains(a.task)) {
                    System.out.println("[Solution.buildPlan] ERROR: delivering task " + a.task.id + " without having picked it up!");
                }
                plan.appendDelivery(a.task);
                carried.remove(a.task);
            }
            a = this.nextAction.get(a);
        }
        return plan;
    }
}

