/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcDemon;
import ilog.solver.IlcIterator;
import ilog.solver.IlcPIntAbstractVar;
import ilog.solver.IlcPIntCollectionVarInterface;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverRuntimeError;
import ilog.solver.ar;
import ilog.solver.b;
import ilog.solver.bz;
import ilog.solver.cy;
import ilog.solver.ebb;
import ilog.solver.et;
import ilog.solver.ho;
import ilog.solver.hp;
import ilog.solver.iu;
import ilog.solver.jq;
import ilog.solver.kb;
import ilog.solver.kf;
import ilog.solver.kl;
import ilog.solver.mf;
import ilog.solver.nm;
import ilog.solver.nt;
import ilog.solver.oe;
import ilog.solver.pz;
import ilog.solver.qj;
import ilog.solver.si;
import ilog.solver.ud;
import ilog.solver.ur;
import ilog.solver.yi;
import ilog.solver.yu;
import ilog.solver.yw;
import ilog.solver.zb;
import ilog.solver.zg;
import ilog.solver.zt;
import java.util.NoSuchElementException;

abstract class ys
extends nm
implements IlcPIntCollectionVarInterface {
    ys() {
    }

    public final boolean isDomainRequired(int n2) {
        return this.isBound() && this.isInDomain(n2);
    }

    public final void addDomainRequired(int n2) {
        this.setDomainValue(n2);
    }

    public IlcIterator getDomainRequiredIterator() {
        return new mi(this);
    }

    public double getDomainLB() {
        return this.getDomainMin();
    }

    public double getDomainUB() {
        return this.getDomainMax();
    }

    public void setDomainLB(double d2) {
        double d3 = Math.ceil(d2);
        if (d3 >= -2.147483647E9) {
            if (d3 > 2.147483647E9) {
                this.getSolver().fail();
            }
            this.setDomainMin((int)d3);
        }
    }

    public void setDomainUB(double d2) {
        double d3 = Math.floor(d2);
        if (d3 <= 2.147483647E9) {
            if (d3 < -2.147483647E9) {
                this.getSolver().fail();
            }
            this.setDomainMax((int)d3);
        }
    }

    public void setDomainRange(double d2, double d3) {
        this.setDomainLB(d2);
        this.setDomainUB(d3);
    }

    abstract boolean gr();

    public final void setDomainMinLong(long l2) {
        if (l2 >= -2147483647L) {
            if (l2 > Integer.MAX_VALUE) {
                this.getSolver().fail();
            }
            this.setDomainMin((int)l2);
        }
    }

    public final void setDomainMaxLong(long l2) {
        if (l2 <= Integer.MAX_VALUE) {
            if (l2 < -2147483647L) {
                this.getSolver().fail();
            }
            this.setDomainMax((int)l2);
        }
    }

    public final void setDomainRangeLong(long l2, long l3) {
        this.setDomainMinLong(l2);
        this.setDomainMaxLong(l3);
    }

    public final void removeDomainValueLong(long l2) {
        if (-2147483647L <= l2 && l2 <= Integer.MAX_VALUE) {
            this.removeDomainValue((int)l2);
        }
    }

    public final boolean isInDomainLong(long l2) {
        if (-2147483647L <= l2 && l2 <= Integer.MAX_VALUE) {
            return this.isInDomain((int)l2);
        }
        return false;
    }

    public final void removeDomainIntervalLong(long l2, long l3) {
        if (l2 > l3) {
            return;
        }
        if (-2147483647L <= l2 && l3 <= Integer.MAX_VALUE) {
            this.removeDomainInterval((int)l2, (int)l3);
        } else if (-2147483647L < l2 && l2 <= Integer.MAX_VALUE) {
            this.setDomainMaxLong(l2 - 1L);
        } else if (-2147483647L <= l3 && l3 < Integer.MAX_VALUE) {
            this.setDomainMinLong(l3 + 1L);
        } else {
            this.getSolver().fail();
        }
    }

    public static final int safeCastLong(long l2) {
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l2 < -2147483647L) {
            return -2147483647;
        }
        return (int)l2;
    }

    public static final int safeCastPosLong(long l2) {
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    public static final boolean isSafe(long l2) {
        return -2147483647L <= l2 && l2 <= Integer.MAX_VALUE;
    }

    public final boolean holesOK() {
        return !this.jn() || this.getDomainSize() <= 819200;
    }

    public final int getDomainValue() throws IlcSolverRuntimeError {
        int n2 = this.getDomainMin();
        if (n2 != this.getDomainMax()) {
            throw new IlcSolverRuntimeError.ExpressionNotBound();
        }
        return n2;
    }

    abstract boolean jn();

    abstract void kn();

    public abstract IlcSolver getSolver();

    public abstract int getDomainSize();

    public abstract int getNbOfConstraints();

    public abstract boolean isBound();

    public abstract int getDomainMin();

    public abstract int getDomainMax();

    public abstract boolean isInDomain(int var1);

    public abstract void setDomainMin(int var1);

    public abstract void setDomainMax(int var1);

    public abstract void setDomainRange(int var1, int var2);

    public final void setDomainValue(int n2) {
        this.setDomainRange(n2, n2);
    }

    public abstract void removeDomainValue(int var1);

    public abstract void removeDomainInterval(int var1, int var2);

    public abstract void whenValue(IlcDemon var1);

    public abstract void whenRange(IlcDemon var1);

    public abstract void whenDomain(IlcDemon var1);

    protected abstract void isUsed(nm var1);

    public int getNextHigher(int n2) {
        int n3 = this.getDomainMax();
        if (n2 >= n3) {
            return n2;
        }
        int n4 = this.getDomainMin();
        if (n2 < n4) {
            return n4;
        }
        int n5 = n2 + 1;
        while (!this.isInDomain(n5)) {
            ++n5;
        }
        return n5;
    }

    public int getNextLower(int n2) {
        int n3 = this.getDomainMin();
        if (n2 <= n3) {
            return n2;
        }
        int n4 = this.getDomainMax();
        if (n2 > n4) {
            return n4;
        }
        int n5 = n2 - 1;
        while (!this.isInDomain(n5)) {
            --n5;
        }
        return n5;
    }

    public IlcIterator domainIterator() {
        this.getSolver();
        if (this.getDomainMin() <= -2147483647) {
            return new lq();
        }
        return new ey();
    }

    public abstract IlcIterator removedIterator();

    public abstract IlcIterator deltaIterator();

    public final ys abs() {
        if (this.getDomainMin() >= 0) {
            return this;
        }
        if (this.getDomainMax() <= 0) {
            return this.negate();
        }
        return new zb(this);
    }

    public final ys add(ys ys2) {
        if (ys2 == this) {
            return this.multiply(2);
        }
        if (ys2.isBound()) {
            return this.add(ys2.getDomainMin());
        }
        if (this.isBound()) {
            return ys2.add(this.getDomainMin());
        }
        return new zt(this, ys2);
    }

    public final ys add(int n2) {
        if (n2 == 0) {
            return this;
        }
        return new ud(this, n2);
    }

    public final ys div(int n2) {
        if (n2 > 1) {
            return new zg(this, n2);
        }
        if (n2 < -1) {
            return new iu(this, n2);
        }
        if (n2 == 1) {
            return this;
        }
        if (n2 == -1) {
            return this.negate();
        }
        throw new ArithmeticException("Division by 0 " + this);
    }

    public final ys div(ys ys2) {
        if (ys2.isBound()) {
            return this.div(ys2.getDomainMin());
        }
        return new ar(this, ys2);
    }

    public final ys max(ys ys2) {
        if (ys2.isBound()) {
            return this.max(ys2.getDomainMin());
        }
        if (this.isBound()) {
            return ys2.max(this.getDomainMin());
        }
        if (this.getDomainMax() <= ys2.getDomainMin()) {
            return ys2;
        }
        if (ys2.getDomainMax() <= this.getDomainMin()) {
            return this;
        }
        return new bz(this, ys2);
    }

    public final ys max(int n2) {
        if (this.getDomainMax() <= n2) {
            return IlcPIntAbstractVar.intConst(this.getSolver(), n2);
        }
        if (this.getDomainMin() >= n2) {
            return this;
        }
        return new si(this, n2);
    }

    public final ys min(ys ys2) {
        if (ys2.isBound()) {
            return this.min(ys2.getDomainMin());
        }
        if (this.isBound()) {
            return ys2.min(this.getDomainMin());
        }
        if (this.getDomainMax() <= ys2.getDomainMin()) {
            return this;
        }
        if (ys2.getDomainMax() <= this.getDomainMin()) {
            return ys2;
        }
        return new yw(this, ys2);
    }

    public final ys min(int n2) {
        if (this.getDomainMax() <= n2) {
            return this;
        }
        if (this.getDomainMin() >= n2) {
            return IlcPIntAbstractVar.intConst(this.getSolver(), n2);
        }
        return new ebb(this, n2);
    }

    public final ys multiply(int n2) {
        if (n2 == 1) {
            return this;
        }
        if (n2 > 0) {
            return new cy(n2, this);
        }
        if (n2 == 0) {
            return IlcPIntAbstractVar.intConst(this.getSolver(), 0);
        }
        if (n2 == -1) {
            return this.negate();
        }
        return new ur(n2, this);
    }

    public final ys multiply(ys ys2) {
        if (ys2 == this) {
            return this.square();
        }
        if (ys2.isBound()) {
            return this.multiply(ys2.getDomainMin());
        }
        if (this.isBound()) {
            return ys2.multiply(this.getDomainMin());
        }
        if (this.getDomainMin() >= 0 && ys2.getDomainMin() >= 0) {
            if (this.getDomainMax() <= 1 && ys2.getDomainMax() <= 1) {
                return new hp(this, ys2);
            }
            return new pz(this, ys2);
        }
        return new mf(this, ys2);
    }

    public final ys negate() {
        return new yi(this);
    }

    public final ys square() {
        int n2 = this.getDomainMin();
        int n3 = this.getDomainMax();
        if (0 <= n2 && n2 <= 1 && 0 <= n3 && n3 <= 1) {
            return this;
        }
        return new b(this);
    }

    public final ys substract(ys ys2) {
        if (ys2.isBound()) {
            return this.substract(ys2.getDomainMin());
        }
        return new oe(this, ys2);
    }

    public final ys substract(int n2) {
        return this.add(-n2);
    }

    public static int max(int[] nArray) {
        int n2 = Integer.MIN_VALUE;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray[n4];
            if (n2 < n5) {
                n2 = n5;
            }
            ++n4;
        }
        return n2;
    }

    public static int min(int[] nArray) {
        int n2 = Integer.MAX_VALUE;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray[n4];
            if (n2 > n5) {
                n2 = n5;
            }
            ++n4;
        }
        return n2;
    }

    public static ys max(ys[] ysArray) throws IlcSolverRuntimeError {
        if (ysArray.length == 0) {
            throw new IlcSolverRuntimeError.EmptyArray();
        }
        if (ysArray.length == 1) {
            return ysArray[0];
        }
        if (ysArray.length == 2) {
            return ysArray[0].max(ysArray[1]);
        }
        return new qj(ysArray);
    }

    public static ys min(ys[] ysArray) throws IlcSolverRuntimeError {
        if (ysArray.length == 0) {
            throw new IlcSolverRuntimeError.EmptyArray();
        }
        if (ysArray.length == 1) {
            return ysArray[0];
        }
        if (ysArray.length == 2) {
            return ysArray[0].min(ysArray[1]);
        }
        return new ho(ysArray);
    }

    public static int scalProd(int[] nArray, int[] nArray2) throws IlcSolverRuntimeError {
        int n2 = nArray.length;
        if (nArray2.length != n2) {
            throw new IlcSolverRuntimeError.BadSizeArray();
        }
        long l2 = 0L;
        int n3 = 0;
        while (n3 < n2) {
            l2 += (long)nArray[n3] * (long)nArray2[n3];
            ++n3;
        }
        return ys.safeCastLong(l2);
    }

    public static ys scalProd(ys[] ysArray, int[] nArray) throws IlcSolverRuntimeError {
        return ys.scalProd(nArray, ysArray);
    }

    public static ys scalProd(int[] nArray, ys[] ysArray) throws IlcSolverRuntimeError {
        int n2 = nArray.length;
        int n3 = ysArray.length;
        if (n2 != n3) {
            throw new IlcSolverRuntimeError.BadSizeArray();
        }
        if (n3 == 0) {
            throw new IlcSolverRuntimeError.EmptyArray();
        }
        int n4 = 0;
        while (n4 < n3) {
            if (nArray[n4] == 0) {
                --n2;
            }
            ++n4;
        }
        if (n2 == 0) {
            return IlcPIntAbstractVar.intConst(ysArray[0].getSolver(), 0);
        }
        ys[] ysArray2 = new ys[n2];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            if (nArray[n6] != 0) {
                ysArray2[n5] = ysArray[n6].multiply(nArray[n6]);
                ++n5;
            }
            ++n6;
        }
        return ys.sum(ysArray2);
    }

    public static ys scalProd(ys[] ysArray, ys[] ysArray2) throws IlcSolverRuntimeError {
        int n2 = ysArray2.length;
        int n3 = ysArray.length;
        if (n2 != n3) {
            throw new IlcSolverRuntimeError.BadSizeArray();
        }
        if (n3 == 0) {
            throw new IlcSolverRuntimeError.EmptyArray();
        }
        ys[] ysArray3 = new ys[n2];
        int n4 = 0;
        while (n4 < n3) {
            ysArray3[n4] = ysArray[n4].multiply(ysArray2[n4]);
            ++n4;
        }
        return ys.sum(ysArray3);
    }

    public static int sum(int[] nArray) {
        int n2 = nArray.length;
        long l2 = 0L;
        int n3 = 0;
        while (n3 < n2) {
            l2 += (long)nArray[n3];
            ++n3;
        }
        return ys.safeCastLong(l2);
    }

    public static ys sum(ys[] ysArray) throws IlcSolverRuntimeError {
        return ys.sum(ysArray, 0, ysArray.length);
    }

    public static ys sum(ys[] ysArray, int n2, int n3) throws IlcSolverRuntimeError {
        int n4 = n3 - n2;
        if (n4 == 0) {
            throw new IlcSolverRuntimeError.oj("Trying to get the sum of an empty array");
        }
        ys[] ysArray2 = ysArray;
        while (n4 > 20) {
            int n5 = (n4 - 1) / 20 + 1;
            nt[] ntArray = new nt[n5];
            int n6 = 0;
            while (n6 < n5 - 1) {
                ntArray[n6] = new nt(ysArray2, n2, n2 + 20);
                n2 += 20;
                ++n6;
            }
            ntArray[n5 - 1] = new nt(ysArray2, n2, n3);
            ysArray2 = ntArray;
            n3 = n5;
            n4 = n5;
            n2 = 0;
        }
        if (n4 == 1) {
            return ysArray2[n2];
        }
        if (n4 == 2) {
            return ysArray2[n2].add(ysArray2[n2 + 1]);
        }
        return new nt(ysArray2, n2, n3);
    }

    static final void hr(ys ys2) {
        ys2.kn();
    }

    static final void ir(ys[] ysArray) {
        int n2 = ysArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ysArray[n3].kn();
            ++n3;
        }
    }

    public final IlcPPropagator eq(ys ys2) {
        if (ys2 == this) {
            return new kf(this.getSolver());
        }
        if (this.isBound()) {
            return ys2.eq(this.getDomainValue());
        }
        if (ys2.isBound()) {
            return this.eq(ys2.getDomainValue());
        }
        return new kb.sh(this, ys2);
    }

    public final IlcPPropagator eq(int n2) {
        return new et.ej(this, n2);
    }

    public final IlcPPropagator neq(ys ys2) {
        if (ys2 == this) {
            return new kl(this.getSolver());
        }
        if (this.isBound()) {
            return ys2.neq(this.getDomainValue());
        }
        if (ys2.isBound()) {
            return this.neq(ys2.getDomainValue());
        }
        return new yu.vl(this, ys2);
    }

    public final IlcPPropagator neq(int n2) {
        return new jq.uab(this, n2);
    }

    public boolean isNaN() {
        return false;
    }

    public boolean in() {
        return false;
    }

    public double getBoundCastDownMid() {
        double d2 = (this.getDomainLB() + this.getDomainUB()) / 2.0;
        if (Math.floor(d2) == d2) {
            return d2 - 0.5;
        }
        return d2;
    }

    public double boundCastDown(double d2) {
        return Math.floor(d2);
    }

    public double boundCastUp(double d2) {
        return Math.ceil(d2);
    }

    public double boundNextDown(double d2) {
        double d3 = Math.floor(d2);
        if (d2 == d3) {
            return d2 - 1.0;
        }
        return d3;
    }

    public double boundNextUp(double d2) {
        double d3 = Math.ceil(d2);
        if (d2 == d3) {
            return d2 + 1.0;
        }
        return d3;
    }

    public double propagationCastDown(double d2) {
        return Math.floor(d2);
    }

    public double propagationCastUp(double d2) {
        return Math.ceil(d2);
    }

    public double propagationNextDown(double d2) {
        double d3 = Math.floor(d2);
        if (d2 == d3) {
            return d2 - 1.0;
        }
        return d3;
    }

    public double propagationNextUp(double d2) {
        double d3 = Math.ceil(d2);
        if (d2 == d3) {
            return d2 + 1.0;
        }
        return d3;
    }

    public void setPrecision(int n2, int n3, int n4) {
        throw new IlcSolverRuntimeError.hbb("Cannot set Precision on IlcPIntExp.");
    }

    public int getRelativePrecision() {
        throw new IlcSolverRuntimeError.hbb("Cannot get Precision of IlcPIntExp.");
    }

    public int getAbsolutePrecision() {
        throw new IlcSolverRuntimeError.hbb("Cannot get Precision of IlcPIntExp.");
    }

    public int getGuardDigits() {
        throw new IlcSolverRuntimeError.hbb("Cannot get Guard Digits of IlcPIntExp.");
    }

    private final class ey
    extends IlcIterator {
        private int zyb;

        ey() {
            this.zyb = ys.this.getDomainMin() - 1;
        }

        public boolean hasNext() {
            return this.zyb < ys.this.getDomainMax();
        }

        public int nextValue() {
            int n2 = this.zyb;
            this.zyb = ys.this.getNextHigher(n2);
            if (n2 != this.zyb) {
                return this.zyb;
            }
            throw new NoSuchElementException("No more value for " + ys.this.toString());
        }

        public void remove() {
            if (!ys.this.isInDomain(this.zyb)) {
                throw new IllegalStateException("Trying to remove " + this.zyb + " from " + ys.this.toString());
            }
            ys.this.removeDomainValue(this.zyb);
        }
    }

    private final class lq
    extends IlcIterator {
        int uib;
        int vib;
        boolean wib;

        lq() {
            this.vib = ys.this.getDomainMin();
            this.wib = true;
        }

        public boolean hasNext() {
            return this.wib;
        }

        public int nextValue() {
            this.uib = this.vib;
            if (this.wib) {
                this.vib = ys.this.getNextHigher(this.uib);
                this.wib = this.vib != this.uib;
                return this.uib;
            }
            throw new NoSuchElementException("No more value for " + ys.this.toString());
        }

        public void remove() {
            if (!ys.this.isInDomain(this.uib)) {
                throw new IllegalStateException("Trying to remove " + this.uib + " from " + ys.this.toString());
            }
            ys.this.removeDomainValue(this.uib);
        }
    }

    static final class mi
    extends IlcIterator {
        ys yr;
        int zr;

        mi(ys ys2) {
            this.yr = ys2;
        }

        public boolean hasNext() {
            return this.zr == 0 && this.yr.isBound();
        }

        public int nextValue() {
            if (this.hasNext()) {
                this.zr = 1;
                return this.yr.getDomainValue();
            }
            throw new NoSuchElementException("No more required for " + this.yr);
        }
    }
}

