/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcReversibleAction;
import ilog.solver.IlcSolver;

public final class IlcRevInt {
    int kz;
    int lz;
    final wr mz;

    public IlcRevInt(int n2) {
        this.kz = n2;
        this.lz = Integer.MIN_VALUE;
        this.mz = new wr(this);
    }

    public IlcRevInt() {
        this(0);
    }

    public int getValue() {
        return this.kz;
    }

    public void setValue(IlcSolver ilcSolver, int n2) {
        if (ilcSolver.sj != this.lz && this.kz != n2) {
            ilcSolver.addReversibleAction(this.mz);
            ilcSolver.qd(this.kz);
            this.lz = ilcSolver.sj;
        }
        this.kz = n2;
    }

    public void incrementValue(IlcSolver ilcSolver, int n2) {
        if (ilcSolver.sj != this.lz && n2 != 0) {
            ilcSolver.addReversibleAction(this.mz);
            ilcSolver.qd(this.kz);
            this.lz = ilcSolver.sj;
        }
        this.kz += n2;
    }

    void qm(int n2) {
        this.kz = n2;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.kz);
        return stringBuffer.toString();
    }

    static final class wr
    extends IlcReversibleAction {
        IlcRevInt wkb;

        wr(IlcRevInt ilcRevInt) {
            this.wkb = ilcRevInt;
        }

        public void restore(IlcSolver ilcSolver) {
            this.wkb.qm(ilcSolver.vd());
        }
    }
}

